// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package essentialcontacts provides access to the Essential Contacts API.
//
// For product documentation, see: https://cloud.google.com/essentialcontacts/docs/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/essentialcontacts/v1"
//   ...
//   ctx := context.Background()
//   essentialcontactsService, err := essentialcontacts.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   essentialcontactsService, err := essentialcontacts.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   essentialcontactsService, err := essentialcontacts.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package essentialcontacts // import "google.golang.org/api/essentialcontacts/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "essentialcontacts:v1"
const apiName = "essentialcontacts"
const apiVersion = "v1"
const basePath = "https://essentialcontacts.googleapis.com/"
const mtlsBasePath = "https://essentialcontacts.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Contacts = NewFoldersContactsService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Contacts *FoldersContactsService
}

func NewFoldersContactsService(s *Service) *FoldersContactsService {
	rs := &FoldersContactsService{s: s}
	return rs
}

type FoldersContactsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Contacts = NewOrganizationsContactsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Contacts *OrganizationsContactsService
}

func NewOrganizationsContactsService(s *Service) *OrganizationsContactsService {
	rs := &OrganizationsContactsService{s: s}
	return rs
}

type OrganizationsContactsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Contacts = NewProjectsContactsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Contacts *ProjectsContactsService
}

func NewProjectsContactsService(s *Service) *ProjectsContactsService {
	rs := &ProjectsContactsService{s: s}
	return rs
}

type ProjectsContactsService struct {
	s *Service
}

// GoogleCloudEssentialcontactsV1ComputeContactsResponse: Response
// message for the ComputeContacts method.
type GoogleCloudEssentialcontactsV1ComputeContactsResponse struct {
	// Contacts: All contacts for the resource that are subscribed to the
	// specified notification categories, including contacts inherited from
	// any parent resources.
	Contacts []*GoogleCloudEssentialcontactsV1Contact `json:"contacts,omitempty"`

	// NextPageToken: If there are more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token`
	// as `page_token` and the rest of the parameters the same as the
	// original request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Contacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudEssentialcontactsV1ComputeContactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudEssentialcontactsV1ComputeContactsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudEssentialcontactsV1Contact: A contact that will receive
// notifications from Google Cloud.
type GoogleCloudEssentialcontactsV1Contact struct {
	// Email: Required. The email address to send notifications to. This
	// does not need to be a Google account.
	Email string `json:"email,omitempty"`

	// LanguageTag: The preferred language for notifications, as a ISO 639-1
	// language code. See Supported languages
	// (https://cloud.google.com/resource-manager/docs/managing-notification-contacts#supported-languages)
	// for a list of supported languages.
	LanguageTag string `json:"languageTag,omitempty"`

	// Name: The identifier for the contact. Format:
	// {resource_type}/{resource_id}/contacts/{contact_id}
	Name string `json:"name,omitempty"`

	// NotificationCategorySubscriptions: The categories of notifications
	// that the contact will receive communications for.
	//
	// Possible values:
	//   "NOTIFICATION_CATEGORY_UNSPECIFIED" - Notification category is
	// unrecognized or unspecified.
	//   "ALL" - All notifications related to the resource, including
	// notifications pertaining to categories added in the future.
	//   "SUSPENSION" - Notifications related to imminent account
	// suspension.
	//   "SECURITY" - Notifications related to security/privacy incidents,
	// notifications, and vulnerabilities.
	//   "TECHNICAL" - Notifications related to technical events and issues
	// such as outages, errors, or bugs.
	//   "BILLING" - Notifications related to billing and payments
	// notifications, price updates, errors, or credits.
	//   "LEGAL" - Notifications related to enforcement actions, regulatory
	// compliance, or government notices.
	//   "PRODUCT_UPDATES" - Notifications related to new versions, product
	// terms updates, or deprecations.
	//   "TECHNICAL_INCIDENTS" - Child category of TECHNICAL. If assigned,
	// technical incident notifications will go to these contacts instead of
	// TECHNICAL.
	NotificationCategorySubscriptions []string `json:"notificationCategorySubscriptions,omitempty"`

	// ValidateTime: The last time the validation_state was updated, either
	// manually or automatically. A contact is considered stale if its
	// validation state was updated more than 1 year ago.
	ValidateTime string `json:"validateTime,omitempty"`

	// ValidationState: The validity of the contact. A contact is considered
	// valid if it is the correct recipient for notifications for a
	// particular resource.
	//
	// Possible values:
	//   "VALIDATION_STATE_UNSPECIFIED" - The validation state is unknown or
	// unspecified.
	//   "VALID" - The contact is marked as valid. This is usually done
	// manually by the contact admin. All new contacts begin in the valid
	// state.
	//   "INVALID" - The contact is considered invalid. This may become the
	// state if the contact's email is found to be unreachable.
	ValidationState string `json:"validationState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudEssentialcontactsV1Contact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudEssentialcontactsV1Contact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudEssentialcontactsV1ListContactsResponse: Response message
// for the ListContacts method.
type GoogleCloudEssentialcontactsV1ListContactsResponse struct {
	// Contacts: The contacts for the specified resource.
	Contacts []*GoogleCloudEssentialcontactsV1Contact `json:"contacts,omitempty"`

	// NextPageToken: If there are more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token`
	// as `page_token` and the rest of the parameters the same as the
	// original request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Contacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudEssentialcontactsV1ListContactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudEssentialcontactsV1ListContactsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudEssentialcontactsV1SendTestMessageRequest: Request message
// for the SendTestMessage method.
type GoogleCloudEssentialcontactsV1SendTestMessageRequest struct {
	// Contacts: Required. The list of names of the contacts to send a test
	// message to. Format:
	// organizations/{organization_id}/contacts/{contact_id},
	// folders/{folder_id}/contacts/{contact_id} or
	// projects/{project_id}/contacts/{contact_id}
	Contacts []string `json:"contacts,omitempty"`

	// NotificationCategory: Required. The notification category to send the
	// test message for. All contacts must be subscribed to this category.
	//
	// Possible values:
	//   "NOTIFICATION_CATEGORY_UNSPECIFIED" - Notification category is
	// unrecognized or unspecified.
	//   "ALL" - All notifications related to the resource, including
	// notifications pertaining to categories added in the future.
	//   "SUSPENSION" - Notifications related to imminent account
	// suspension.
	//   "SECURITY" - Notifications related to security/privacy incidents,
	// notifications, and vulnerabilities.
	//   "TECHNICAL" - Notifications related to technical events and issues
	// such as outages, errors, or bugs.
	//   "BILLING" - Notifications related to billing and payments
	// notifications, price updates, errors, or credits.
	//   "LEGAL" - Notifications related to enforcement actions, regulatory
	// compliance, or government notices.
	//   "PRODUCT_UPDATES" - Notifications related to new versions, product
	// terms updates, or deprecations.
	//   "TECHNICAL_INCIDENTS" - Child category of TECHNICAL. If assigned,
	// technical incident notifications will go to these contacts instead of
	// TECHNICAL.
	NotificationCategory string `json:"notificationCategory,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contacts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contacts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudEssentialcontactsV1SendTestMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudEssentialcontactsV1SendTestMessageRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// method id "essentialcontacts.folders.contacts.compute":

type FoldersContactsComputeCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Compute: Lists all contacts for the resource that are subscribed to
// the specified notification categories, including contacts inherited
// from any parent resources.
//
// - parent: The name of the resource to compute contacts for. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *FoldersContactsService) Compute(parent string) *FoldersContactsComputeCall {
	c := &FoldersContactsComputeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// NotificationCategories sets the optional parameter
// "notificationCategories": The categories of notifications to compute
// contacts for. If ALL is included in this list, contacts subscribed to
// any notification category will be returned.
//
// Possible values:
//   "NOTIFICATION_CATEGORY_UNSPECIFIED" - Notification category is
// unrecognized or unspecified.
//   "ALL" - All notifications related to the resource, including
// notifications pertaining to categories added in the future.
//   "SUSPENSION" - Notifications related to imminent account
// suspension.
//   "SECURITY" - Notifications related to security/privacy incidents,
// notifications, and vulnerabilities.
//   "TECHNICAL" - Notifications related to technical events and issues
// such as outages, errors, or bugs.
//   "BILLING" - Notifications related to billing and payments
// notifications, price updates, errors, or credits.
//   "LEGAL" - Notifications related to enforcement actions, regulatory
// compliance, or government notices.
//   "PRODUCT_UPDATES" - Notifications related to new versions, product
// terms updates, or deprecations.
//   "TECHNICAL_INCIDENTS" - Child category of TECHNICAL. If assigned,
// technical incident notifications will go to these contacts instead of
// TECHNICAL.
func (c *FoldersContactsComputeCall) NotificationCategories(notificationCategories ...string) *FoldersContactsComputeCall {
	c.urlParams_.SetMulti("notificationCategories", append([]string{}, notificationCategories...))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. The presence of `next_page_token` in the response indicates
// that more results might be available. If not specified, the default
// page_size is 100.
func (c *FoldersContactsComputeCall) PageSize(pageSize int64) *FoldersContactsComputeCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters should be
// identical to those in the previous call.
func (c *FoldersContactsComputeCall) PageToken(pageToken string) *FoldersContactsComputeCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsComputeCall) Fields(s ...googleapi.Field) *FoldersContactsComputeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersContactsComputeCall) IfNoneMatch(entityTag string) *FoldersContactsComputeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsComputeCall) Context(ctx context.Context) *FoldersContactsComputeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsComputeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsComputeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts:compute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.compute" call.
// Exactly one of *GoogleCloudEssentialcontactsV1ComputeContactsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudEssentialcontactsV1ComputeContactsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersContactsComputeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1ComputeContactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1ComputeContactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all contacts for the resource that are subscribed to the specified notification categories, including contacts inherited from any parent resources.",
	//   "flatPath": "v1/folders/{foldersId}/contacts:compute",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.folders.contacts.compute",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "notificationCategories": {
	//       "description": "The categories of notifications to compute contacts for. If ALL is included in this list, contacts subscribed to any notification category will be returned.",
	//       "enum": [
	//         "NOTIFICATION_CATEGORY_UNSPECIFIED",
	//         "ALL",
	//         "SUSPENSION",
	//         "SECURITY",
	//         "TECHNICAL",
	//         "BILLING",
	//         "LEGAL",
	//         "PRODUCT_UPDATES",
	//         "TECHNICAL_INCIDENTS"
	//       ],
	//       "enumDescriptions": [
	//         "Notification category is unrecognized or unspecified.",
	//         "All notifications related to the resource, including notifications pertaining to categories added in the future.",
	//         "Notifications related to imminent account suspension.",
	//         "Notifications related to security/privacy incidents, notifications, and vulnerabilities.",
	//         "Notifications related to technical events and issues such as outages, errors, or bugs.",
	//         "Notifications related to billing and payments notifications, price updates, errors, or credits.",
	//         "Notifications related to enforcement actions, regulatory compliance, or government notices.",
	//         "Notifications related to new versions, product terms updates, or deprecations.",
	//         "Child category of TECHNICAL. If assigned, technical incident notifications will go to these contacts instead of TECHNICAL."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. The presence of `next_page_token` in the response indicates that more results might be available. If not specified, the default page_size is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters should be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the resource to compute contacts for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts:compute",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1ComputeContactsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersContactsComputeCall) Pages(ctx context.Context, f func(*GoogleCloudEssentialcontactsV1ComputeContactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "essentialcontacts.folders.contacts.create":

type FoldersContactsCreateCall struct {
	s                                     *Service
	parent                                string
	googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Adds a new contact for a resource.
//
// - parent: The resource to save this contact for. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *FoldersContactsService) Create(parent string, googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact) *FoldersContactsCreateCall {
	c := &FoldersContactsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudessentialcontactsv1contact = googlecloudessentialcontactsv1contact
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsCreateCall) Fields(s ...googleapi.Field) *FoldersContactsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsCreateCall) Context(ctx context.Context) *FoldersContactsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1contact)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.create" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersContactsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds a new contact for a resource.",
	//   "flatPath": "v1/folders/{foldersId}/contacts",
	//   "httpMethod": "POST",
	//   "id": "essentialcontacts.folders.contacts.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.folders.contacts.delete":

type FoldersContactsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a contact.
//
// - name: The name of the contact to delete. Format:
//   organizations/{organization_id}/contacts/{contact_id},
//   folders/{folder_id}/contacts/{contact_id} or
//   projects/{project_id}/contacts/{contact_id}.
func (r *FoldersContactsService) Delete(name string) *FoldersContactsDeleteCall {
	c := &FoldersContactsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsDeleteCall) Fields(s ...googleapi.Field) *FoldersContactsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsDeleteCall) Context(ctx context.Context) *FoldersContactsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersContactsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a contact.",
	//   "flatPath": "v1/folders/{foldersId}/contacts/{contactsId}",
	//   "httpMethod": "DELETE",
	//   "id": "essentialcontacts.folders.contacts.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the contact to delete. Format: organizations/{organization_id}/contacts/{contact_id}, folders/{folder_id}/contacts/{contact_id} or projects/{project_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.folders.contacts.get":

type FoldersContactsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single contact.
//
// - name: The name of the contact to retrieve. Format:
//   organizations/{organization_id}/contacts/{contact_id},
//   folders/{folder_id}/contacts/{contact_id} or
//   projects/{project_id}/contacts/{contact_id}.
func (r *FoldersContactsService) Get(name string) *FoldersContactsGetCall {
	c := &FoldersContactsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsGetCall) Fields(s ...googleapi.Field) *FoldersContactsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersContactsGetCall) IfNoneMatch(entityTag string) *FoldersContactsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsGetCall) Context(ctx context.Context) *FoldersContactsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.get" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersContactsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a single contact.",
	//   "flatPath": "v1/folders/{foldersId}/contacts/{contactsId}",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.folders.contacts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the contact to retrieve. Format: organizations/{organization_id}/contacts/{contact_id}, folders/{folder_id}/contacts/{contact_id} or projects/{project_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.folders.contacts.list":

type FoldersContactsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the contacts that have been set on a resource.
//
// - parent: The parent resource name. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *FoldersContactsService) List(parent string) *FoldersContactsListCall {
	c := &FoldersContactsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. The presence of `next_page_token` in the response indicates
// that more results might be available. If not specified, the default
// page_size is 100.
func (c *FoldersContactsListCall) PageSize(pageSize int64) *FoldersContactsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters should be
// identical to those in the previous call.
func (c *FoldersContactsListCall) PageToken(pageToken string) *FoldersContactsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsListCall) Fields(s ...googleapi.Field) *FoldersContactsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersContactsListCall) IfNoneMatch(entityTag string) *FoldersContactsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsListCall) Context(ctx context.Context) *FoldersContactsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.list" call.
// Exactly one of *GoogleCloudEssentialcontactsV1ListContactsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudEssentialcontactsV1ListContactsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersContactsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1ListContactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1ListContactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the contacts that have been set on a resource.",
	//   "flatPath": "v1/folders/{foldersId}/contacts",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.folders.contacts.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. The presence of `next_page_token` in the response indicates that more results might be available. If not specified, the default page_size is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters should be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1ListContactsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersContactsListCall) Pages(ctx context.Context, f func(*GoogleCloudEssentialcontactsV1ListContactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "essentialcontacts.folders.contacts.patch":

type FoldersContactsPatchCall struct {
	s                                     *Service
	nameid                                string
	googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a contact. Note: A contact's email address cannot be
// changed.
//
// - name: The identifier for the contact. Format:
//   {resource_type}/{resource_id}/contacts/{contact_id}.
func (r *FoldersContactsService) Patch(nameid string, googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact) *FoldersContactsPatchCall {
	c := &FoldersContactsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googlecloudessentialcontactsv1contact = googlecloudessentialcontactsv1contact
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask
// applied to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *FoldersContactsPatchCall) UpdateMask(updateMask string) *FoldersContactsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsPatchCall) Fields(s ...googleapi.Field) *FoldersContactsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsPatchCall) Context(ctx context.Context) *FoldersContactsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1contact)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.patch" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersContactsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a contact. Note: A contact's email address cannot be changed.",
	//   "flatPath": "v1/folders/{foldersId}/contacts/{contactsId}",
	//   "httpMethod": "PATCH",
	//   "id": "essentialcontacts.folders.contacts.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The identifier for the contact. Format: {resource_type}/{resource_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. The update mask applied to the resource. For the `FieldMask` definition, see https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.folders.contacts.sendTestMessage":

type FoldersContactsSendTestMessageCall struct {
	s                                                    *Service
	resource                                             string
	googlecloudessentialcontactsv1sendtestmessagerequest *GoogleCloudEssentialcontactsV1SendTestMessageRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// SendTestMessage: Allows a contact admin to send a test message to
// contact to verify that it has been configured correctly.
//
// - resource: The name of the resource to send the test message for.
//   All contacts must either be set directly on this resource or
//   inherited from another resource that is an ancestor of this one.
//   Format: organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *FoldersContactsService) SendTestMessage(resource string, googlecloudessentialcontactsv1sendtestmessagerequest *GoogleCloudEssentialcontactsV1SendTestMessageRequest) *FoldersContactsSendTestMessageCall {
	c := &FoldersContactsSendTestMessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudessentialcontactsv1sendtestmessagerequest = googlecloudessentialcontactsv1sendtestmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersContactsSendTestMessageCall) Fields(s ...googleapi.Field) *FoldersContactsSendTestMessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersContactsSendTestMessageCall) Context(ctx context.Context) *FoldersContactsSendTestMessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersContactsSendTestMessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersContactsSendTestMessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1sendtestmessagerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}/contacts:sendTestMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.folders.contacts.sendTestMessage" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FoldersContactsSendTestMessageCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Allows a contact admin to send a test message to contact to verify that it has been configured correctly.",
	//   "flatPath": "v1/folders/{foldersId}/contacts:sendTestMessage",
	//   "httpMethod": "POST",
	//   "id": "essentialcontacts.folders.contacts.sendTestMessage",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "Required. The name of the resource to send the test message for. All contacts must either be set directly on this resource or inherited from another resource that is an ancestor of this one. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}/contacts:sendTestMessage",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1SendTestMessageRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.organizations.contacts.compute":

type OrganizationsContactsComputeCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Compute: Lists all contacts for the resource that are subscribed to
// the specified notification categories, including contacts inherited
// from any parent resources.
//
// - parent: The name of the resource to compute contacts for. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *OrganizationsContactsService) Compute(parent string) *OrganizationsContactsComputeCall {
	c := &OrganizationsContactsComputeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// NotificationCategories sets the optional parameter
// "notificationCategories": The categories of notifications to compute
// contacts for. If ALL is included in this list, contacts subscribed to
// any notification category will be returned.
//
// Possible values:
//   "NOTIFICATION_CATEGORY_UNSPECIFIED" - Notification category is
// unrecognized or unspecified.
//   "ALL" - All notifications related to the resource, including
// notifications pertaining to categories added in the future.
//   "SUSPENSION" - Notifications related to imminent account
// suspension.
//   "SECURITY" - Notifications related to security/privacy incidents,
// notifications, and vulnerabilities.
//   "TECHNICAL" - Notifications related to technical events and issues
// such as outages, errors, or bugs.
//   "BILLING" - Notifications related to billing and payments
// notifications, price updates, errors, or credits.
//   "LEGAL" - Notifications related to enforcement actions, regulatory
// compliance, or government notices.
//   "PRODUCT_UPDATES" - Notifications related to new versions, product
// terms updates, or deprecations.
//   "TECHNICAL_INCIDENTS" - Child category of TECHNICAL. If assigned,
// technical incident notifications will go to these contacts instead of
// TECHNICAL.
func (c *OrganizationsContactsComputeCall) NotificationCategories(notificationCategories ...string) *OrganizationsContactsComputeCall {
	c.urlParams_.SetMulti("notificationCategories", append([]string{}, notificationCategories...))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. The presence of `next_page_token` in the response indicates
// that more results might be available. If not specified, the default
// page_size is 100.
func (c *OrganizationsContactsComputeCall) PageSize(pageSize int64) *OrganizationsContactsComputeCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters should be
// identical to those in the previous call.
func (c *OrganizationsContactsComputeCall) PageToken(pageToken string) *OrganizationsContactsComputeCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsComputeCall) Fields(s ...googleapi.Field) *OrganizationsContactsComputeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsContactsComputeCall) IfNoneMatch(entityTag string) *OrganizationsContactsComputeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsComputeCall) Context(ctx context.Context) *OrganizationsContactsComputeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsComputeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsComputeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts:compute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.compute" call.
// Exactly one of *GoogleCloudEssentialcontactsV1ComputeContactsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudEssentialcontactsV1ComputeContactsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsContactsComputeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1ComputeContactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1ComputeContactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all contacts for the resource that are subscribed to the specified notification categories, including contacts inherited from any parent resources.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts:compute",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.organizations.contacts.compute",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "notificationCategories": {
	//       "description": "The categories of notifications to compute contacts for. If ALL is included in this list, contacts subscribed to any notification category will be returned.",
	//       "enum": [
	//         "NOTIFICATION_CATEGORY_UNSPECIFIED",
	//         "ALL",
	//         "SUSPENSION",
	//         "SECURITY",
	//         "TECHNICAL",
	//         "BILLING",
	//         "LEGAL",
	//         "PRODUCT_UPDATES",
	//         "TECHNICAL_INCIDENTS"
	//       ],
	//       "enumDescriptions": [
	//         "Notification category is unrecognized or unspecified.",
	//         "All notifications related to the resource, including notifications pertaining to categories added in the future.",
	//         "Notifications related to imminent account suspension.",
	//         "Notifications related to security/privacy incidents, notifications, and vulnerabilities.",
	//         "Notifications related to technical events and issues such as outages, errors, or bugs.",
	//         "Notifications related to billing and payments notifications, price updates, errors, or credits.",
	//         "Notifications related to enforcement actions, regulatory compliance, or government notices.",
	//         "Notifications related to new versions, product terms updates, or deprecations.",
	//         "Child category of TECHNICAL. If assigned, technical incident notifications will go to these contacts instead of TECHNICAL."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. The presence of `next_page_token` in the response indicates that more results might be available. If not specified, the default page_size is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters should be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the resource to compute contacts for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts:compute",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1ComputeContactsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsContactsComputeCall) Pages(ctx context.Context, f func(*GoogleCloudEssentialcontactsV1ComputeContactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "essentialcontacts.organizations.contacts.create":

type OrganizationsContactsCreateCall struct {
	s                                     *Service
	parent                                string
	googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Adds a new contact for a resource.
//
// - parent: The resource to save this contact for. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *OrganizationsContactsService) Create(parent string, googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact) *OrganizationsContactsCreateCall {
	c := &OrganizationsContactsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudessentialcontactsv1contact = googlecloudessentialcontactsv1contact
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsCreateCall) Fields(s ...googleapi.Field) *OrganizationsContactsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsCreateCall) Context(ctx context.Context) *OrganizationsContactsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1contact)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.create" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsContactsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds a new contact for a resource.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts",
	//   "httpMethod": "POST",
	//   "id": "essentialcontacts.organizations.contacts.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.organizations.contacts.delete":

type OrganizationsContactsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a contact.
//
// - name: The name of the contact to delete. Format:
//   organizations/{organization_id}/contacts/{contact_id},
//   folders/{folder_id}/contacts/{contact_id} or
//   projects/{project_id}/contacts/{contact_id}.
func (r *OrganizationsContactsService) Delete(name string) *OrganizationsContactsDeleteCall {
	c := &OrganizationsContactsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsContactsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsDeleteCall) Context(ctx context.Context) *OrganizationsContactsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsContactsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a contact.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts/{contactsId}",
	//   "httpMethod": "DELETE",
	//   "id": "essentialcontacts.organizations.contacts.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the contact to delete. Format: organizations/{organization_id}/contacts/{contact_id}, folders/{folder_id}/contacts/{contact_id} or projects/{project_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.organizations.contacts.get":

type OrganizationsContactsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single contact.
//
// - name: The name of the contact to retrieve. Format:
//   organizations/{organization_id}/contacts/{contact_id},
//   folders/{folder_id}/contacts/{contact_id} or
//   projects/{project_id}/contacts/{contact_id}.
func (r *OrganizationsContactsService) Get(name string) *OrganizationsContactsGetCall {
	c := &OrganizationsContactsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsGetCall) Fields(s ...googleapi.Field) *OrganizationsContactsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsContactsGetCall) IfNoneMatch(entityTag string) *OrganizationsContactsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsGetCall) Context(ctx context.Context) *OrganizationsContactsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.get" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsContactsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a single contact.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts/{contactsId}",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.organizations.contacts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the contact to retrieve. Format: organizations/{organization_id}/contacts/{contact_id}, folders/{folder_id}/contacts/{contact_id} or projects/{project_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.organizations.contacts.list":

type OrganizationsContactsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the contacts that have been set on a resource.
//
// - parent: The parent resource name. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *OrganizationsContactsService) List(parent string) *OrganizationsContactsListCall {
	c := &OrganizationsContactsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. The presence of `next_page_token` in the response indicates
// that more results might be available. If not specified, the default
// page_size is 100.
func (c *OrganizationsContactsListCall) PageSize(pageSize int64) *OrganizationsContactsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters should be
// identical to those in the previous call.
func (c *OrganizationsContactsListCall) PageToken(pageToken string) *OrganizationsContactsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsListCall) Fields(s ...googleapi.Field) *OrganizationsContactsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsContactsListCall) IfNoneMatch(entityTag string) *OrganizationsContactsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsListCall) Context(ctx context.Context) *OrganizationsContactsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.list" call.
// Exactly one of *GoogleCloudEssentialcontactsV1ListContactsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudEssentialcontactsV1ListContactsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsContactsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1ListContactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1ListContactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the contacts that have been set on a resource.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.organizations.contacts.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. The presence of `next_page_token` in the response indicates that more results might be available. If not specified, the default page_size is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters should be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1ListContactsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsContactsListCall) Pages(ctx context.Context, f func(*GoogleCloudEssentialcontactsV1ListContactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "essentialcontacts.organizations.contacts.patch":

type OrganizationsContactsPatchCall struct {
	s                                     *Service
	nameid                                string
	googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a contact. Note: A contact's email address cannot be
// changed.
//
// - name: The identifier for the contact. Format:
//   {resource_type}/{resource_id}/contacts/{contact_id}.
func (r *OrganizationsContactsService) Patch(nameid string, googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact) *OrganizationsContactsPatchCall {
	c := &OrganizationsContactsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googlecloudessentialcontactsv1contact = googlecloudessentialcontactsv1contact
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask
// applied to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *OrganizationsContactsPatchCall) UpdateMask(updateMask string) *OrganizationsContactsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsPatchCall) Fields(s ...googleapi.Field) *OrganizationsContactsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsPatchCall) Context(ctx context.Context) *OrganizationsContactsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1contact)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.patch" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsContactsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a contact. Note: A contact's email address cannot be changed.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts/{contactsId}",
	//   "httpMethod": "PATCH",
	//   "id": "essentialcontacts.organizations.contacts.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The identifier for the contact. Format: {resource_type}/{resource_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. The update mask applied to the resource. For the `FieldMask` definition, see https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.organizations.contacts.sendTestMessage":

type OrganizationsContactsSendTestMessageCall struct {
	s                                                    *Service
	resource                                             string
	googlecloudessentialcontactsv1sendtestmessagerequest *GoogleCloudEssentialcontactsV1SendTestMessageRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// SendTestMessage: Allows a contact admin to send a test message to
// contact to verify that it has been configured correctly.
//
// - resource: The name of the resource to send the test message for.
//   All contacts must either be set directly on this resource or
//   inherited from another resource that is an ancestor of this one.
//   Format: organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *OrganizationsContactsService) SendTestMessage(resource string, googlecloudessentialcontactsv1sendtestmessagerequest *GoogleCloudEssentialcontactsV1SendTestMessageRequest) *OrganizationsContactsSendTestMessageCall {
	c := &OrganizationsContactsSendTestMessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudessentialcontactsv1sendtestmessagerequest = googlecloudessentialcontactsv1sendtestmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsContactsSendTestMessageCall) Fields(s ...googleapi.Field) *OrganizationsContactsSendTestMessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsContactsSendTestMessageCall) Context(ctx context.Context) *OrganizationsContactsSendTestMessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsContactsSendTestMessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsContactsSendTestMessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1sendtestmessagerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}/contacts:sendTestMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.organizations.contacts.sendTestMessage" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsContactsSendTestMessageCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Allows a contact admin to send a test message to contact to verify that it has been configured correctly.",
	//   "flatPath": "v1/organizations/{organizationsId}/contacts:sendTestMessage",
	//   "httpMethod": "POST",
	//   "id": "essentialcontacts.organizations.contacts.sendTestMessage",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "Required. The name of the resource to send the test message for. All contacts must either be set directly on this resource or inherited from another resource that is an ancestor of this one. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}/contacts:sendTestMessage",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1SendTestMessageRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.projects.contacts.compute":

type ProjectsContactsComputeCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Compute: Lists all contacts for the resource that are subscribed to
// the specified notification categories, including contacts inherited
// from any parent resources.
//
// - parent: The name of the resource to compute contacts for. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *ProjectsContactsService) Compute(parent string) *ProjectsContactsComputeCall {
	c := &ProjectsContactsComputeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// NotificationCategories sets the optional parameter
// "notificationCategories": The categories of notifications to compute
// contacts for. If ALL is included in this list, contacts subscribed to
// any notification category will be returned.
//
// Possible values:
//   "NOTIFICATION_CATEGORY_UNSPECIFIED" - Notification category is
// unrecognized or unspecified.
//   "ALL" - All notifications related to the resource, including
// notifications pertaining to categories added in the future.
//   "SUSPENSION" - Notifications related to imminent account
// suspension.
//   "SECURITY" - Notifications related to security/privacy incidents,
// notifications, and vulnerabilities.
//   "TECHNICAL" - Notifications related to technical events and issues
// such as outages, errors, or bugs.
//   "BILLING" - Notifications related to billing and payments
// notifications, price updates, errors, or credits.
//   "LEGAL" - Notifications related to enforcement actions, regulatory
// compliance, or government notices.
//   "PRODUCT_UPDATES" - Notifications related to new versions, product
// terms updates, or deprecations.
//   "TECHNICAL_INCIDENTS" - Child category of TECHNICAL. If assigned,
// technical incident notifications will go to these contacts instead of
// TECHNICAL.
func (c *ProjectsContactsComputeCall) NotificationCategories(notificationCategories ...string) *ProjectsContactsComputeCall {
	c.urlParams_.SetMulti("notificationCategories", append([]string{}, notificationCategories...))
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. The presence of `next_page_token` in the response indicates
// that more results might be available. If not specified, the default
// page_size is 100.
func (c *ProjectsContactsComputeCall) PageSize(pageSize int64) *ProjectsContactsComputeCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters should be
// identical to those in the previous call.
func (c *ProjectsContactsComputeCall) PageToken(pageToken string) *ProjectsContactsComputeCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsComputeCall) Fields(s ...googleapi.Field) *ProjectsContactsComputeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsContactsComputeCall) IfNoneMatch(entityTag string) *ProjectsContactsComputeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsComputeCall) Context(ctx context.Context) *ProjectsContactsComputeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsComputeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsComputeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts:compute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.compute" call.
// Exactly one of *GoogleCloudEssentialcontactsV1ComputeContactsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudEssentialcontactsV1ComputeContactsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsContactsComputeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1ComputeContactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1ComputeContactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all contacts for the resource that are subscribed to the specified notification categories, including contacts inherited from any parent resources.",
	//   "flatPath": "v1/projects/{projectsId}/contacts:compute",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.projects.contacts.compute",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "notificationCategories": {
	//       "description": "The categories of notifications to compute contacts for. If ALL is included in this list, contacts subscribed to any notification category will be returned.",
	//       "enum": [
	//         "NOTIFICATION_CATEGORY_UNSPECIFIED",
	//         "ALL",
	//         "SUSPENSION",
	//         "SECURITY",
	//         "TECHNICAL",
	//         "BILLING",
	//         "LEGAL",
	//         "PRODUCT_UPDATES",
	//         "TECHNICAL_INCIDENTS"
	//       ],
	//       "enumDescriptions": [
	//         "Notification category is unrecognized or unspecified.",
	//         "All notifications related to the resource, including notifications pertaining to categories added in the future.",
	//         "Notifications related to imminent account suspension.",
	//         "Notifications related to security/privacy incidents, notifications, and vulnerabilities.",
	//         "Notifications related to technical events and issues such as outages, errors, or bugs.",
	//         "Notifications related to billing and payments notifications, price updates, errors, or credits.",
	//         "Notifications related to enforcement actions, regulatory compliance, or government notices.",
	//         "Notifications related to new versions, product terms updates, or deprecations.",
	//         "Child category of TECHNICAL. If assigned, technical incident notifications will go to these contacts instead of TECHNICAL."
	//       ],
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. The presence of `next_page_token` in the response indicates that more results might be available. If not specified, the default page_size is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters should be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the resource to compute contacts for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts:compute",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1ComputeContactsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsContactsComputeCall) Pages(ctx context.Context, f func(*GoogleCloudEssentialcontactsV1ComputeContactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "essentialcontacts.projects.contacts.create":

type ProjectsContactsCreateCall struct {
	s                                     *Service
	parent                                string
	googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Adds a new contact for a resource.
//
// - parent: The resource to save this contact for. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *ProjectsContactsService) Create(parent string, googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact) *ProjectsContactsCreateCall {
	c := &ProjectsContactsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudessentialcontactsv1contact = googlecloudessentialcontactsv1contact
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsCreateCall) Fields(s ...googleapi.Field) *ProjectsContactsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsCreateCall) Context(ctx context.Context) *ProjectsContactsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1contact)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.create" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsContactsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds a new contact for a resource.",
	//   "flatPath": "v1/projects/{projectsId}/contacts",
	//   "httpMethod": "POST",
	//   "id": "essentialcontacts.projects.contacts.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.projects.contacts.delete":

type ProjectsContactsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a contact.
//
// - name: The name of the contact to delete. Format:
//   organizations/{organization_id}/contacts/{contact_id},
//   folders/{folder_id}/contacts/{contact_id} or
//   projects/{project_id}/contacts/{contact_id}.
func (r *ProjectsContactsService) Delete(name string) *ProjectsContactsDeleteCall {
	c := &ProjectsContactsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsDeleteCall) Fields(s ...googleapi.Field) *ProjectsContactsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsDeleteCall) Context(ctx context.Context) *ProjectsContactsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsContactsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a contact.",
	//   "flatPath": "v1/projects/{projectsId}/contacts/{contactsId}",
	//   "httpMethod": "DELETE",
	//   "id": "essentialcontacts.projects.contacts.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the contact to delete. Format: organizations/{organization_id}/contacts/{contact_id}, folders/{folder_id}/contacts/{contact_id} or projects/{project_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.projects.contacts.get":

type ProjectsContactsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single contact.
//
// - name: The name of the contact to retrieve. Format:
//   organizations/{organization_id}/contacts/{contact_id},
//   folders/{folder_id}/contacts/{contact_id} or
//   projects/{project_id}/contacts/{contact_id}.
func (r *ProjectsContactsService) Get(name string) *ProjectsContactsGetCall {
	c := &ProjectsContactsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsGetCall) Fields(s ...googleapi.Field) *ProjectsContactsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsContactsGetCall) IfNoneMatch(entityTag string) *ProjectsContactsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsGetCall) Context(ctx context.Context) *ProjectsContactsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.get" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsContactsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a single contact.",
	//   "flatPath": "v1/projects/{projectsId}/contacts/{contactsId}",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.projects.contacts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the contact to retrieve. Format: organizations/{organization_id}/contacts/{contact_id}, folders/{folder_id}/contacts/{contact_id} or projects/{project_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.projects.contacts.list":

type ProjectsContactsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the contacts that have been set on a resource.
//
// - parent: The parent resource name. Format:
//   organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *ProjectsContactsService) List(parent string) *ProjectsContactsListCall {
	c := &ProjectsContactsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return from this request. Non-positive values are
// ignored. The presence of `next_page_token` in the response indicates
// that more results might be available. If not specified, the default
// page_size is 100.
func (c *ProjectsContactsListCall) PageSize(pageSize int64) *ProjectsContactsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieves the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of other method parameters should be
// identical to those in the previous call.
func (c *ProjectsContactsListCall) PageToken(pageToken string) *ProjectsContactsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsListCall) Fields(s ...googleapi.Field) *ProjectsContactsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsContactsListCall) IfNoneMatch(entityTag string) *ProjectsContactsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsListCall) Context(ctx context.Context) *ProjectsContactsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/contacts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.list" call.
// Exactly one of *GoogleCloudEssentialcontactsV1ListContactsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudEssentialcontactsV1ListContactsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsContactsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1ListContactsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1ListContactsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the contacts that have been set on a resource.",
	//   "flatPath": "v1/projects/{projectsId}/contacts",
	//   "httpMethod": "GET",
	//   "id": "essentialcontacts.projects.contacts.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. The maximum number of results to return from this request. Non-positive values are ignored. The presence of `next_page_token` in the response indicates that more results might be available. If not specified, the default page_size is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieves the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of other method parameters should be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/contacts",
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1ListContactsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsContactsListCall) Pages(ctx context.Context, f func(*GoogleCloudEssentialcontactsV1ListContactsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "essentialcontacts.projects.contacts.patch":

type ProjectsContactsPatchCall struct {
	s                                     *Service
	nameid                                string
	googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a contact. Note: A contact's email address cannot be
// changed.
//
// - name: The identifier for the contact. Format:
//   {resource_type}/{resource_id}/contacts/{contact_id}.
func (r *ProjectsContactsService) Patch(nameid string, googlecloudessentialcontactsv1contact *GoogleCloudEssentialcontactsV1Contact) *ProjectsContactsPatchCall {
	c := &ProjectsContactsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.googlecloudessentialcontactsv1contact = googlecloudessentialcontactsv1contact
	return c
}

// UpdateMask sets the optional parameter "updateMask": The update mask
// applied to the resource. For the `FieldMask` definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
func (c *ProjectsContactsPatchCall) UpdateMask(updateMask string) *ProjectsContactsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsPatchCall) Fields(s ...googleapi.Field) *ProjectsContactsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsPatchCall) Context(ctx context.Context) *ProjectsContactsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1contact)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.patch" call.
// Exactly one of *GoogleCloudEssentialcontactsV1Contact or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudEssentialcontactsV1Contact.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsContactsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudEssentialcontactsV1Contact, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudEssentialcontactsV1Contact{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a contact. Note: A contact's email address cannot be changed.",
	//   "flatPath": "v1/projects/{projectsId}/contacts/{contactsId}",
	//   "httpMethod": "PATCH",
	//   "id": "essentialcontacts.projects.contacts.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The identifier for the contact. Format: {resource_type}/{resource_id}/contacts/{contact_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/contacts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. The update mask applied to the resource. For the `FieldMask` definition, see https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudEssentialcontactsV1Contact"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "essentialcontacts.projects.contacts.sendTestMessage":

type ProjectsContactsSendTestMessageCall struct {
	s                                                    *Service
	resource                                             string
	googlecloudessentialcontactsv1sendtestmessagerequest *GoogleCloudEssentialcontactsV1SendTestMessageRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// SendTestMessage: Allows a contact admin to send a test message to
// contact to verify that it has been configured correctly.
//
// - resource: The name of the resource to send the test message for.
//   All contacts must either be set directly on this resource or
//   inherited from another resource that is an ancestor of this one.
//   Format: organizations/{organization_id}, folders/{folder_id} or
//   projects/{project_id}.
func (r *ProjectsContactsService) SendTestMessage(resource string, googlecloudessentialcontactsv1sendtestmessagerequest *GoogleCloudEssentialcontactsV1SendTestMessageRequest) *ProjectsContactsSendTestMessageCall {
	c := &ProjectsContactsSendTestMessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googlecloudessentialcontactsv1sendtestmessagerequest = googlecloudessentialcontactsv1sendtestmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsContactsSendTestMessageCall) Fields(s ...googleapi.Field) *ProjectsContactsSendTestMessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsContactsSendTestMessageCall) Context(ctx context.Context) *ProjectsContactsSendTestMessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsContactsSendTestMessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContactsSendTestMessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudessentialcontactsv1sendtestmessagerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}/contacts:sendTestMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "essentialcontacts.projects.contacts.sendTestMessage" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsContactsSendTestMessageCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Allows a contact admin to send a test message to contact to verify that it has been configured correctly.",
	//   "flatPath": "v1/projects/{projectsId}/contacts:sendTestMessage",
	//   "httpMethod": "POST",
	//   "id": "essentialcontacts.projects.contacts.sendTestMessage",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "Required. The name of the resource to send the test message for. All contacts must either be set directly on this resource or inherited from another resource that is an ancestor of this one. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}/contacts:sendTestMessage",
	//   "request": {
	//     "$ref": "GoogleCloudEssentialcontactsV1SendTestMessageRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
