// Copyright 2022 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package sts provides access to the Security Token Service API.
//
// For product documentation, see: http://cloud.google.com/iam/docs/workload-identity-federation
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/sts/v1beta"
//   ...
//   ctx := context.Background()
//   stsService, err := sts.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   stsService, err := sts.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   stsService, err := sts.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package sts // import "google.golang.org/api/sts/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "sts:v1beta"
const apiName = "sts"
const apiVersion = "v1beta"
const basePath = "https://sts.googleapis.com/"
const mtlsBasePath = "https://sts.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.V1beta = NewV1betaService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	V1beta *V1betaService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewV1betaService(s *Service) *V1betaService {
	rs := &V1betaService{s: s}
	return rs
}

type V1betaService struct {
	s *Service
}

// GoogleIamV1Binding: Associates `members`, or principals, with a
// `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Cloud
	// Platform resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. *
	// `user:{emailid}`: An email address that represents a specific Google
	// account. For example, `alice@example.com` . *
	// `serviceAccount:{emailid}`: An email address that represents a
	// service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An
	// email address that represents a Google group. For example,
	// `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An
	// email address (plus unique identifier) representing a user that has
	// been recently deleted. For example,
	// `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered
	// user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding. * `domain:{domain}`: The G
	// Suite domain (primary) that represents all the users of that domain.
	// For example, `google.com` or `example.com`.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1AccessBoundary: An access boundary defines the
// upper bound of what a principal may access. It includes a list of
// access boundary rules that each defines the resource that may be
// allowed as well as permissions that may be used on those resources.
type GoogleIdentityStsV1AccessBoundary struct {
	// AccessBoundaryRules: A list of access boundary rules which defines
	// the upper bound of the permission a principal may carry. If multiple
	// rules are specified, the effective access boundary is the union of
	// all the access boundary rules attached. One access boundary can
	// contain at most 10 rules.
	AccessBoundaryRules []*GoogleIdentityStsV1AccessBoundaryRule `json:"accessBoundaryRules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundaryRules")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundaryRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1AccessBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1AccessBoundary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1AccessBoundaryRule: An access boundary rule
// defines an upper bound of IAM permissions on a single resource.
type GoogleIdentityStsV1AccessBoundaryRule struct {
	// AvailabilityCondition: The availability condition further constrains
	// the access allowed by the access boundary rule. If the condition
	// evaluates to `true`, then this access boundary rule will provide
	// access to the specified resource, assuming the principal has the
	// required permissions for the resource. If the condition does not
	// evaluate to `true`, then access to the specified resource will not be
	// available. Note that all access boundary rules in an access boundary
	// are evaluated together as a union. As such, another access boundary
	// rule may allow access to the resource, even if this access boundary
	// rule does not allow access. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies). The
	// maximum length of the `expression` field is 2048 characters.
	AvailabilityCondition *GoogleTypeExpr `json:"availabilityCondition,omitempty"`

	// AvailablePermissions: A list of permissions that may be allowed for
	// use on the specified resource. The only supported values in the list
	// are IAM roles, following the format of google.iam.v1.Binding.role.
	// Example value: `inRole:roles/logging.viewer` for predefined roles and
	// `inRole:organizations/{ORGANIZATION_ID}/roles/logging.viewer` for
	// custom roles.
	AvailablePermissions []string `json:"availablePermissions,omitempty"`

	// AvailableResource: The full resource name of a Google Cloud resource
	// entity. The format definition is at
	// https://cloud.google.com/apis/design/resource_names. Example value:
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	AvailableResource string `json:"availableResource,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AvailabilityCondition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailabilityCondition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1AccessBoundaryRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1AccessBoundaryRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1Options: An `Options` object configures features
// that the Security Token Service supports, but that are not supported
// by standard OAuth 2.0 token exchange endpoints, as defined in
// https://tools.ietf.org/html/rfc8693.
type GoogleIdentityStsV1Options struct {
	// AccessBoundary: An access boundary that defines the upper bound of
	// permissions the credential may have. The value should be a JSON
	// object of AccessBoundary. The access boundary can include up to 10
	// rules. The size of the parameter value should not exceed 2048
	// characters.
	AccessBoundary *GoogleIdentityStsV1AccessBoundary `json:"accessBoundary,omitempty"`

	// Audiences: The intended audience(s) of the credential. The audience
	// value(s) should be the name(s) of services intended to receive the
	// credential. Example: `["https://pubsub.googleapis.com/",
	// "https://storage.googleapis.com/"]`. A maximum of 5 audiences can be
	// included. For each provided audience, the maximum length is 262
	// characters.
	Audiences []string `json:"audiences,omitempty"`

	// UserProject: A Google project used for quota and billing purposes
	// when the credential is used to access Google APIs. The provided
	// project overrides the project bound to the credential. The value must
	// be a project number or a project ID. Example:
	// `my-sample-project-191923`. The maximum length is 32 characters.
	UserProject string `json:"userProject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1Options) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1Options
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaAccessBoundary: An access boundary defines the
// upper bound of what a principal may access. It includes a list of
// access boundary rules that each defines the resource that may be
// allowed as well as permissions that may be used on those resources.
type GoogleIdentityStsV1betaAccessBoundary struct {
	// AccessBoundaryRules: A list of access boundary rules which defines
	// the upper bound of the permission a principal may carry. If multiple
	// rules are specified, the effective access boundary is the union of
	// all the access boundary rules attached. One access boundary can
	// contain at most 10 rules.
	AccessBoundaryRules []*GoogleIdentityStsV1betaAccessBoundaryRule `json:"accessBoundaryRules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundaryRules")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundaryRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaAccessBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaAccessBoundary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaAccessBoundaryRule: An access boundary rule
// defines an upper bound of IAM permissions on a single resource.
type GoogleIdentityStsV1betaAccessBoundaryRule struct {
	// AvailabilityCondition: The availability condition further constrains
	// the access allowed by the access boundary rule. If the condition
	// evaluates to `true`, then this access boundary rule will provide
	// access to the specified resource, assuming the principal has the
	// required permissions for the resource. If the condition does not
	// evaluate to `true`, then access to the specified resource will not be
	// available. Note that all access boundary rules in an access boundary
	// are evaluated together as a union. As such, another access boundary
	// rule may allow access to the resource, even if this access boundary
	// rule does not allow access. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies). The
	// maximum length of the `expression` field is 2048 characters.
	AvailabilityCondition *GoogleTypeExpr `json:"availabilityCondition,omitempty"`

	// AvailablePermissions: A list of permissions that may be allowed for
	// use on the specified resource. The only supported values in the list
	// are IAM roles, following the format of google.iam.v1.Binding.role.
	// Example value: `inRole:roles/logging.viewer` for predefined roles and
	// `inRole:organizations/{ORGANIZATION_ID}/roles/logging.viewer` for
	// custom roles.
	AvailablePermissions []string `json:"availablePermissions,omitempty"`

	// AvailableResource: The full resource name of a Google Cloud resource
	// entity. The format definition is at
	// https://cloud.google.com/apis/design/resource_names. Example value:
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	AvailableResource string `json:"availableResource,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AvailabilityCondition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailabilityCondition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaAccessBoundaryRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaAccessBoundaryRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaExchangeTokenRequest: Request message for
// ExchangeToken.
type GoogleIdentityStsV1betaExchangeTokenRequest struct {
	// Audience: The full resource name of the identity provider. For
	// example,
	// `//iam.googleapis.com/projects//locations/global/workloadIdentityPools
	// //providers/`. Required when exchanging an external credential for a
	// Google access token.
	Audience string `json:"audience,omitempty"`

	// GrantType: Required. The grant type. Must be
	// `urn:ietf:params:oauth:grant-type:token-exchange`, which indicates a
	// token exchange.
	GrantType string `json:"grantType,omitempty"`

	// Options: A set of features that Security Token Service supports, in
	// addition to the standard OAuth 2.0 token exchange, formatted as a
	// serialized JSON object of Options.
	Options string `json:"options,omitempty"`

	// RequestedTokenType: Required. The type of security token. Must be
	// `urn:ietf:params:oauth:token-type:access_token`, which indicates an
	// OAuth 2.0 access token.
	RequestedTokenType string `json:"requestedTokenType,omitempty"`

	// Scope: The OAuth 2.0 scopes to include on the resulting access token,
	// formatted as a list of space-delimited, case-sensitive strings.
	// Required when exchanging an external credential for a Google access
	// token.
	Scope string `json:"scope,omitempty"`

	// SubjectToken: Required. The input token. This token is either an
	// external credential issued by a workload identity pool provider, or a
	// short-lived access token issued by Google. If the token is an OIDC
	// JWT, it must use the JWT format defined in RFC 7523
	// (https://tools.ietf.org/html/rfc7523), and the `subject_token_type`
	// must be either `urn:ietf:params:oauth:token-type:jwt` or
	// `urn:ietf:params:oauth:token-type:id_token`. The following headers
	// are required: - `kid`: The identifier of the signing key securing the
	// JWT. - `alg`: The cryptographic algorithm securing the JWT. Must be
	// `RS256` or `ES256`. The following payload fields are required. For
	// more information, see RFC 7523, Section 3
	// (https://tools.ietf.org/html/rfc7523#section-3): - `iss`: The issuer
	// of the token. The issuer must provide a discovery document at the URL
	// `/.well-known/openid-configuration`, where `` is the value of this
	// field. The document must be formatted according to section 4.2 of the
	// OIDC 1.0 Discovery specification
	// (https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderConfigurationResponse).
	// - `iat`: The issue time, in seconds, since the Unix epoch. Must be in
	// the past. - `exp`: The expiration time, in seconds, since the Unix
	// epoch. Must be less than 48 hours after `iat`. Shorter expiration
	// times are more secure. If possible, we recommend setting an
	// expiration time less than 6 hours. - `sub`: The identity asserted in
	// the JWT. - `aud`: For workload identity pools, this must be a value
	// specified in the allowed audiences for the workload identity pool
	// provider, or one of the audiences allowed by default if no audiences
	// were specified. See
	// https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.workloadIdentityPools.providers#oidc
	// Example header: ``` { "alg": "RS256", "kid": "us-east-11" } ```
	// Example payload: ``` { "iss": "https://accounts.google.com", "iat":
	// 1517963104, "exp": 1517966704, "aud":
	// "//iam.googleapis.com/projects/1234567890123/locations/global/workload
	// IdentityPools/my-pool/providers/my-provider", "sub":
	// "113475438248934895348", "my_claims": { "additional_claim": "value" }
	// } ``` If `subject_token` is for AWS, it must be a serialized
	// `GetCallerIdentity` token. This token contains the same information
	// as a request to the AWS `GetCallerIdentity()`
	// (https://docs.aws.amazon.com/STS/latest/APIReference/API_GetCallerIdentity)
	// method, as well as the AWS signature
	// (https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
	// for the request information. Use Signature Version 4. Format the
	// request as URL-encoded JSON, and set the `subject_token_type`
	// parameter to `urn:ietf:params:aws:token-type:aws4_request`. The
	// following parameters are required: - `url`: The URL of the AWS STS
	// endpoint for `GetCallerIdentity()`, such as
	// `https://sts.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15
	// `. Regional endpoints are also supported. - `method`: The HTTP
	// request method: `POST`. - `headers`: The HTTP request headers, which
	// must include: - `Authorization`: The request signature. -
	// `x-amz-date`: The time you will send the request, formatted as an
	// ISO8601 Basic
	// (https://docs.aws.amazon.com/general/latest/gr/sigv4_elements.html#sigv4_elements_date)
	// string. This value is typically set to the current time and is used
	// to help prevent replay attacks. - `host`: The hostname of the `url`
	// field; for example, `sts.amazonaws.com`. -
	// `x-goog-cloud-target-resource`: The full, canonical resource name of
	// the workload identity pool provider, with or without an `https:`
	// prefix. To help ensure data integrity, we recommend including this
	// header in the `SignedHeaders` field of the signed request. For
	// example:
	// //iam.googleapis.com/projects//locations/global/workloadIdentityPools/
	// /providers/
	// https://iam.googleapis.com/projects//locations/global/workloadIdentityPools//providers/
	// If you are using temporary security credentials provided by AWS, you
	// must also include the header `x-amz-security-token`, with the value
	// set to the session token. The following example shows a
	// `GetCallerIdentity` token: ``` { "headers": [ {"key": "x-amz-date",
	// "value": "20200815T015049Z"}, {"key": "Authorization", "value":
	// "AWS4-HMAC-SHA256+Credential=$credential,+SignedHeaders=host;x-amz-dat
	// e;x-goog-cloud-target-resource,+Signature=$signature"}, {"key":
	// "x-goog-cloud-target-resource", "value":
	// "//iam.googleapis.com/projects//locations/global/workloadIdentityPools
	// //providers/"}, {"key": "host", "value": "sts.amazonaws.com"} . ],
	// "method": "POST", "url":
	// "https://sts.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15
	// " } ``` You can also use a Google-issued OAuth 2.0 access token with
	// this field to obtain an access token with new security attributes
	// applied, such as a Credential Access Boundary. In this case, set
	// `subject_token_type` to
	// `urn:ietf:params:oauth:token-type:access_token`. If an access token
	// already contains security attributes, you cannot apply additional
	// security attributes.
	SubjectToken string `json:"subjectToken,omitempty"`

	// SubjectTokenType: Required. An identifier that indicates the type of
	// the security token in the `subject_token` parameter. Supported values
	// are `urn:ietf:params:oauth:token-type:jwt`,
	// `urn:ietf:params:oauth:token-type:id_token`,
	// `urn:ietf:params:aws:token-type:aws4_request`, and
	// `urn:ietf:params:oauth:token-type:access_token`.
	SubjectTokenType string `json:"subjectTokenType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Audience") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audience") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaExchangeTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaExchangeTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaExchangeTokenResponse: Response message for
// ExchangeToken.
type GoogleIdentityStsV1betaExchangeTokenResponse struct {
	// AccessToken: An OAuth 2.0 security token, issued by Google, in
	// response to the token exchange request. Tokens can vary in size,
	// depending in part on the size of mapped claims, up to a maximum of
	// 12288 bytes (12 KB). Google reserves the right to change the token
	// size and the maximum length at any time.
	AccessToken string `json:"access_token,omitempty"`

	// ExpiresIn: The amount of time, in seconds, between the time when the
	// access token was issued and the time when the access token will
	// expire. This field is absent when the `subject_token` in the request
	// is a Google-issued, short-lived access token. In this case, the
	// access token has the same expiration time as the `subject_token`.
	ExpiresIn int64 `json:"expires_in,omitempty"`

	// IssuedTokenType: The token type. Always matches the value of
	// `requested_token_type` from the request.
	IssuedTokenType string `json:"issued_token_type,omitempty"`

	// TokenType: The type of access token. Always has the value `Bearer`.
	TokenType string `json:"token_type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaExchangeTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaExchangeTokenResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityStsV1betaOptions: An `Options` object configures
// features that the Security Token Service supports, but that are not
// supported by standard OAuth 2.0 token exchange endpoints, as defined
// in https://tools.ietf.org/html/rfc8693.
type GoogleIdentityStsV1betaOptions struct {
	// AccessBoundary: An access boundary that defines the upper bound of
	// permissions the credential may have. The value should be a JSON
	// object of AccessBoundary. The access boundary can include up to 10
	// rules. The size of the parameter value should not exceed 2048
	// characters.
	AccessBoundary *GoogleIdentityStsV1betaAccessBoundary `json:"accessBoundary,omitempty"`

	// Audiences: The intended audience(s) of the credential. The audience
	// value(s) should be the name(s) of services intended to receive the
	// credential. Example: `["https://pubsub.googleapis.com/",
	// "https://storage.googleapis.com/"]`. A maximum of 5 audiences can be
	// included. For each provided audience, the maximum length is 262
	// characters.
	Audiences []string `json:"audiences,omitempty"`

	// UserProject: A Google project used for quota and billing purposes
	// when the credential is used to access Google APIs. The provided
	// project overrides the project bound to the credential. The value must
	// be a project number or a project ID. Example:
	// `my-sample-project-191923`. The maximum length is 32 characters.
	UserProject string `json:"userProject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBoundary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBoundary") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityStsV1betaOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityStsV1betaOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common
// Expression Language (CEL) syntax. CEL is a C-like expression
// language. The syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "sts.token":

type V1betaTokenCall struct {
	s                                           *Service
	googleidentitystsv1betaexchangetokenrequest *GoogleIdentityStsV1betaExchangeTokenRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Token: Exchanges a credential for a Google OAuth 2.0 access token.
// The token asserts an external identity within a workload identity
// pool, or it applies a Credential Access Boundary to a Google access
// token. When you call this method, do not send the `Authorization`
// HTTP header in the request. This method does not require the
// `Authorization` header, and using the header can cause the request to
// fail.
func (r *V1betaService) Token(googleidentitystsv1betaexchangetokenrequest *GoogleIdentityStsV1betaExchangeTokenRequest) *V1betaTokenCall {
	c := &V1betaTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleidentitystsv1betaexchangetokenrequest = googleidentitystsv1betaexchangetokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1betaTokenCall) Fields(s ...googleapi.Field) *V1betaTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1betaTokenCall) Context(ctx context.Context) *V1betaTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1betaTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1betaTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleidentitystsv1betaexchangetokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/token")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sts.token" call.
// Exactly one of *GoogleIdentityStsV1betaExchangeTokenResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleIdentityStsV1betaExchangeTokenResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *V1betaTokenCall) Do(opts ...googleapi.CallOption) (*GoogleIdentityStsV1betaExchangeTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleIdentityStsV1betaExchangeTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Exchanges a credential for a Google OAuth 2.0 access token. The token asserts an external identity within a workload identity pool, or it applies a Credential Access Boundary to a Google access token. When you call this method, do not send the `Authorization` HTTP header in the request. This method does not require the `Authorization` header, and using the header can cause the request to fail.",
	//   "flatPath": "v1beta/token",
	//   "httpMethod": "POST",
	//   "id": "sts.token",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta/token",
	//   "request": {
	//     "$ref": "GoogleIdentityStsV1betaExchangeTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIdentityStsV1betaExchangeTokenResponse"
	//   }
	// }

}
