// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/featurestore_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FeaturestoreService_CreateFeaturestore_FullMethodName     = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/CreateFeaturestore"
	FeaturestoreService_GetFeaturestore_FullMethodName        = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/GetFeaturestore"
	FeaturestoreService_ListFeaturestores_FullMethodName      = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/ListFeaturestores"
	FeaturestoreService_UpdateFeaturestore_FullMethodName     = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/UpdateFeaturestore"
	FeaturestoreService_DeleteFeaturestore_FullMethodName     = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/DeleteFeaturestore"
	FeaturestoreService_CreateEntityType_FullMethodName       = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/CreateEntityType"
	FeaturestoreService_GetEntityType_FullMethodName          = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/GetEntityType"
	FeaturestoreService_ListEntityTypes_FullMethodName        = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/ListEntityTypes"
	FeaturestoreService_UpdateEntityType_FullMethodName       = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/UpdateEntityType"
	FeaturestoreService_DeleteEntityType_FullMethodName       = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/DeleteEntityType"
	FeaturestoreService_CreateFeature_FullMethodName          = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/CreateFeature"
	FeaturestoreService_BatchCreateFeatures_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/BatchCreateFeatures"
	FeaturestoreService_GetFeature_FullMethodName             = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/GetFeature"
	FeaturestoreService_ListFeatures_FullMethodName           = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/ListFeatures"
	FeaturestoreService_UpdateFeature_FullMethodName          = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/UpdateFeature"
	FeaturestoreService_DeleteFeature_FullMethodName          = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/DeleteFeature"
	FeaturestoreService_ImportFeatureValues_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/ImportFeatureValues"
	FeaturestoreService_BatchReadFeatureValues_FullMethodName = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/BatchReadFeatureValues"
	FeaturestoreService_ExportFeatureValues_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/ExportFeatureValues"
	FeaturestoreService_DeleteFeatureValues_FullMethodName    = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/DeleteFeatureValues"
	FeaturestoreService_SearchFeatures_FullMethodName         = "/google.cloud.aiplatform.v1beta1.FeaturestoreService/SearchFeatures"
)

// FeaturestoreServiceClient is the client API for FeaturestoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FeaturestoreServiceClient interface {
	// Creates a new Featurestore in a given project and location.
	CreateFeaturestore(ctx context.Context, in *CreateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Featurestore.
	GetFeaturestore(ctx context.Context, in *GetFeaturestoreRequest, opts ...grpc.CallOption) (*Featurestore, error)
	// Lists Featurestores in a given project and location.
	ListFeaturestores(ctx context.Context, in *ListFeaturestoresRequest, opts ...grpc.CallOption) (*ListFeaturestoresResponse, error)
	// Updates the parameters of a single Featurestore.
	UpdateFeaturestore(ctx context.Context, in *UpdateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Featurestore. The Featurestore must not contain any
	// EntityTypes or `force` must be set to true for the request to succeed.
	DeleteFeaturestore(ctx context.Context, in *DeleteFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new EntityType in a given Featurestore.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single EntityType.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Lists EntityTypes in a given Featurestore.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Updates the parameters of a single EntityType.
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes a single EntityType. The EntityType must not have any Features
	// or `force` must be set to true for the request to succeed.
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new Feature in a given EntityType.
	CreateFeature(ctx context.Context, in *CreateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a batch of Features in a given EntityType.
	BatchCreateFeatures(ctx context.Context, in *BatchCreateFeaturesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Feature.
	GetFeature(ctx context.Context, in *GetFeatureRequest, opts ...grpc.CallOption) (*Feature, error)
	// Lists Features in a given EntityType.
	ListFeatures(ctx context.Context, in *ListFeaturesRequest, opts ...grpc.CallOption) (*ListFeaturesResponse, error)
	// Updates the parameters of a single Feature.
	UpdateFeature(ctx context.Context, in *UpdateFeatureRequest, opts ...grpc.CallOption) (*Feature, error)
	// Deletes a single Feature.
	DeleteFeature(ctx context.Context, in *DeleteFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports Feature values into the Featurestore from a source storage.
	//
	// The progress of the import is tracked by the returned operation. The
	// imported features are guaranteed to be visible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If an import operation fails, the Feature values returned from
	// reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same import request again and wait till
	// the new operation returned is marked as successfully done.
	//
	// There are also scenarios where the caller can cause inconsistency.
	//
	//   - Source data for import contains multiple distinct Feature values for
	//     the same entity ID and timestamp.
	//   - Source is modified during an import. This includes adding, updating, or
	//     removing source data and/or metadata. Examples of updating metadata
	//     include but are not limited to changing storage location, storage class,
	//     or retention policy.
	//   - Online serving cluster is under-provisioned.
	ImportFeatureValues(ctx context.Context, in *ImportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Batch reads Feature values from a Featurestore.
	//
	// This API enables batch reading Feature values, where each read
	// instance in the batch may read Feature values of entities from one or
	// more EntityTypes. Point-in-time correctness is guaranteed for Feature
	// values of each read instance as of each instance's read timestamp.
	BatchReadFeatureValues(ctx context.Context, in *BatchReadFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports Feature values from all the entities of a target EntityType.
	ExportFeatureValues(ctx context.Context, in *ExportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete Feature values from Featurestore.
	//
	// The progress of the deletion is tracked by the returned operation. The
	// deleted feature values are guaranteed to be invisible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If a delete feature values operation fails, the feature values
	// returned from reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same delete request again and wait till
	// the new operation returned is marked as successfully done.
	DeleteFeatureValues(ctx context.Context, in *DeleteFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Searches Features matching a query in a given project.
	SearchFeatures(ctx context.Context, in *SearchFeaturesRequest, opts ...grpc.CallOption) (*SearchFeaturesResponse, error)
}

type featurestoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeaturestoreServiceClient(cc grpc.ClientConnInterface) FeaturestoreServiceClient {
	return &featurestoreServiceClient{cc}
}

func (c *featurestoreServiceClient) CreateFeaturestore(ctx context.Context, in *CreateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_CreateFeaturestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) GetFeaturestore(ctx context.Context, in *GetFeaturestoreRequest, opts ...grpc.CallOption) (*Featurestore, error) {
	out := new(Featurestore)
	err := c.cc.Invoke(ctx, FeaturestoreService_GetFeaturestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ListFeaturestores(ctx context.Context, in *ListFeaturestoresRequest, opts ...grpc.CallOption) (*ListFeaturestoresResponse, error) {
	out := new(ListFeaturestoresResponse)
	err := c.cc.Invoke(ctx, FeaturestoreService_ListFeaturestores_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) UpdateFeaturestore(ctx context.Context, in *UpdateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_UpdateFeaturestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteFeaturestore(ctx context.Context, in *DeleteFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_DeleteFeaturestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_CreateEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, FeaturestoreService_GetEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, FeaturestoreService_ListEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, FeaturestoreService_UpdateEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_DeleteEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) CreateFeature(ctx context.Context, in *CreateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_CreateFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) BatchCreateFeatures(ctx context.Context, in *BatchCreateFeaturesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_BatchCreateFeatures_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) GetFeature(ctx context.Context, in *GetFeatureRequest, opts ...grpc.CallOption) (*Feature, error) {
	out := new(Feature)
	err := c.cc.Invoke(ctx, FeaturestoreService_GetFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ListFeatures(ctx context.Context, in *ListFeaturesRequest, opts ...grpc.CallOption) (*ListFeaturesResponse, error) {
	out := new(ListFeaturesResponse)
	err := c.cc.Invoke(ctx, FeaturestoreService_ListFeatures_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) UpdateFeature(ctx context.Context, in *UpdateFeatureRequest, opts ...grpc.CallOption) (*Feature, error) {
	out := new(Feature)
	err := c.cc.Invoke(ctx, FeaturestoreService_UpdateFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteFeature(ctx context.Context, in *DeleteFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_DeleteFeature_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ImportFeatureValues(ctx context.Context, in *ImportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_ImportFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) BatchReadFeatureValues(ctx context.Context, in *BatchReadFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_BatchReadFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ExportFeatureValues(ctx context.Context, in *ExportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_ExportFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteFeatureValues(ctx context.Context, in *DeleteFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FeaturestoreService_DeleteFeatureValues_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) SearchFeatures(ctx context.Context, in *SearchFeaturesRequest, opts ...grpc.CallOption) (*SearchFeaturesResponse, error) {
	out := new(SearchFeaturesResponse)
	err := c.cc.Invoke(ctx, FeaturestoreService_SearchFeatures_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeaturestoreServiceServer is the server API for FeaturestoreService service.
// All implementations should embed UnimplementedFeaturestoreServiceServer
// for forward compatibility
type FeaturestoreServiceServer interface {
	// Creates a new Featurestore in a given project and location.
	CreateFeaturestore(context.Context, *CreateFeaturestoreRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Featurestore.
	GetFeaturestore(context.Context, *GetFeaturestoreRequest) (*Featurestore, error)
	// Lists Featurestores in a given project and location.
	ListFeaturestores(context.Context, *ListFeaturestoresRequest) (*ListFeaturestoresResponse, error)
	// Updates the parameters of a single Featurestore.
	UpdateFeaturestore(context.Context, *UpdateFeaturestoreRequest) (*longrunningpb.Operation, error)
	// Deletes a single Featurestore. The Featurestore must not contain any
	// EntityTypes or `force` must be set to true for the request to succeed.
	DeleteFeaturestore(context.Context, *DeleteFeaturestoreRequest) (*longrunningpb.Operation, error)
	// Creates a new EntityType in a given Featurestore.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*longrunningpb.Operation, error)
	// Gets details of a single EntityType.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Lists EntityTypes in a given Featurestore.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Updates the parameters of a single EntityType.
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes a single EntityType. The EntityType must not have any Features
	// or `force` must be set to true for the request to succeed.
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*longrunningpb.Operation, error)
	// Creates a new Feature in a given EntityType.
	CreateFeature(context.Context, *CreateFeatureRequest) (*longrunningpb.Operation, error)
	// Creates a batch of Features in a given EntityType.
	BatchCreateFeatures(context.Context, *BatchCreateFeaturesRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Feature.
	GetFeature(context.Context, *GetFeatureRequest) (*Feature, error)
	// Lists Features in a given EntityType.
	ListFeatures(context.Context, *ListFeaturesRequest) (*ListFeaturesResponse, error)
	// Updates the parameters of a single Feature.
	UpdateFeature(context.Context, *UpdateFeatureRequest) (*Feature, error)
	// Deletes a single Feature.
	DeleteFeature(context.Context, *DeleteFeatureRequest) (*longrunningpb.Operation, error)
	// Imports Feature values into the Featurestore from a source storage.
	//
	// The progress of the import is tracked by the returned operation. The
	// imported features are guaranteed to be visible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If an import operation fails, the Feature values returned from
	// reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same import request again and wait till
	// the new operation returned is marked as successfully done.
	//
	// There are also scenarios where the caller can cause inconsistency.
	//
	//   - Source data for import contains multiple distinct Feature values for
	//     the same entity ID and timestamp.
	//   - Source is modified during an import. This includes adding, updating, or
	//     removing source data and/or metadata. Examples of updating metadata
	//     include but are not limited to changing storage location, storage class,
	//     or retention policy.
	//   - Online serving cluster is under-provisioned.
	ImportFeatureValues(context.Context, *ImportFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Batch reads Feature values from a Featurestore.
	//
	// This API enables batch reading Feature values, where each read
	// instance in the batch may read Feature values of entities from one or
	// more EntityTypes. Point-in-time correctness is guaranteed for Feature
	// values of each read instance as of each instance's read timestamp.
	BatchReadFeatureValues(context.Context, *BatchReadFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Exports Feature values from all the entities of a target EntityType.
	ExportFeatureValues(context.Context, *ExportFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Delete Feature values from Featurestore.
	//
	// The progress of the deletion is tracked by the returned operation. The
	// deleted feature values are guaranteed to be invisible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If a delete feature values operation fails, the feature values
	// returned from reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same delete request again and wait till
	// the new operation returned is marked as successfully done.
	DeleteFeatureValues(context.Context, *DeleteFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Searches Features matching a query in a given project.
	SearchFeatures(context.Context, *SearchFeaturesRequest) (*SearchFeaturesResponse, error)
}

// UnimplementedFeaturestoreServiceServer should be embedded to have forward compatible implementations.
type UnimplementedFeaturestoreServiceServer struct {
}

func (UnimplementedFeaturestoreServiceServer) CreateFeaturestore(context.Context, *CreateFeaturestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeaturestore not implemented")
}
func (UnimplementedFeaturestoreServiceServer) GetFeaturestore(context.Context, *GetFeaturestoreRequest) (*Featurestore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeaturestore not implemented")
}
func (UnimplementedFeaturestoreServiceServer) ListFeaturestores(context.Context, *ListFeaturestoresRequest) (*ListFeaturestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeaturestores not implemented")
}
func (UnimplementedFeaturestoreServiceServer) UpdateFeaturestore(context.Context, *UpdateFeaturestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeaturestore not implemented")
}
func (UnimplementedFeaturestoreServiceServer) DeleteFeaturestore(context.Context, *DeleteFeaturestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeaturestore not implemented")
}
func (UnimplementedFeaturestoreServiceServer) CreateEntityType(context.Context, *CreateEntityTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntityType not implemented")
}
func (UnimplementedFeaturestoreServiceServer) GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntityType not implemented")
}
func (UnimplementedFeaturestoreServiceServer) ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntityTypes not implemented")
}
func (UnimplementedFeaturestoreServiceServer) UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntityType not implemented")
}
func (UnimplementedFeaturestoreServiceServer) DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntityType not implemented")
}
func (UnimplementedFeaturestoreServiceServer) CreateFeature(context.Context, *CreateFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeature not implemented")
}
func (UnimplementedFeaturestoreServiceServer) BatchCreateFeatures(context.Context, *BatchCreateFeaturesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateFeatures not implemented")
}
func (UnimplementedFeaturestoreServiceServer) GetFeature(context.Context, *GetFeatureRequest) (*Feature, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeature not implemented")
}
func (UnimplementedFeaturestoreServiceServer) ListFeatures(context.Context, *ListFeaturesRequest) (*ListFeaturesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatures not implemented")
}
func (UnimplementedFeaturestoreServiceServer) UpdateFeature(context.Context, *UpdateFeatureRequest) (*Feature, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeature not implemented")
}
func (UnimplementedFeaturestoreServiceServer) DeleteFeature(context.Context, *DeleteFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeature not implemented")
}
func (UnimplementedFeaturestoreServiceServer) ImportFeatureValues(context.Context, *ImportFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportFeatureValues not implemented")
}
func (UnimplementedFeaturestoreServiceServer) BatchReadFeatureValues(context.Context, *BatchReadFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchReadFeatureValues not implemented")
}
func (UnimplementedFeaturestoreServiceServer) ExportFeatureValues(context.Context, *ExportFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportFeatureValues not implemented")
}
func (UnimplementedFeaturestoreServiceServer) DeleteFeatureValues(context.Context, *DeleteFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeatureValues not implemented")
}
func (UnimplementedFeaturestoreServiceServer) SearchFeatures(context.Context, *SearchFeaturesRequest) (*SearchFeaturesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchFeatures not implemented")
}

// UnsafeFeaturestoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FeaturestoreServiceServer will
// result in compilation errors.
type UnsafeFeaturestoreServiceServer interface {
	mustEmbedUnimplementedFeaturestoreServiceServer()
}

func RegisterFeaturestoreServiceServer(s grpc.ServiceRegistrar, srv FeaturestoreServiceServer) {
	s.RegisterService(&FeaturestoreService_ServiceDesc, srv)
}

func _FeaturestoreService_CreateFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).CreateFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_CreateFeaturestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).CreateFeaturestore(ctx, req.(*CreateFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_GetFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).GetFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_GetFeaturestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).GetFeaturestore(ctx, req.(*GetFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ListFeaturestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeaturestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ListFeaturestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_ListFeaturestores_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ListFeaturestores(ctx, req.(*ListFeaturestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_UpdateFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).UpdateFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_UpdateFeaturestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).UpdateFeaturestore(ctx, req.(*UpdateFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_DeleteFeaturestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteFeaturestore(ctx, req.(*DeleteFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_CreateEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_GetEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_ListEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_UpdateEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_DeleteEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_CreateFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).CreateFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_CreateFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).CreateFeature(ctx, req.(*CreateFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_BatchCreateFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).BatchCreateFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_BatchCreateFeatures_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).BatchCreateFeatures(ctx, req.(*BatchCreateFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_GetFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).GetFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_GetFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).GetFeature(ctx, req.(*GetFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ListFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ListFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_ListFeatures_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ListFeatures(ctx, req.(*ListFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_UpdateFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).UpdateFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_UpdateFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).UpdateFeature(ctx, req.(*UpdateFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_DeleteFeature_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteFeature(ctx, req.(*DeleteFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ImportFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ImportFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_ImportFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ImportFeatureValues(ctx, req.(*ImportFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_BatchReadFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchReadFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).BatchReadFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_BatchReadFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).BatchReadFeatureValues(ctx, req.(*BatchReadFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ExportFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ExportFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_ExportFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ExportFeatureValues(ctx, req.(*ExportFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_DeleteFeatureValues_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteFeatureValues(ctx, req.(*DeleteFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_SearchFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).SearchFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FeaturestoreService_SearchFeatures_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).SearchFeatures(ctx, req.(*SearchFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FeaturestoreService_ServiceDesc is the grpc.ServiceDesc for FeaturestoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FeaturestoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.FeaturestoreService",
	HandlerType: (*FeaturestoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFeaturestore",
			Handler:    _FeaturestoreService_CreateFeaturestore_Handler,
		},
		{
			MethodName: "GetFeaturestore",
			Handler:    _FeaturestoreService_GetFeaturestore_Handler,
		},
		{
			MethodName: "ListFeaturestores",
			Handler:    _FeaturestoreService_ListFeaturestores_Handler,
		},
		{
			MethodName: "UpdateFeaturestore",
			Handler:    _FeaturestoreService_UpdateFeaturestore_Handler,
		},
		{
			MethodName: "DeleteFeaturestore",
			Handler:    _FeaturestoreService_DeleteFeaturestore_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _FeaturestoreService_CreateEntityType_Handler,
		},
		{
			MethodName: "GetEntityType",
			Handler:    _FeaturestoreService_GetEntityType_Handler,
		},
		{
			MethodName: "ListEntityTypes",
			Handler:    _FeaturestoreService_ListEntityTypes_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _FeaturestoreService_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _FeaturestoreService_DeleteEntityType_Handler,
		},
		{
			MethodName: "CreateFeature",
			Handler:    _FeaturestoreService_CreateFeature_Handler,
		},
		{
			MethodName: "BatchCreateFeatures",
			Handler:    _FeaturestoreService_BatchCreateFeatures_Handler,
		},
		{
			MethodName: "GetFeature",
			Handler:    _FeaturestoreService_GetFeature_Handler,
		},
		{
			MethodName: "ListFeatures",
			Handler:    _FeaturestoreService_ListFeatures_Handler,
		},
		{
			MethodName: "UpdateFeature",
			Handler:    _FeaturestoreService_UpdateFeature_Handler,
		},
		{
			MethodName: "DeleteFeature",
			Handler:    _FeaturestoreService_DeleteFeature_Handler,
		},
		{
			MethodName: "ImportFeatureValues",
			Handler:    _FeaturestoreService_ImportFeatureValues_Handler,
		},
		{
			MethodName: "BatchReadFeatureValues",
			Handler:    _FeaturestoreService_BatchReadFeatureValues_Handler,
		},
		{
			MethodName: "ExportFeatureValues",
			Handler:    _FeaturestoreService_ExportFeatureValues_Handler,
		},
		{
			MethodName: "DeleteFeatureValues",
			Handler:    _FeaturestoreService_DeleteFeatureValues_Handler,
		},
		{
			MethodName: "SearchFeatures",
			Handler:    _FeaturestoreService_SearchFeatures_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/featurestore_service.proto",
}
