/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.event;

import java.util.regex.Pattern;
import org.apache.guacamole.event.LoggableDetail;
import org.apache.guacamole.net.auth.Credentials;

public class RemoteAddress
implements LoggableDetail {
    private static final String IPV4_ADDRESS_REGEX = "([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})";
    private static final String IPV6_ADDRESS_REGEX = "([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7})";
    private static final String IP_ADDRESS_REGEX = "(([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7}))";
    private static final String PORT_NUMBER_REGEX = "(:[0-9]{1,5})?";
    private static final Pattern X_FORWARDED_FOR = Pattern.compile("^(([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7}))(:[0-9]{1,5})?(, (([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7}))(:[0-9]{1,5})?)*$");
    private final Credentials creds;

    public RemoteAddress(Credentials creds) {
        this.creds = creds;
    }

    public String toString() {
        String remoteAddress = this.creds.getRemoteAddress();
        String header = this.creds.getHeader("X-Forwarded-For");
        if (header != null && X_FORWARDED_FOR.matcher(header).matches()) {
            return "[" + header + ", " + remoteAddress + "]";
        }
        return remoteAddress;
    }
}

