// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/experiment.proto

package cxpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Experiments_ListExperiments_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.Experiments/ListExperiments"
	Experiments_GetExperiment_FullMethodName    = "/google.cloud.dialogflow.cx.v3beta1.Experiments/GetExperiment"
	Experiments_CreateExperiment_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Experiments/CreateExperiment"
	Experiments_UpdateExperiment_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Experiments/UpdateExperiment"
	Experiments_DeleteExperiment_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Experiments/DeleteExperiment"
	Experiments_StartExperiment_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.Experiments/StartExperiment"
	Experiments_StopExperiment_FullMethodName   = "/google.cloud.dialogflow.cx.v3beta1.Experiments/StopExperiment"
)

// ExperimentsClient is the client API for Experiments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExperimentsClient interface {
	// Returns the list of all experiments in the specified
	// [Environment][google.cloud.dialogflow.cx.v3beta1.Environment].
	ListExperiments(ctx context.Context, in *ListExperimentsRequest, opts ...grpc.CallOption) (*ListExperimentsResponse, error)
	// Retrieves the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment].
	GetExperiment(ctx context.Context, in *GetExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Creates an [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment] in
	// the specified
	// [Environment][google.cloud.dialogflow.cx.v3beta1.Environment].
	CreateExperiment(ctx context.Context, in *CreateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Updates the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment].
	UpdateExperiment(ctx context.Context, in *UpdateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Deletes the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment].
	DeleteExperiment(ctx context.Context, in *DeleteExperimentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment]. This rpc only
	// changes the state of experiment from PENDING to RUNNING.
	StartExperiment(ctx context.Context, in *StartExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Stops the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment]. This rpc only
	// changes the state of experiment from RUNNING to DONE.
	StopExperiment(ctx context.Context, in *StopExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
}

type experimentsClient struct {
	cc grpc.ClientConnInterface
}

func NewExperimentsClient(cc grpc.ClientConnInterface) ExperimentsClient {
	return &experimentsClient{cc}
}

func (c *experimentsClient) ListExperiments(ctx context.Context, in *ListExperimentsRequest, opts ...grpc.CallOption) (*ListExperimentsResponse, error) {
	out := new(ListExperimentsResponse)
	err := c.cc.Invoke(ctx, Experiments_ListExperiments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) GetExperiment(ctx context.Context, in *GetExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, Experiments_GetExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) CreateExperiment(ctx context.Context, in *CreateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, Experiments_CreateExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) UpdateExperiment(ctx context.Context, in *UpdateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, Experiments_UpdateExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) DeleteExperiment(ctx context.Context, in *DeleteExperimentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Experiments_DeleteExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) StartExperiment(ctx context.Context, in *StartExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, Experiments_StartExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) StopExperiment(ctx context.Context, in *StopExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, Experiments_StopExperiment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExperimentsServer is the server API for Experiments service.
// All implementations should embed UnimplementedExperimentsServer
// for forward compatibility
type ExperimentsServer interface {
	// Returns the list of all experiments in the specified
	// [Environment][google.cloud.dialogflow.cx.v3beta1.Environment].
	ListExperiments(context.Context, *ListExperimentsRequest) (*ListExperimentsResponse, error)
	// Retrieves the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment].
	GetExperiment(context.Context, *GetExperimentRequest) (*Experiment, error)
	// Creates an [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment] in
	// the specified
	// [Environment][google.cloud.dialogflow.cx.v3beta1.Environment].
	CreateExperiment(context.Context, *CreateExperimentRequest) (*Experiment, error)
	// Updates the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment].
	UpdateExperiment(context.Context, *UpdateExperimentRequest) (*Experiment, error)
	// Deletes the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment].
	DeleteExperiment(context.Context, *DeleteExperimentRequest) (*emptypb.Empty, error)
	// Starts the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment]. This rpc only
	// changes the state of experiment from PENDING to RUNNING.
	StartExperiment(context.Context, *StartExperimentRequest) (*Experiment, error)
	// Stops the specified
	// [Experiment][google.cloud.dialogflow.cx.v3beta1.Experiment]. This rpc only
	// changes the state of experiment from RUNNING to DONE.
	StopExperiment(context.Context, *StopExperimentRequest) (*Experiment, error)
}

// UnimplementedExperimentsServer should be embedded to have forward compatible implementations.
type UnimplementedExperimentsServer struct {
}

func (UnimplementedExperimentsServer) ListExperiments(context.Context, *ListExperimentsRequest) (*ListExperimentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExperiments not implemented")
}
func (UnimplementedExperimentsServer) GetExperiment(context.Context, *GetExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExperiment not implemented")
}
func (UnimplementedExperimentsServer) CreateExperiment(context.Context, *CreateExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExperiment not implemented")
}
func (UnimplementedExperimentsServer) UpdateExperiment(context.Context, *UpdateExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExperiment not implemented")
}
func (UnimplementedExperimentsServer) DeleteExperiment(context.Context, *DeleteExperimentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExperiment not implemented")
}
func (UnimplementedExperimentsServer) StartExperiment(context.Context, *StartExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartExperiment not implemented")
}
func (UnimplementedExperimentsServer) StopExperiment(context.Context, *StopExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopExperiment not implemented")
}

// UnsafeExperimentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExperimentsServer will
// result in compilation errors.
type UnsafeExperimentsServer interface {
	mustEmbedUnimplementedExperimentsServer()
}

func RegisterExperimentsServer(s grpc.ServiceRegistrar, srv ExperimentsServer) {
	s.RegisterService(&Experiments_ServiceDesc, srv)
}

func _Experiments_ListExperiments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExperimentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).ListExperiments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_ListExperiments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).ListExperiments(ctx, req.(*ListExperimentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_GetExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).GetExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_GetExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).GetExperiment(ctx, req.(*GetExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_CreateExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).CreateExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_CreateExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).CreateExperiment(ctx, req.(*CreateExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_UpdateExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).UpdateExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_UpdateExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).UpdateExperiment(ctx, req.(*UpdateExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_DeleteExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).DeleteExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_DeleteExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).DeleteExperiment(ctx, req.(*DeleteExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_StartExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).StartExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_StartExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).StartExperiment(ctx, req.(*StartExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_StopExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).StopExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Experiments_StopExperiment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).StopExperiment(ctx, req.(*StopExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Experiments_ServiceDesc is the grpc.ServiceDesc for Experiments service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Experiments_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Experiments",
	HandlerType: (*ExperimentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListExperiments",
			Handler:    _Experiments_ListExperiments_Handler,
		},
		{
			MethodName: "GetExperiment",
			Handler:    _Experiments_GetExperiment_Handler,
		},
		{
			MethodName: "CreateExperiment",
			Handler:    _Experiments_CreateExperiment_Handler,
		},
		{
			MethodName: "UpdateExperiment",
			Handler:    _Experiments_UpdateExperiment_Handler,
		},
		{
			MethodName: "DeleteExperiment",
			Handler:    _Experiments_DeleteExperiment_Handler,
		},
		{
			MethodName: "StartExperiment",
			Handler:    _Experiments_StartExperiment_Handler,
		},
		{
			MethodName: "StopExperiment",
			Handler:    _Experiments_StopExperiment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/experiment.proto",
}
