// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

package adminpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BigtableInstanceAdmin_CreateInstance_FullMethodName         = "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance"
	BigtableInstanceAdmin_GetInstance_FullMethodName            = "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance"
	BigtableInstanceAdmin_ListInstances_FullMethodName          = "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances"
	BigtableInstanceAdmin_UpdateInstance_FullMethodName         = "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance"
	BigtableInstanceAdmin_PartialUpdateInstance_FullMethodName  = "/google.bigtable.admin.v2.BigtableInstanceAdmin/PartialUpdateInstance"
	BigtableInstanceAdmin_DeleteInstance_FullMethodName         = "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance"
	BigtableInstanceAdmin_CreateCluster_FullMethodName          = "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster"
	BigtableInstanceAdmin_GetCluster_FullMethodName             = "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster"
	BigtableInstanceAdmin_ListClusters_FullMethodName           = "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters"
	BigtableInstanceAdmin_UpdateCluster_FullMethodName          = "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster"
	BigtableInstanceAdmin_PartialUpdateCluster_FullMethodName   = "/google.bigtable.admin.v2.BigtableInstanceAdmin/PartialUpdateCluster"
	BigtableInstanceAdmin_DeleteCluster_FullMethodName          = "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster"
	BigtableInstanceAdmin_CreateAppProfile_FullMethodName       = "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateAppProfile"
	BigtableInstanceAdmin_GetAppProfile_FullMethodName          = "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetAppProfile"
	BigtableInstanceAdmin_ListAppProfiles_FullMethodName        = "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListAppProfiles"
	BigtableInstanceAdmin_UpdateAppProfile_FullMethodName       = "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateAppProfile"
	BigtableInstanceAdmin_DeleteAppProfile_FullMethodName       = "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteAppProfile"
	BigtableInstanceAdmin_GetIamPolicy_FullMethodName           = "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetIamPolicy"
	BigtableInstanceAdmin_SetIamPolicy_FullMethodName           = "/google.bigtable.admin.v2.BigtableInstanceAdmin/SetIamPolicy"
	BigtableInstanceAdmin_TestIamPermissions_FullMethodName     = "/google.bigtable.admin.v2.BigtableInstanceAdmin/TestIamPermissions"
	BigtableInstanceAdmin_ListHotTablets_FullMethodName         = "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListHotTablets"
	BigtableInstanceAdmin_CreateLogicalView_FullMethodName      = "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateLogicalView"
	BigtableInstanceAdmin_GetLogicalView_FullMethodName         = "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetLogicalView"
	BigtableInstanceAdmin_ListLogicalViews_FullMethodName       = "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListLogicalViews"
	BigtableInstanceAdmin_UpdateLogicalView_FullMethodName      = "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateLogicalView"
	BigtableInstanceAdmin_DeleteLogicalView_FullMethodName      = "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteLogicalView"
	BigtableInstanceAdmin_CreateMaterializedView_FullMethodName = "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateMaterializedView"
	BigtableInstanceAdmin_GetMaterializedView_FullMethodName    = "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetMaterializedView"
	BigtableInstanceAdmin_ListMaterializedViews_FullMethodName  = "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListMaterializedViews"
	BigtableInstanceAdmin_UpdateMaterializedView_FullMethodName = "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateMaterializedView"
	BigtableInstanceAdmin_DeleteMaterializedView_FullMethodName = "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteMaterializedView"
)

// BigtableInstanceAdminClient is the client API for BigtableInstanceAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BigtableInstanceAdminClient interface {
	// Create an instance within a project.
	//
	// Note that exactly one of Cluster.serve_nodes and
	// Cluster.cluster_config.cluster_autoscaling_config can be set. If
	// serve_nodes is set to non-zero, then the cluster is manually scaled. If
	// cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
	// enabled.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets information about an instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Updates an instance within a project. This method updates only the display
	// name and type for an Instance. To update other Instance properties, such as
	// labels, use PartialUpdateInstance.
	UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error)
	// Partially updates an instance within a project. This method can modify all
	// fields of an Instance and is the preferred way to update an Instance.
	PartialUpdateInstance(ctx context.Context, in *PartialUpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete an instance from a project.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a cluster within an instance.
	//
	// Note that exactly one of Cluster.serve_nodes and
	// Cluster.cluster_config.cluster_autoscaling_config can be set. If
	// serve_nodes is set to non-zero, then the cluster is manually scaled. If
	// cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
	// enabled.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets information about a cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	//
	// Note that UpdateCluster does not support updating
	// cluster_config.cluster_autoscaling_config. In order to update it, you
	// must use PartialUpdateCluster.
	UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Partially updates a cluster within a project. This method is the preferred
	// way to update a Cluster.
	//
	// To enable and update autoscaling, set
	// cluster_config.cluster_autoscaling_config. When autoscaling is enabled,
	// serve_nodes is treated as an OUTPUT_ONLY field, meaning that updates to it
	// are ignored. Note that an update cannot simultaneously set serve_nodes to
	// non-zero and cluster_config.cluster_autoscaling_config to non-empty, and
	// also specify both in the update_mask.
	//
	// To disable autoscaling, clear cluster_config.cluster_autoscaling_config,
	// and explicitly set a serve_node count via the update_mask.
	PartialUpdateCluster(ctx context.Context, in *PartialUpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an app profile within an instance.
	CreateAppProfile(ctx context.Context, in *CreateAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error)
	// Gets information about an app profile.
	GetAppProfile(ctx context.Context, in *GetAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error)
	// Lists information about app profiles in an instance.
	ListAppProfiles(ctx context.Context, in *ListAppProfilesRequest, opts ...grpc.CallOption) (*ListAppProfilesResponse, error)
	// Updates an app profile within an instance.
	UpdateAppProfile(ctx context.Context, in *UpdateAppProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an app profile from an instance.
	DeleteAppProfile(ctx context.Context, in *DeleteAppProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Lists hot tablets in a cluster, within the time range provided. Hot
	// tablets are ordered based on CPU usage.
	ListHotTablets(ctx context.Context, in *ListHotTabletsRequest, opts ...grpc.CallOption) (*ListHotTabletsResponse, error)
	// Creates a logical view within an instance.
	CreateLogicalView(ctx context.Context, in *CreateLogicalViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets information about a logical view.
	GetLogicalView(ctx context.Context, in *GetLogicalViewRequest, opts ...grpc.CallOption) (*LogicalView, error)
	// Lists information about logical views in an instance.
	ListLogicalViews(ctx context.Context, in *ListLogicalViewsRequest, opts ...grpc.CallOption) (*ListLogicalViewsResponse, error)
	// Updates a logical view within an instance.
	UpdateLogicalView(ctx context.Context, in *UpdateLogicalViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a logical view from an instance.
	DeleteLogicalView(ctx context.Context, in *DeleteLogicalViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a materialized view within an instance.
	CreateMaterializedView(ctx context.Context, in *CreateMaterializedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets information about a materialized view.
	GetMaterializedView(ctx context.Context, in *GetMaterializedViewRequest, opts ...grpc.CallOption) (*MaterializedView, error)
	// Lists information about materialized views in an instance.
	ListMaterializedViews(ctx context.Context, in *ListMaterializedViewsRequest, opts ...grpc.CallOption) (*ListMaterializedViewsResponse, error)
	// Updates a materialized view within an instance.
	UpdateMaterializedView(ctx context.Context, in *UpdateMaterializedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a materialized view from an instance.
	DeleteMaterializedView(ctx context.Context, in *DeleteMaterializedViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type bigtableInstanceAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewBigtableInstanceAdminClient(cc grpc.ClientConnInterface) BigtableInstanceAdminClient {
	return &bigtableInstanceAdminClient{cc}
}

func (c *bigtableInstanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_CreateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_UpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) PartialUpdateInstance(ctx context.Context, in *PartialUpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_PartialUpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_CreateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_GetCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_ListClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_UpdateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) PartialUpdateCluster(ctx context.Context, in *PartialUpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_PartialUpdateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_DeleteCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateAppProfile(ctx context.Context, in *CreateAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error) {
	out := new(AppProfile)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_CreateAppProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetAppProfile(ctx context.Context, in *GetAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error) {
	out := new(AppProfile)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_GetAppProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListAppProfiles(ctx context.Context, in *ListAppProfilesRequest, opts ...grpc.CallOption) (*ListAppProfilesResponse, error) {
	out := new(ListAppProfilesResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_ListAppProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateAppProfile(ctx context.Context, in *UpdateAppProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_UpdateAppProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteAppProfile(ctx context.Context, in *DeleteAppProfileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_DeleteAppProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListHotTablets(ctx context.Context, in *ListHotTabletsRequest, opts ...grpc.CallOption) (*ListHotTabletsResponse, error) {
	out := new(ListHotTabletsResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_ListHotTablets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateLogicalView(ctx context.Context, in *CreateLogicalViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_CreateLogicalView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetLogicalView(ctx context.Context, in *GetLogicalViewRequest, opts ...grpc.CallOption) (*LogicalView, error) {
	out := new(LogicalView)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_GetLogicalView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListLogicalViews(ctx context.Context, in *ListLogicalViewsRequest, opts ...grpc.CallOption) (*ListLogicalViewsResponse, error) {
	out := new(ListLogicalViewsResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_ListLogicalViews_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateLogicalView(ctx context.Context, in *UpdateLogicalViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_UpdateLogicalView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteLogicalView(ctx context.Context, in *DeleteLogicalViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_DeleteLogicalView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateMaterializedView(ctx context.Context, in *CreateMaterializedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_CreateMaterializedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetMaterializedView(ctx context.Context, in *GetMaterializedViewRequest, opts ...grpc.CallOption) (*MaterializedView, error) {
	out := new(MaterializedView)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_GetMaterializedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListMaterializedViews(ctx context.Context, in *ListMaterializedViewsRequest, opts ...grpc.CallOption) (*ListMaterializedViewsResponse, error) {
	out := new(ListMaterializedViewsResponse)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_ListMaterializedViews_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateMaterializedView(ctx context.Context, in *UpdateMaterializedViewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_UpdateMaterializedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteMaterializedView(ctx context.Context, in *DeleteMaterializedViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigtableInstanceAdmin_DeleteMaterializedView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableInstanceAdminServer is the server API for BigtableInstanceAdmin service.
// All implementations should embed UnimplementedBigtableInstanceAdminServer
// for forward compatibility
type BigtableInstanceAdminServer interface {
	// Create an instance within a project.
	//
	// Note that exactly one of Cluster.serve_nodes and
	// Cluster.cluster_config.cluster_autoscaling_config can be set. If
	// serve_nodes is set to non-zero, then the cluster is manually scaled. If
	// cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
	// enabled.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Gets information about an instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Updates an instance within a project. This method updates only the display
	// name and type for an Instance. To update other Instance properties, such as
	// labels, use PartialUpdateInstance.
	UpdateInstance(context.Context, *Instance) (*Instance, error)
	// Partially updates an instance within a project. This method can modify all
	// fields of an Instance and is the preferred way to update an Instance.
	PartialUpdateInstance(context.Context, *PartialUpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Delete an instance from a project.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*emptypb.Empty, error)
	// Creates a cluster within an instance.
	//
	// Note that exactly one of Cluster.serve_nodes and
	// Cluster.cluster_config.cluster_autoscaling_config can be set. If
	// serve_nodes is set to non-zero, then the cluster is manually scaled. If
	// cluster_config.cluster_autoscaling_config is non-empty, then autoscaling is
	// enabled.
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Gets information about a cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	//
	// Note that UpdateCluster does not support updating
	// cluster_config.cluster_autoscaling_config. In order to update it, you
	// must use PartialUpdateCluster.
	UpdateCluster(context.Context, *Cluster) (*longrunningpb.Operation, error)
	// Partially updates a cluster within a project. This method is the preferred
	// way to update a Cluster.
	//
	// To enable and update autoscaling, set
	// cluster_config.cluster_autoscaling_config. When autoscaling is enabled,
	// serve_nodes is treated as an OUTPUT_ONLY field, meaning that updates to it
	// are ignored. Note that an update cannot simultaneously set serve_nodes to
	// non-zero and cluster_config.cluster_autoscaling_config to non-empty, and
	// also specify both in the update_mask.
	//
	// To disable autoscaling, clear cluster_config.cluster_autoscaling_config,
	// and explicitly set a serve_node count via the update_mask.
	PartialUpdateCluster(context.Context, *PartialUpdateClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*emptypb.Empty, error)
	// Creates an app profile within an instance.
	CreateAppProfile(context.Context, *CreateAppProfileRequest) (*AppProfile, error)
	// Gets information about an app profile.
	GetAppProfile(context.Context, *GetAppProfileRequest) (*AppProfile, error)
	// Lists information about app profiles in an instance.
	ListAppProfiles(context.Context, *ListAppProfilesRequest) (*ListAppProfilesResponse, error)
	// Updates an app profile within an instance.
	UpdateAppProfile(context.Context, *UpdateAppProfileRequest) (*longrunningpb.Operation, error)
	// Deletes an app profile from an instance.
	DeleteAppProfile(context.Context, *DeleteAppProfileRequest) (*emptypb.Empty, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Lists hot tablets in a cluster, within the time range provided. Hot
	// tablets are ordered based on CPU usage.
	ListHotTablets(context.Context, *ListHotTabletsRequest) (*ListHotTabletsResponse, error)
	// Creates a logical view within an instance.
	CreateLogicalView(context.Context, *CreateLogicalViewRequest) (*longrunningpb.Operation, error)
	// Gets information about a logical view.
	GetLogicalView(context.Context, *GetLogicalViewRequest) (*LogicalView, error)
	// Lists information about logical views in an instance.
	ListLogicalViews(context.Context, *ListLogicalViewsRequest) (*ListLogicalViewsResponse, error)
	// Updates a logical view within an instance.
	UpdateLogicalView(context.Context, *UpdateLogicalViewRequest) (*longrunningpb.Operation, error)
	// Deletes a logical view from an instance.
	DeleteLogicalView(context.Context, *DeleteLogicalViewRequest) (*emptypb.Empty, error)
	// Creates a materialized view within an instance.
	CreateMaterializedView(context.Context, *CreateMaterializedViewRequest) (*longrunningpb.Operation, error)
	// Gets information about a materialized view.
	GetMaterializedView(context.Context, *GetMaterializedViewRequest) (*MaterializedView, error)
	// Lists information about materialized views in an instance.
	ListMaterializedViews(context.Context, *ListMaterializedViewsRequest) (*ListMaterializedViewsResponse, error)
	// Updates a materialized view within an instance.
	UpdateMaterializedView(context.Context, *UpdateMaterializedViewRequest) (*longrunningpb.Operation, error)
	// Deletes a materialized view from an instance.
	DeleteMaterializedView(context.Context, *DeleteMaterializedViewRequest) (*emptypb.Empty, error)
}

// UnimplementedBigtableInstanceAdminServer should be embedded to have forward compatible implementations.
type UnimplementedBigtableInstanceAdminServer struct {
}

func (UnimplementedBigtableInstanceAdminServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) UpdateInstance(context.Context, *Instance) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) PartialUpdateInstance(context.Context, *PartialUpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartialUpdateInstance not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) UpdateCluster(context.Context, *Cluster) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) PartialUpdateCluster(context.Context, *PartialUpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartialUpdateCluster not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) CreateAppProfile(context.Context, *CreateAppProfileRequest) (*AppProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppProfile not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) GetAppProfile(context.Context, *GetAppProfileRequest) (*AppProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppProfile not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) ListAppProfiles(context.Context, *ListAppProfilesRequest) (*ListAppProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppProfiles not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) UpdateAppProfile(context.Context, *UpdateAppProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAppProfile not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) DeleteAppProfile(context.Context, *DeleteAppProfileRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppProfile not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) ListHotTablets(context.Context, *ListHotTabletsRequest) (*ListHotTabletsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHotTablets not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) CreateLogicalView(context.Context, *CreateLogicalViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLogicalView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) GetLogicalView(context.Context, *GetLogicalViewRequest) (*LogicalView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLogicalView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) ListLogicalViews(context.Context, *ListLogicalViewsRequest) (*ListLogicalViewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogicalViews not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) UpdateLogicalView(context.Context, *UpdateLogicalViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLogicalView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) DeleteLogicalView(context.Context, *DeleteLogicalViewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLogicalView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) CreateMaterializedView(context.Context, *CreateMaterializedViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMaterializedView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) GetMaterializedView(context.Context, *GetMaterializedViewRequest) (*MaterializedView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMaterializedView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) ListMaterializedViews(context.Context, *ListMaterializedViewsRequest) (*ListMaterializedViewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMaterializedViews not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) UpdateMaterializedView(context.Context, *UpdateMaterializedViewRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMaterializedView not implemented")
}
func (UnimplementedBigtableInstanceAdminServer) DeleteMaterializedView(context.Context, *DeleteMaterializedViewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMaterializedView not implemented")
}

// UnsafeBigtableInstanceAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BigtableInstanceAdminServer will
// result in compilation errors.
type UnsafeBigtableInstanceAdminServer interface {
	mustEmbedUnimplementedBigtableInstanceAdminServer()
}

func RegisterBigtableInstanceAdminServer(s grpc.ServiceRegistrar, srv BigtableInstanceAdminServer) {
	s.RegisterService(&BigtableInstanceAdmin_ServiceDesc, srv)
}

func _BigtableInstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_CreateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Instance)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_UpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, req.(*Instance))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_PartialUpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartialUpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).PartialUpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_PartialUpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).PartialUpdateInstance(ctx, req.(*PartialUpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_CreateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_GetCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_ListClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_UpdateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, req.(*Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_PartialUpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartialUpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).PartialUpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_PartialUpdateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).PartialUpdateCluster(ctx, req.(*PartialUpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_DeleteCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_CreateAppProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateAppProfile(ctx, req.(*CreateAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_GetAppProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetAppProfile(ctx, req.(*GetAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListAppProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListAppProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_ListAppProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListAppProfiles(ctx, req.(*ListAppProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_UpdateAppProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateAppProfile(ctx, req.(*UpdateAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_DeleteAppProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteAppProfile(ctx, req.(*DeleteAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListHotTablets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHotTabletsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListHotTablets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_ListHotTablets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListHotTablets(ctx, req.(*ListHotTabletsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateLogicalView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLogicalViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateLogicalView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_CreateLogicalView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateLogicalView(ctx, req.(*CreateLogicalViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetLogicalView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLogicalViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetLogicalView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_GetLogicalView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetLogicalView(ctx, req.(*GetLogicalViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListLogicalViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogicalViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListLogicalViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_ListLogicalViews_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListLogicalViews(ctx, req.(*ListLogicalViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateLogicalView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLogicalViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateLogicalView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_UpdateLogicalView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateLogicalView(ctx, req.(*UpdateLogicalViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteLogicalView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLogicalViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteLogicalView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_DeleteLogicalView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteLogicalView(ctx, req.(*DeleteLogicalViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateMaterializedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMaterializedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateMaterializedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_CreateMaterializedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateMaterializedView(ctx, req.(*CreateMaterializedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetMaterializedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMaterializedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetMaterializedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_GetMaterializedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetMaterializedView(ctx, req.(*GetMaterializedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListMaterializedViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMaterializedViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListMaterializedViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_ListMaterializedViews_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListMaterializedViews(ctx, req.(*ListMaterializedViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateMaterializedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMaterializedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateMaterializedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_UpdateMaterializedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateMaterializedView(ctx, req.(*UpdateMaterializedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteMaterializedView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMaterializedViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteMaterializedView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigtableInstanceAdmin_DeleteMaterializedView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteMaterializedView(ctx, req.(*DeleteMaterializedViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BigtableInstanceAdmin_ServiceDesc is the grpc.ServiceDesc for BigtableInstanceAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BigtableInstanceAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableInstanceAdmin",
	HandlerType: (*BigtableInstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInstance",
			Handler:    _BigtableInstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _BigtableInstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _BigtableInstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _BigtableInstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "PartialUpdateInstance",
			Handler:    _BigtableInstanceAdmin_PartialUpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _BigtableInstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _BigtableInstanceAdmin_CreateCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _BigtableInstanceAdmin_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _BigtableInstanceAdmin_ListClusters_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _BigtableInstanceAdmin_UpdateCluster_Handler,
		},
		{
			MethodName: "PartialUpdateCluster",
			Handler:    _BigtableInstanceAdmin_PartialUpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _BigtableInstanceAdmin_DeleteCluster_Handler,
		},
		{
			MethodName: "CreateAppProfile",
			Handler:    _BigtableInstanceAdmin_CreateAppProfile_Handler,
		},
		{
			MethodName: "GetAppProfile",
			Handler:    _BigtableInstanceAdmin_GetAppProfile_Handler,
		},
		{
			MethodName: "ListAppProfiles",
			Handler:    _BigtableInstanceAdmin_ListAppProfiles_Handler,
		},
		{
			MethodName: "UpdateAppProfile",
			Handler:    _BigtableInstanceAdmin_UpdateAppProfile_Handler,
		},
		{
			MethodName: "DeleteAppProfile",
			Handler:    _BigtableInstanceAdmin_DeleteAppProfile_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BigtableInstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BigtableInstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BigtableInstanceAdmin_TestIamPermissions_Handler,
		},
		{
			MethodName: "ListHotTablets",
			Handler:    _BigtableInstanceAdmin_ListHotTablets_Handler,
		},
		{
			MethodName: "CreateLogicalView",
			Handler:    _BigtableInstanceAdmin_CreateLogicalView_Handler,
		},
		{
			MethodName: "GetLogicalView",
			Handler:    _BigtableInstanceAdmin_GetLogicalView_Handler,
		},
		{
			MethodName: "ListLogicalViews",
			Handler:    _BigtableInstanceAdmin_ListLogicalViews_Handler,
		},
		{
			MethodName: "UpdateLogicalView",
			Handler:    _BigtableInstanceAdmin_UpdateLogicalView_Handler,
		},
		{
			MethodName: "DeleteLogicalView",
			Handler:    _BigtableInstanceAdmin_DeleteLogicalView_Handler,
		},
		{
			MethodName: "CreateMaterializedView",
			Handler:    _BigtableInstanceAdmin_CreateMaterializedView_Handler,
		},
		{
			MethodName: "GetMaterializedView",
			Handler:    _BigtableInstanceAdmin_GetMaterializedView_Handler,
		},
		{
			MethodName: "ListMaterializedViews",
			Handler:    _BigtableInstanceAdmin_ListMaterializedViews_Handler,
		},
		{
			MethodName: "UpdateMaterializedView",
			Handler:    _BigtableInstanceAdmin_UpdateMaterializedView_Handler,
		},
		{
			MethodName: "DeleteMaterializedView",
			Handler:    _BigtableInstanceAdmin_DeleteMaterializedView_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_instance_admin.proto",
}
