// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/networksecurity/v1beta1/dns_threat_detector.proto

package networksecuritypb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Name of the provider used for DNS threat analysis.
type DnsThreatDetector_Provider int32

const (
	// An unspecified provider.
	DnsThreatDetector_PROVIDER_UNSPECIFIED DnsThreatDetector_Provider = 0
	// The Infoblox DNS threat detector provider.
	DnsThreatDetector_INFOBLOX DnsThreatDetector_Provider = 1
)

// Enum value maps for DnsThreatDetector_Provider.
var (
	DnsThreatDetector_Provider_name = map[int32]string{
		0: "PROVIDER_UNSPECIFIED",
		1: "INFOBLOX",
	}
	DnsThreatDetector_Provider_value = map[string]int32{
		"PROVIDER_UNSPECIFIED": 0,
		"INFOBLOX":             1,
	}
)

func (x DnsThreatDetector_Provider) Enum() *DnsThreatDetector_Provider {
	p := new(DnsThreatDetector_Provider)
	*p = x
	return p
}

func (x DnsThreatDetector_Provider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DnsThreatDetector_Provider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_enumTypes[0].Descriptor()
}

func (DnsThreatDetector_Provider) Type() protoreflect.EnumType {
	return &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_enumTypes[0]
}

func (x DnsThreatDetector_Provider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DnsThreatDetector_Provider.Descriptor instead.
func (DnsThreatDetector_Provider) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{0, 0}
}

// A DNS threat detector sends DNS query logs to a _provider_ that then
// analyzes the logs to identify threat events in the DNS queries.
// By default, all VPC networks in your projects are included. You can exclude
// specific networks by supplying `excluded_networks`.
type DnsThreatDetector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Identifier. Name of the DnsThreatDetector resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Create time stamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Any labels associated with the DnsThreatDetector, listed as key
	// value pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A list of network resource names which aren't monitored by this
	// DnsThreatDetector.
	//
	// Example:
	// `projects/PROJECT_ID/global/networks/NETWORK_NAME`.
	ExcludedNetworks []string `protobuf:"bytes,5,rep,name=excluded_networks,json=excludedNetworks,proto3" json:"excluded_networks,omitempty"`
	// Required. The provider used for DNS threat analysis.
	Provider DnsThreatDetector_Provider `protobuf:"varint,6,opt,name=provider,proto3,enum=google.cloud.networksecurity.v1beta1.DnsThreatDetector_Provider" json:"provider,omitempty"`
}

func (x *DnsThreatDetector) Reset() {
	*x = DnsThreatDetector{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DnsThreatDetector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsThreatDetector) ProtoMessage() {}

func (x *DnsThreatDetector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsThreatDetector.ProtoReflect.Descriptor instead.
func (*DnsThreatDetector) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{0}
}

func (x *DnsThreatDetector) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DnsThreatDetector) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DnsThreatDetector) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DnsThreatDetector) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DnsThreatDetector) GetExcludedNetworks() []string {
	if x != nil {
		return x.ExcludedNetworks
	}
	return nil
}

func (x *DnsThreatDetector) GetProvider() DnsThreatDetector_Provider {
	if x != nil {
		return x.Provider
	}
	return DnsThreatDetector_PROVIDER_UNSPECIFIED
}

// The message for requesting a list of DnsThreatDetectors in the project.
type ListDnsThreatDetectorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for `ListDnsThreatDetectorsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The requested page size. The server may return fewer items than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token received from a previous
	// `ListDnsThreatDetectorsRequest` call. Provide this to retrieve the
	// subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDnsThreatDetectorsRequest) Reset() {
	*x = ListDnsThreatDetectorsRequest{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDnsThreatDetectorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDnsThreatDetectorsRequest) ProtoMessage() {}

func (x *ListDnsThreatDetectorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDnsThreatDetectorsRequest.ProtoReflect.Descriptor instead.
func (*ListDnsThreatDetectorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{1}
}

func (x *ListDnsThreatDetectorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDnsThreatDetectorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDnsThreatDetectorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message to requesting a list of DnsThreatDetectors.
type ListDnsThreatDetectorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of DnsThreatDetector resources.
	DnsThreatDetectors []*DnsThreatDetector `protobuf:"bytes,1,rep,name=dns_threat_detectors,json=dnsThreatDetectors,proto3" json:"dns_threat_detectors,omitempty"`
	// A token, which can be sent as `page_token`, to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unordered list. Unreachable `DnsThreatDetector` resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDnsThreatDetectorsResponse) Reset() {
	*x = ListDnsThreatDetectorsResponse{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDnsThreatDetectorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDnsThreatDetectorsResponse) ProtoMessage() {}

func (x *ListDnsThreatDetectorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDnsThreatDetectorsResponse.ProtoReflect.Descriptor instead.
func (*ListDnsThreatDetectorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{2}
}

func (x *ListDnsThreatDetectorsResponse) GetDnsThreatDetectors() []*DnsThreatDetector {
	if x != nil {
		return x.DnsThreatDetectors
	}
	return nil
}

func (x *ListDnsThreatDetectorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDnsThreatDetectorsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The message sent to get a DnsThreatDetector.
type GetDnsThreatDetectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the DnsThreatDetector resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDnsThreatDetectorRequest) Reset() {
	*x = GetDnsThreatDetectorRequest{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDnsThreatDetectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDnsThreatDetectorRequest) ProtoMessage() {}

func (x *GetDnsThreatDetectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDnsThreatDetectorRequest.ProtoReflect.Descriptor instead.
func (*GetDnsThreatDetectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{3}
}

func (x *GetDnsThreatDetectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The message to create a DnsThreatDetector.
type CreateDnsThreatDetectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The value for the parent of the DnsThreatDetector resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID of the requesting DnsThreatDetector object.
	// If this field is not supplied, the service generates an identifier.
	DnsThreatDetectorId string `protobuf:"bytes,2,opt,name=dns_threat_detector_id,json=dnsThreatDetectorId,proto3" json:"dns_threat_detector_id,omitempty"`
	// Required. The `DnsThreatDetector` resource to create.
	DnsThreatDetector *DnsThreatDetector `protobuf:"bytes,3,opt,name=dns_threat_detector,json=dnsThreatDetector,proto3" json:"dns_threat_detector,omitempty"`
}

func (x *CreateDnsThreatDetectorRequest) Reset() {
	*x = CreateDnsThreatDetectorRequest{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDnsThreatDetectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDnsThreatDetectorRequest) ProtoMessage() {}

func (x *CreateDnsThreatDetectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDnsThreatDetectorRequest.ProtoReflect.Descriptor instead.
func (*CreateDnsThreatDetectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{4}
}

func (x *CreateDnsThreatDetectorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDnsThreatDetectorRequest) GetDnsThreatDetectorId() string {
	if x != nil {
		return x.DnsThreatDetectorId
	}
	return ""
}

func (x *CreateDnsThreatDetectorRequest) GetDnsThreatDetector() *DnsThreatDetector {
	if x != nil {
		return x.DnsThreatDetector
	}
	return nil
}

// The message for updating a DnsThreatDetector.
type UpdateDnsThreatDetectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The field mask is used to specify the fields to be overwritten in
	// the DnsThreatDetector resource by the update. The fields specified in the
	// update_mask are relative to the resource, not the full request. A field
	// will be overwritten if it is in the mask. If the mask is not provided then
	// all fields present in the request will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The DnsThreatDetector resource being updated.
	DnsThreatDetector *DnsThreatDetector `protobuf:"bytes,2,opt,name=dns_threat_detector,json=dnsThreatDetector,proto3" json:"dns_threat_detector,omitempty"`
}

func (x *UpdateDnsThreatDetectorRequest) Reset() {
	*x = UpdateDnsThreatDetectorRequest{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDnsThreatDetectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDnsThreatDetectorRequest) ProtoMessage() {}

func (x *UpdateDnsThreatDetectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDnsThreatDetectorRequest.ProtoReflect.Descriptor instead.
func (*UpdateDnsThreatDetectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateDnsThreatDetectorRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDnsThreatDetectorRequest) GetDnsThreatDetector() *DnsThreatDetector {
	if x != nil {
		return x.DnsThreatDetector
	}
	return nil
}

// The message for deleting a DnsThreatDetector.
type DeleteDnsThreatDetectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the DnsThreatDetector resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDnsThreatDetectorRequest) Reset() {
	*x = DeleteDnsThreatDetectorRequest{}
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDnsThreatDetectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDnsThreatDetectorRequest) ProtoMessage() {}

func (x *DeleteDnsThreatDetectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDnsThreatDetectorRequest.ProtoReflect.Descriptor instead.
func (*DeleteDnsThreatDetectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteDnsThreatDetectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto protoreflect.FileDescriptor

var file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x05, 0x0a, 0x11, 0x44, 0x6e,
	0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x08, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x60, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x53, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x61, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x32, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e,
	0x46, 0x4f, 0x42, 0x4c, 0x4f, 0x58, 0x10, 0x01, 0x3a, 0xaf, 0x01, 0xea, 0x41, 0xab, 0x01, 0x0a,
	0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x6e, 0x73, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x64,
	0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x7d, 0x2a, 0x12, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x32, 0x11, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xb7, 0x01, 0x0a, 0x1d, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xda, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x14, 0x64, 0x6e, 0x73, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x12,
	0x64, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x06, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x6b, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a,
	0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x6c, 0x0a,
	0x13, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xd0, 0x01, 0x0a, 0x1e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x6c, 0x0a, 0x13, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x6e, 0x73,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x6e,
	0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xdf,
	0x0a, 0x0a, 0x18, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf1, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6e, 0x73,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12,
	0xde, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6e, 0x73, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xa7, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x8c, 0x01, 0xda, 0x41,
	0x31, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2c, 0x64, 0x6e, 0x73, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x13, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x3b, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xa9, 0x02, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x8e, 0x01, 0xda, 0x41, 0x1f, 0x64, 0x6e, 0x73, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66,
	0x3a, 0x13, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x32, 0x4f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x64, 0x6e, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a,
	0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca, 0x41,
	0x1e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xe1, 0x02, 0xea, 0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x7d, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x16,
	0x44, 0x6e, 0x73, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x62, 0xaa, 0x02, 0x24, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescOnce sync.Once
	file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescData = file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDesc
)

func file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescGZIP() []byte {
	file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescOnce.Do(func() {
		file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescData)
	})
	return file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDescData
}

var file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_goTypes = []any{
	(DnsThreatDetector_Provider)(0),        // 0: google.cloud.networksecurity.v1beta1.DnsThreatDetector.Provider
	(*DnsThreatDetector)(nil),              // 1: google.cloud.networksecurity.v1beta1.DnsThreatDetector
	(*ListDnsThreatDetectorsRequest)(nil),  // 2: google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsRequest
	(*ListDnsThreatDetectorsResponse)(nil), // 3: google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsResponse
	(*GetDnsThreatDetectorRequest)(nil),    // 4: google.cloud.networksecurity.v1beta1.GetDnsThreatDetectorRequest
	(*CreateDnsThreatDetectorRequest)(nil), // 5: google.cloud.networksecurity.v1beta1.CreateDnsThreatDetectorRequest
	(*UpdateDnsThreatDetectorRequest)(nil), // 6: google.cloud.networksecurity.v1beta1.UpdateDnsThreatDetectorRequest
	(*DeleteDnsThreatDetectorRequest)(nil), // 7: google.cloud.networksecurity.v1beta1.DeleteDnsThreatDetectorRequest
	nil,                                    // 8: google.cloud.networksecurity.v1beta1.DnsThreatDetector.LabelsEntry
	(*timestamppb.Timestamp)(nil),          // 9: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),          // 10: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                  // 11: google.protobuf.Empty
}
var file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_depIdxs = []int32{
	9,  // 0: google.cloud.networksecurity.v1beta1.DnsThreatDetector.create_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.cloud.networksecurity.v1beta1.DnsThreatDetector.update_time:type_name -> google.protobuf.Timestamp
	8,  // 2: google.cloud.networksecurity.v1beta1.DnsThreatDetector.labels:type_name -> google.cloud.networksecurity.v1beta1.DnsThreatDetector.LabelsEntry
	0,  // 3: google.cloud.networksecurity.v1beta1.DnsThreatDetector.provider:type_name -> google.cloud.networksecurity.v1beta1.DnsThreatDetector.Provider
	1,  // 4: google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsResponse.dns_threat_detectors:type_name -> google.cloud.networksecurity.v1beta1.DnsThreatDetector
	1,  // 5: google.cloud.networksecurity.v1beta1.CreateDnsThreatDetectorRequest.dns_threat_detector:type_name -> google.cloud.networksecurity.v1beta1.DnsThreatDetector
	10, // 6: google.cloud.networksecurity.v1beta1.UpdateDnsThreatDetectorRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 7: google.cloud.networksecurity.v1beta1.UpdateDnsThreatDetectorRequest.dns_threat_detector:type_name -> google.cloud.networksecurity.v1beta1.DnsThreatDetector
	2,  // 8: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.ListDnsThreatDetectors:input_type -> google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsRequest
	4,  // 9: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.GetDnsThreatDetector:input_type -> google.cloud.networksecurity.v1beta1.GetDnsThreatDetectorRequest
	5,  // 10: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.CreateDnsThreatDetector:input_type -> google.cloud.networksecurity.v1beta1.CreateDnsThreatDetectorRequest
	6,  // 11: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.UpdateDnsThreatDetector:input_type -> google.cloud.networksecurity.v1beta1.UpdateDnsThreatDetectorRequest
	7,  // 12: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.DeleteDnsThreatDetector:input_type -> google.cloud.networksecurity.v1beta1.DeleteDnsThreatDetectorRequest
	3,  // 13: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.ListDnsThreatDetectors:output_type -> google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsResponse
	1,  // 14: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.GetDnsThreatDetector:output_type -> google.cloud.networksecurity.v1beta1.DnsThreatDetector
	1,  // 15: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.CreateDnsThreatDetector:output_type -> google.cloud.networksecurity.v1beta1.DnsThreatDetector
	1,  // 16: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.UpdateDnsThreatDetector:output_type -> google.cloud.networksecurity.v1beta1.DnsThreatDetector
	11, // 17: google.cloud.networksecurity.v1beta1.DnsThreatDetectorService.DeleteDnsThreatDetector:output_type -> google.protobuf.Empty
	13, // [13:18] is the sub-list for method output_type
	8,  // [8:13] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_init() }
func file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_init() {
	if File_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_goTypes,
		DependencyIndexes: file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_depIdxs,
		EnumInfos:         file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_enumTypes,
		MessageInfos:      file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_msgTypes,
	}.Build()
	File_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto = out.File
	file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_rawDesc = nil
	file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_goTypes = nil
	file_google_cloud_networksecurity_v1beta1_dns_threat_detector_proto_depIdxs = nil
}
