// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Oracle Delegate Access Control API
//
// Oracle Delegate Access Control allows ExaCC and ExaCS customers to delegate management of their Exadata resources operators outside their tenancies.
// With Delegate Access Control, Support Providers can deliver managed services using comprehensive and robust tooling built on the OCI platform.
// Customers maintain control over who has access to the delegated resources in their tenancy and what actions can be taken.
// Enterprises managing resources across multiple tenants can use Delegate Access Control to streamline management tasks.
// Using logging service, customers can view a near real-time audit report of all actions performed by a Service Provider operator.
//

package delegateaccesscontrol

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DelegatedResourceAccessRequest A support operator raises Delegated Resource Access Request when they need access to any infrastructure resource governed by Delegation Control.
// The Delegated Resource Access Request identifies the target resource and the set of Service Provider Actions. Delegated Resource Access Request handling depends upon the Delegation Control
// that governs the target resource, and the set of Service Provider Actions listed for approval in the Delegated Resource Access Request. If all of the Service Provider Actions
// listed in the Delegated Resource Access Request are in the pre-approved list in the Delegation Control that governs the target resource, then the Delegated Resource Access Request is
// automatically approved. If not, then the Delegated Resource Access Request requires explicit approval from the approver group specified by the Delegation Control governing the target resource.
// You can approve or reject a Delegated Resource Access Request. You can also revoke the approval of an already approved Delegated Resource Access Request. While creating a Delegated Resource Access Request,
// the support operator specifies the duration of access. You have the option to approve the entire duration or reduce or even increase the time duration.
// A support operator can also request for an extension. The approval for such an extension is processed the same way the original Delegated Resource Access Request was processed.
type DelegatedResourceAccessRequest struct {

	// The OCID of the Delegated Resource Access Request.
	Id *string `mandatory:"true" json:"id"`

	// The OCID of the compartment that contains the Delegated Resource Access Request.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// A short description explaining why this Delegated Resource Access Request is needed by the support operator.
	ReasonForRequest *string `mandatory:"true" json:"reasonForRequest"`

	// Detailed description of this Delegated Resource Access Request.
	Description *string `mandatory:"true" json:"description"`

	// The OCID of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
	// access the target resource.
	ResourceId *string `mandatory:"true" json:"resourceId"`

	// Display name. This is generated by the system automatically.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
	TicketNumbers []string `mandatory:"false" json:"ticketNumbers"`

	// Requested access start time in UTC.
	TimeAccessRequested *common.SDKTime `mandatory:"false" json:"timeAccessRequested"`

	// The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to
	// access the target resource.
	ResourceName *string `mandatory:"false" json:"resourceName"`

	// Resource type for which the associated Delegation Control is applicable to.
	ResourceType DelegationControlResourceTypeEnum `mandatory:"false" json:"resourceType,omitempty"`

	// Requester type
	RequesterType DelegatedResourceAccessRequesterTypeEnum `mandatory:"false" json:"requesterType,omitempty"`

	// List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
	RequestedActionNames []string `mandatory:"false" json:"requestedActionNames"`

	// List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.
	DatabaseNameList []string `mandatory:"false" json:"databaseNameList"`

	// List of Service Provider Service Types being provided by the support operator user.
	ProvidedServiceTypes []ServiceProviderServiceTypeEnum `mandatory:"false" json:"providedServiceTypes,omitempty"`

	// List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.
	DelegationSubscriptionIds []string `mandatory:"false" json:"delegationSubscriptionIds"`

	// Priority assigned to the Delegated Resource Access Request by the support operator
	Severity DelegatedResourceAccessRequestSeverityEnum `mandatory:"false" json:"severity,omitempty"`

	// Duration in hours for which access is sought on the target resource.
	DurationInHours *int `mandatory:"false" json:"durationInHours"`

	// Duration in hours for which extension access is sought on the target resource.
	ExtendDurationInHours *int `mandatory:"false" json:"extendDurationInHours"`

	// Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
	IsAutoApproved *bool `mandatory:"false" json:"isAutoApproved"`

	// The current lifecycle state of the Delegated Resource Access Request.
	LifecycleState DelegatedResourceAccessRequestLifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`

	// Description of the current lifecycle state in more detail.
	LifecycleStateDetails *string `mandatory:"false" json:"lifecycleStateDetails"`

	// The current status of the Delegated Resource Access Request.
	RequestStatus DelegatedResourceAccessRequestStatusEnum `mandatory:"false" json:"requestStatus,omitempty"`

	// Time when the Delegated Resource Access Request was created in RFC 3339 (https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
	TimeCreated *common.SDKTime `mandatory:"false" json:"timeCreated"`

	// Time when the Delegated Resource Access Request was last modified in RFC 3339 (https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
	TimeUpdated *common.SDKTime `mandatory:"false" json:"timeUpdated"`

	// Number of initial approvals that have been obtained so far.
	NumInitialApprovals *int `mandatory:"false" json:"numInitialApprovals"`

	// Number of extension approvals that have been obtained so far.
	NumExtensionApprovals *int `mandatory:"false" json:"numExtensionApprovals"`

	// In case of single approval, this will have only one item. Else, a list of approvals.
	ApprovalInfo []DelegatedResourceAccessRequestApprovalDetails `mandatory:"false" json:"approvalInfo"`

	// The comment entered by the support operator while closing the request.
	ClosureComment *string `mandatory:"false" json:"closureComment"`

	// The OCID of the Delegation Control governing the target resource.
	DelegationControlId *string `mandatory:"false" json:"delegationControlId"`

	// Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.
	// By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.
	AuditTypes []DelegatedResourceAccessRequestAuditTypeEnum `mandatory:"false" json:"auditTypes,omitempty"`

	// Indicates if the delegated resource access request is waiting on more information from the operator
	IsPendingMoreInfo *bool `mandatory:"false" json:"isPendingMoreInfo"`

	// Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
	// For more information, see Resource Tags (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Department": "Finance"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// For more information, see Resource Tags (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Operations": {"CostCenter": "42"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m DelegatedResourceAccessRequest) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DelegatedResourceAccessRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingDelegationControlResourceTypeEnum(string(m.ResourceType)); !ok && m.ResourceType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ResourceType: %s. Supported values are: %s.", m.ResourceType, strings.Join(GetDelegationControlResourceTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequesterTypeEnum(string(m.RequesterType)); !ok && m.RequesterType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for RequesterType: %s. Supported values are: %s.", m.RequesterType, strings.Join(GetDelegatedResourceAccessRequesterTypeEnumStringValues(), ",")))
	}
	for _, val := range m.ProvidedServiceTypes {
		if _, ok := GetMappingServiceProviderServiceTypeEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ProvidedServiceTypes: %s. Supported values are: %s.", val, strings.Join(GetServiceProviderServiceTypeEnumStringValues(), ",")))
		}
	}

	if _, ok := GetMappingDelegatedResourceAccessRequestSeverityEnum(string(m.Severity)); !ok && m.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", m.Severity, strings.Join(GetDelegatedResourceAccessRequestSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequestLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetDelegatedResourceAccessRequestLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingDelegatedResourceAccessRequestStatusEnum(string(m.RequestStatus)); !ok && m.RequestStatus != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for RequestStatus: %s. Supported values are: %s.", m.RequestStatus, strings.Join(GetDelegatedResourceAccessRequestStatusEnumStringValues(), ",")))
	}
	for _, val := range m.AuditTypes {
		if _, ok := GetMappingDelegatedResourceAccessRequestAuditTypeEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for AuditTypes: %s. Supported values are: %s.", val, strings.Join(GetDelegatedResourceAccessRequestAuditTypeEnumStringValues(), ",")))
		}
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// DelegatedResourceAccessRequestLifecycleStateEnum Enum with underlying type: string
type DelegatedResourceAccessRequestLifecycleStateEnum string

// Set of constants representing the allowable values for DelegatedResourceAccessRequestLifecycleStateEnum
const (
	DelegatedResourceAccessRequestLifecycleStateAccepted       DelegatedResourceAccessRequestLifecycleStateEnum = "ACCEPTED"
	DelegatedResourceAccessRequestLifecycleStateInProgress     DelegatedResourceAccessRequestLifecycleStateEnum = "IN_PROGRESS"
	DelegatedResourceAccessRequestLifecycleStateWaiting        DelegatedResourceAccessRequestLifecycleStateEnum = "WAITING"
	DelegatedResourceAccessRequestLifecycleStateFailed         DelegatedResourceAccessRequestLifecycleStateEnum = "FAILED"
	DelegatedResourceAccessRequestLifecycleStateSucceeded      DelegatedResourceAccessRequestLifecycleStateEnum = "SUCCEEDED"
	DelegatedResourceAccessRequestLifecycleStateCanceling      DelegatedResourceAccessRequestLifecycleStateEnum = "CANCELING"
	DelegatedResourceAccessRequestLifecycleStateCanceled       DelegatedResourceAccessRequestLifecycleStateEnum = "CANCELED"
	DelegatedResourceAccessRequestLifecycleStateNeedsAttention DelegatedResourceAccessRequestLifecycleStateEnum = "NEEDS_ATTENTION"
)

var mappingDelegatedResourceAccessRequestLifecycleStateEnum = map[string]DelegatedResourceAccessRequestLifecycleStateEnum{
	"ACCEPTED":        DelegatedResourceAccessRequestLifecycleStateAccepted,
	"IN_PROGRESS":     DelegatedResourceAccessRequestLifecycleStateInProgress,
	"WAITING":         DelegatedResourceAccessRequestLifecycleStateWaiting,
	"FAILED":          DelegatedResourceAccessRequestLifecycleStateFailed,
	"SUCCEEDED":       DelegatedResourceAccessRequestLifecycleStateSucceeded,
	"CANCELING":       DelegatedResourceAccessRequestLifecycleStateCanceling,
	"CANCELED":        DelegatedResourceAccessRequestLifecycleStateCanceled,
	"NEEDS_ATTENTION": DelegatedResourceAccessRequestLifecycleStateNeedsAttention,
}

var mappingDelegatedResourceAccessRequestLifecycleStateEnumLowerCase = map[string]DelegatedResourceAccessRequestLifecycleStateEnum{
	"accepted":        DelegatedResourceAccessRequestLifecycleStateAccepted,
	"in_progress":     DelegatedResourceAccessRequestLifecycleStateInProgress,
	"waiting":         DelegatedResourceAccessRequestLifecycleStateWaiting,
	"failed":          DelegatedResourceAccessRequestLifecycleStateFailed,
	"succeeded":       DelegatedResourceAccessRequestLifecycleStateSucceeded,
	"canceling":       DelegatedResourceAccessRequestLifecycleStateCanceling,
	"canceled":        DelegatedResourceAccessRequestLifecycleStateCanceled,
	"needs_attention": DelegatedResourceAccessRequestLifecycleStateNeedsAttention,
}

// GetDelegatedResourceAccessRequestLifecycleStateEnumValues Enumerates the set of values for DelegatedResourceAccessRequestLifecycleStateEnum
func GetDelegatedResourceAccessRequestLifecycleStateEnumValues() []DelegatedResourceAccessRequestLifecycleStateEnum {
	values := make([]DelegatedResourceAccessRequestLifecycleStateEnum, 0)
	for _, v := range mappingDelegatedResourceAccessRequestLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetDelegatedResourceAccessRequestLifecycleStateEnumStringValues Enumerates the set of values in String for DelegatedResourceAccessRequestLifecycleStateEnum
func GetDelegatedResourceAccessRequestLifecycleStateEnumStringValues() []string {
	return []string{
		"ACCEPTED",
		"IN_PROGRESS",
		"WAITING",
		"FAILED",
		"SUCCEEDED",
		"CANCELING",
		"CANCELED",
		"NEEDS_ATTENTION",
	}
}

// GetMappingDelegatedResourceAccessRequestLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingDelegatedResourceAccessRequestLifecycleStateEnum(val string) (DelegatedResourceAccessRequestLifecycleStateEnum, bool) {
	enum, ok := mappingDelegatedResourceAccessRequestLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
