// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/datacatalog/v1/dump_content.proto

package datacatalogpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Wrapper containing Entry and information about Tags
// that should and should not be attached to it.
type TaggedEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Entry to be ingested.
	//
	// Types that are assignable to Entry:
	//
	//	*TaggedEntry_V1Entry
	Entry isTaggedEntry_Entry `protobuf_oneof:"entry"`
	// Optional. Tags that should be ingested into the Data Catalog.
	// Caller should populate template name, column and fields.
	PresentTags []*Tag `protobuf:"bytes,2,rep,name=present_tags,json=presentTags,proto3" json:"present_tags,omitempty"`
	// Optional. Tags that should be deleted from the Data Catalog.
	// Caller should populate template name and column only.
	AbsentTags []*Tag `protobuf:"bytes,3,rep,name=absent_tags,json=absentTags,proto3" json:"absent_tags,omitempty"`
}

func (x *TaggedEntry) Reset() {
	*x = TaggedEntry{}
	mi := &file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TaggedEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaggedEntry) ProtoMessage() {}

func (x *TaggedEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaggedEntry.ProtoReflect.Descriptor instead.
func (*TaggedEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_dump_content_proto_rawDescGZIP(), []int{0}
}

func (m *TaggedEntry) GetEntry() isTaggedEntry_Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (x *TaggedEntry) GetV1Entry() *Entry {
	if x, ok := x.GetEntry().(*TaggedEntry_V1Entry); ok {
		return x.V1Entry
	}
	return nil
}

func (x *TaggedEntry) GetPresentTags() []*Tag {
	if x != nil {
		return x.PresentTags
	}
	return nil
}

func (x *TaggedEntry) GetAbsentTags() []*Tag {
	if x != nil {
		return x.AbsentTags
	}
	return nil
}

type isTaggedEntry_Entry interface {
	isTaggedEntry_Entry()
}

type TaggedEntry_V1Entry struct {
	// Non-encrypted Data Catalog v1 Entry.
	V1Entry *Entry `protobuf:"bytes,1,opt,name=v1_entry,json=v1Entry,proto3,oneof"`
}

func (*TaggedEntry_V1Entry) isTaggedEntry_Entry() {}

// Wrapper for any item that can be contained in the dump.
type DumpItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Item:
	//
	//	*DumpItem_TaggedEntry
	Item isDumpItem_Item `protobuf_oneof:"item"`
}

func (x *DumpItem) Reset() {
	*x = DumpItem{}
	mi := &file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DumpItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DumpItem) ProtoMessage() {}

func (x *DumpItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DumpItem.ProtoReflect.Descriptor instead.
func (*DumpItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_dump_content_proto_rawDescGZIP(), []int{1}
}

func (m *DumpItem) GetItem() isDumpItem_Item {
	if m != nil {
		return m.Item
	}
	return nil
}

func (x *DumpItem) GetTaggedEntry() *TaggedEntry {
	if x, ok := x.GetItem().(*DumpItem_TaggedEntry); ok {
		return x.TaggedEntry
	}
	return nil
}

type isDumpItem_Item interface {
	isDumpItem_Item()
}

type DumpItem_TaggedEntry struct {
	// Entry and its tags.
	TaggedEntry *TaggedEntry `protobuf:"bytes,1,opt,name=tagged_entry,json=taggedEntry,proto3,oneof"`
}

func (*DumpItem_TaggedEntry) isDumpItem_Item() {}

var File_google_cloud_datacatalog_v1_dump_content_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_dump_content_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe9, 0x01, 0x0a, 0x0b, 0x54, 0x61, 0x67, 0x67, 0x65, 0x64,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x08, 0x76, 0x31, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x07, 0x76,
	0x31, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x48, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x54, 0x61, 0x67, 0x73,
	0x12, 0x46, 0x0a, 0x0b, 0x61, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x62,
	0x73, 0x65, 0x6e, 0x74, 0x54, 0x61, 0x67, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x22, 0x61, 0x0a, 0x08, 0x44, 0x75, 0x6d, 0x70, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x4d, 0x0a,
	0x0c, 0x74, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x67, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52,
	0x0b, 0x74, 0x61, 0x67, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x06, 0x0a, 0x04,
	0x69, 0x74, 0x65, 0x6d, 0x42, 0xd5, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x44, 0x75, 0x6d, 0x70, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70,
	0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0xaa,
	0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74,
	0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74,
	0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_dump_content_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_dump_content_proto_rawDescData = file_google_cloud_datacatalog_v1_dump_content_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_dump_content_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_dump_content_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_dump_content_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_dump_content_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_dump_content_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_datacatalog_v1_dump_content_proto_goTypes = []any{
	(*TaggedEntry)(nil), // 0: google.cloud.datacatalog.v1.TaggedEntry
	(*DumpItem)(nil),    // 1: google.cloud.datacatalog.v1.DumpItem
	(*Entry)(nil),       // 2: google.cloud.datacatalog.v1.Entry
	(*Tag)(nil),         // 3: google.cloud.datacatalog.v1.Tag
}
var file_google_cloud_datacatalog_v1_dump_content_proto_depIdxs = []int32{
	2, // 0: google.cloud.datacatalog.v1.TaggedEntry.v1_entry:type_name -> google.cloud.datacatalog.v1.Entry
	3, // 1: google.cloud.datacatalog.v1.TaggedEntry.present_tags:type_name -> google.cloud.datacatalog.v1.Tag
	3, // 2: google.cloud.datacatalog.v1.TaggedEntry.absent_tags:type_name -> google.cloud.datacatalog.v1.Tag
	0, // 3: google.cloud.datacatalog.v1.DumpItem.tagged_entry:type_name -> google.cloud.datacatalog.v1.TaggedEntry
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_dump_content_proto_init() }
func file_google_cloud_datacatalog_v1_dump_content_proto_init() {
	if File_google_cloud_datacatalog_v1_dump_content_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1_datacatalog_proto_init()
	file_google_cloud_datacatalog_v1_tags_proto_init()
	file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes[0].OneofWrappers = []any{
		(*TaggedEntry_V1Entry)(nil),
	}
	file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes[1].OneofWrappers = []any{
		(*DumpItem_TaggedEntry)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_dump_content_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_dump_content_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_dump_content_proto_depIdxs,
		MessageInfos:      file_google_cloud_datacatalog_v1_dump_content_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_dump_content_proto = out.File
	file_google_cloud_datacatalog_v1_dump_content_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_dump_content_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_dump_content_proto_depIdxs = nil
}
