// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/managedidentities/v1/managed_identities_service.proto

package managedidentitiespb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ManagedIdentitiesService_CreateMicrosoftAdDomain_FullMethodName = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/CreateMicrosoftAdDomain"
	ManagedIdentitiesService_ResetAdminPassword_FullMethodName      = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ResetAdminPassword"
	ManagedIdentitiesService_ListDomains_FullMethodName             = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ListDomains"
	ManagedIdentitiesService_GetDomain_FullMethodName               = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/GetDomain"
	ManagedIdentitiesService_UpdateDomain_FullMethodName            = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/UpdateDomain"
	ManagedIdentitiesService_DeleteDomain_FullMethodName            = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DeleteDomain"
	ManagedIdentitiesService_AttachTrust_FullMethodName             = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/AttachTrust"
	ManagedIdentitiesService_ReconfigureTrust_FullMethodName        = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ReconfigureTrust"
	ManagedIdentitiesService_DetachTrust_FullMethodName             = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DetachTrust"
	ManagedIdentitiesService_ValidateTrust_FullMethodName           = "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ValidateTrust"
)

// ManagedIdentitiesServiceClient is the client API for ManagedIdentitiesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ManagedIdentitiesServiceClient interface {
	// Creates a Microsoft AD domain.
	CreateMicrosoftAdDomain(ctx context.Context, in *CreateMicrosoftAdDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resets a domain's administrator password.
	ResetAdminPassword(ctx context.Context, in *ResetAdminPasswordRequest, opts ...grpc.CallOption) (*ResetAdminPasswordResponse, error)
	// Lists domains in a project.
	ListDomains(ctx context.Context, in *ListDomainsRequest, opts ...grpc.CallOption) (*ListDomainsResponse, error)
	// Gets information about a domain.
	GetDomain(ctx context.Context, in *GetDomainRequest, opts ...grpc.CallOption) (*Domain, error)
	// Updates the metadata and configuration of a domain.
	UpdateDomain(ctx context.Context, in *UpdateDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a domain.
	DeleteDomain(ctx context.Context, in *DeleteDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds an AD trust to a domain.
	AttachTrust(ctx context.Context, in *AttachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the DNS conditional forwarder.
	ReconfigureTrust(ctx context.Context, in *ReconfigureTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes an AD trust.
	DetachTrust(ctx context.Context, in *DetachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Validates a trust state, that the target domain is reachable, and that the
	// target domain is able to accept incoming trust requests.
	ValidateTrust(ctx context.Context, in *ValidateTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type managedIdentitiesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedIdentitiesServiceClient(cc grpc.ClientConnInterface) ManagedIdentitiesServiceClient {
	return &managedIdentitiesServiceClient{cc}
}

func (c *managedIdentitiesServiceClient) CreateMicrosoftAdDomain(ctx context.Context, in *CreateMicrosoftAdDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_CreateMicrosoftAdDomain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ResetAdminPassword(ctx context.Context, in *ResetAdminPasswordRequest, opts ...grpc.CallOption) (*ResetAdminPasswordResponse, error) {
	out := new(ResetAdminPasswordResponse)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_ResetAdminPassword_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ListDomains(ctx context.Context, in *ListDomainsRequest, opts ...grpc.CallOption) (*ListDomainsResponse, error) {
	out := new(ListDomainsResponse)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_ListDomains_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) GetDomain(ctx context.Context, in *GetDomainRequest, opts ...grpc.CallOption) (*Domain, error) {
	out := new(Domain)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_GetDomain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) UpdateDomain(ctx context.Context, in *UpdateDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_UpdateDomain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) DeleteDomain(ctx context.Context, in *DeleteDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_DeleteDomain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) AttachTrust(ctx context.Context, in *AttachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_AttachTrust_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ReconfigureTrust(ctx context.Context, in *ReconfigureTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_ReconfigureTrust_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) DetachTrust(ctx context.Context, in *DetachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_DetachTrust_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ValidateTrust(ctx context.Context, in *ValidateTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedIdentitiesService_ValidateTrust_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedIdentitiesServiceServer is the server API for ManagedIdentitiesService service.
// All implementations should embed UnimplementedManagedIdentitiesServiceServer
// for forward compatibility
type ManagedIdentitiesServiceServer interface {
	// Creates a Microsoft AD domain.
	CreateMicrosoftAdDomain(context.Context, *CreateMicrosoftAdDomainRequest) (*longrunningpb.Operation, error)
	// Resets a domain's administrator password.
	ResetAdminPassword(context.Context, *ResetAdminPasswordRequest) (*ResetAdminPasswordResponse, error)
	// Lists domains in a project.
	ListDomains(context.Context, *ListDomainsRequest) (*ListDomainsResponse, error)
	// Gets information about a domain.
	GetDomain(context.Context, *GetDomainRequest) (*Domain, error)
	// Updates the metadata and configuration of a domain.
	UpdateDomain(context.Context, *UpdateDomainRequest) (*longrunningpb.Operation, error)
	// Deletes a domain.
	DeleteDomain(context.Context, *DeleteDomainRequest) (*longrunningpb.Operation, error)
	// Adds an AD trust to a domain.
	AttachTrust(context.Context, *AttachTrustRequest) (*longrunningpb.Operation, error)
	// Updates the DNS conditional forwarder.
	ReconfigureTrust(context.Context, *ReconfigureTrustRequest) (*longrunningpb.Operation, error)
	// Removes an AD trust.
	DetachTrust(context.Context, *DetachTrustRequest) (*longrunningpb.Operation, error)
	// Validates a trust state, that the target domain is reachable, and that the
	// target domain is able to accept incoming trust requests.
	ValidateTrust(context.Context, *ValidateTrustRequest) (*longrunningpb.Operation, error)
}

// UnimplementedManagedIdentitiesServiceServer should be embedded to have forward compatible implementations.
type UnimplementedManagedIdentitiesServiceServer struct {
}

func (UnimplementedManagedIdentitiesServiceServer) CreateMicrosoftAdDomain(context.Context, *CreateMicrosoftAdDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMicrosoftAdDomain not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) ResetAdminPassword(context.Context, *ResetAdminPasswordRequest) (*ResetAdminPasswordResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetAdminPassword not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) ListDomains(context.Context, *ListDomainsRequest) (*ListDomainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDomains not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) GetDomain(context.Context, *GetDomainRequest) (*Domain, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDomain not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) UpdateDomain(context.Context, *UpdateDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDomain not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) DeleteDomain(context.Context, *DeleteDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDomain not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) AttachTrust(context.Context, *AttachTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachTrust not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) ReconfigureTrust(context.Context, *ReconfigureTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconfigureTrust not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) DetachTrust(context.Context, *DetachTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachTrust not implemented")
}
func (UnimplementedManagedIdentitiesServiceServer) ValidateTrust(context.Context, *ValidateTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateTrust not implemented")
}

// UnsafeManagedIdentitiesServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ManagedIdentitiesServiceServer will
// result in compilation errors.
type UnsafeManagedIdentitiesServiceServer interface {
	mustEmbedUnimplementedManagedIdentitiesServiceServer()
}

func RegisterManagedIdentitiesServiceServer(s grpc.ServiceRegistrar, srv ManagedIdentitiesServiceServer) {
	s.RegisterService(&ManagedIdentitiesService_ServiceDesc, srv)
}

func _ManagedIdentitiesService_CreateMicrosoftAdDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMicrosoftAdDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).CreateMicrosoftAdDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_CreateMicrosoftAdDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).CreateMicrosoftAdDomain(ctx, req.(*CreateMicrosoftAdDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ResetAdminPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetAdminPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ResetAdminPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_ResetAdminPassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ResetAdminPassword(ctx, req.(*ResetAdminPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ListDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ListDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_ListDomains_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ListDomains(ctx, req.(*ListDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_GetDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).GetDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_GetDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).GetDomain(ctx, req.(*GetDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_UpdateDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).UpdateDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_UpdateDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).UpdateDomain(ctx, req.(*UpdateDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_DeleteDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).DeleteDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_DeleteDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).DeleteDomain(ctx, req.(*DeleteDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_AttachTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).AttachTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_AttachTrust_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).AttachTrust(ctx, req.(*AttachTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ReconfigureTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReconfigureTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ReconfigureTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_ReconfigureTrust_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ReconfigureTrust(ctx, req.(*ReconfigureTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_DetachTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).DetachTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_DetachTrust_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).DetachTrust(ctx, req.(*DetachTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ValidateTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ValidateTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedIdentitiesService_ValidateTrust_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ValidateTrust(ctx, req.(*ValidateTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ManagedIdentitiesService_ServiceDesc is the grpc.ServiceDesc for ManagedIdentitiesService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ManagedIdentitiesService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.managedidentities.v1.ManagedIdentitiesService",
	HandlerType: (*ManagedIdentitiesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMicrosoftAdDomain",
			Handler:    _ManagedIdentitiesService_CreateMicrosoftAdDomain_Handler,
		},
		{
			MethodName: "ResetAdminPassword",
			Handler:    _ManagedIdentitiesService_ResetAdminPassword_Handler,
		},
		{
			MethodName: "ListDomains",
			Handler:    _ManagedIdentitiesService_ListDomains_Handler,
		},
		{
			MethodName: "GetDomain",
			Handler:    _ManagedIdentitiesService_GetDomain_Handler,
		},
		{
			MethodName: "UpdateDomain",
			Handler:    _ManagedIdentitiesService_UpdateDomain_Handler,
		},
		{
			MethodName: "DeleteDomain",
			Handler:    _ManagedIdentitiesService_DeleteDomain_Handler,
		},
		{
			MethodName: "AttachTrust",
			Handler:    _ManagedIdentitiesService_AttachTrust_Handler,
		},
		{
			MethodName: "ReconfigureTrust",
			Handler:    _ManagedIdentitiesService_ReconfigureTrust_Handler,
		},
		{
			MethodName: "DetachTrust",
			Handler:    _ManagedIdentitiesService_DetachTrust_Handler,
		},
		{
			MethodName: "ValidateTrust",
			Handler:    _ManagedIdentitiesService_ValidateTrust_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/managedidentities/v1/managed_identities_service.proto",
}
