// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/ai/assistants/v1/searchindex/search_index_file_service.proto

package searchindex

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	SearchIndexFileService_BatchCreate_FullMethodName = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexFileService/BatchCreate"
	SearchIndexFileService_Get_FullMethodName         = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexFileService/Get"
	SearchIndexFileService_List_FullMethodName        = "/yandex.cloud.ai.assistants.v1.searchindex.SearchIndexFileService/List"
)

// SearchIndexFileServiceClient is the client API for SearchIndexFileService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// SearchIndexFileService provides operations for managing files within search indexes.
type SearchIndexFileServiceClient interface {
	// Creates multiple files within a search index in [asynchronous mode](/docs/foundation-models/concepts/#working-mode).
	BatchCreate(ctx context.Context, in *BatchCreateSearchIndexFileRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves details of a specific file that has been indexed within a search index.
	Get(ctx context.Context, in *GetSearchIndexFileRequest, opts ...grpc.CallOption) (*SearchIndexFile, error)
	// List files that are indexed within a specific search index.
	List(ctx context.Context, in *ListSearchIndexFilesRequest, opts ...grpc.CallOption) (*ListSearchIndexFilesResponse, error)
}

type searchIndexFileServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchIndexFileServiceClient(cc grpc.ClientConnInterface) SearchIndexFileServiceClient {
	return &searchIndexFileServiceClient{cc}
}

func (c *searchIndexFileServiceClient) BatchCreate(ctx context.Context, in *BatchCreateSearchIndexFileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SearchIndexFileService_BatchCreate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchIndexFileServiceClient) Get(ctx context.Context, in *GetSearchIndexFileRequest, opts ...grpc.CallOption) (*SearchIndexFile, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SearchIndexFile)
	err := c.cc.Invoke(ctx, SearchIndexFileService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchIndexFileServiceClient) List(ctx context.Context, in *ListSearchIndexFilesRequest, opts ...grpc.CallOption) (*ListSearchIndexFilesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSearchIndexFilesResponse)
	err := c.cc.Invoke(ctx, SearchIndexFileService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchIndexFileServiceServer is the server API for SearchIndexFileService service.
// All implementations should embed UnimplementedSearchIndexFileServiceServer
// for forward compatibility.
//
// SearchIndexFileService provides operations for managing files within search indexes.
type SearchIndexFileServiceServer interface {
	// Creates multiple files within a search index in [asynchronous mode](/docs/foundation-models/concepts/#working-mode).
	BatchCreate(context.Context, *BatchCreateSearchIndexFileRequest) (*operation.Operation, error)
	// Retrieves details of a specific file that has been indexed within a search index.
	Get(context.Context, *GetSearchIndexFileRequest) (*SearchIndexFile, error)
	// List files that are indexed within a specific search index.
	List(context.Context, *ListSearchIndexFilesRequest) (*ListSearchIndexFilesResponse, error)
}

// UnimplementedSearchIndexFileServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSearchIndexFileServiceServer struct{}

func (UnimplementedSearchIndexFileServiceServer) BatchCreate(context.Context, *BatchCreateSearchIndexFileRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreate not implemented")
}
func (UnimplementedSearchIndexFileServiceServer) Get(context.Context, *GetSearchIndexFileRequest) (*SearchIndexFile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedSearchIndexFileServiceServer) List(context.Context, *ListSearchIndexFilesRequest) (*ListSearchIndexFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSearchIndexFileServiceServer) testEmbeddedByValue() {}

// UnsafeSearchIndexFileServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SearchIndexFileServiceServer will
// result in compilation errors.
type UnsafeSearchIndexFileServiceServer interface {
	mustEmbedUnimplementedSearchIndexFileServiceServer()
}

func RegisterSearchIndexFileServiceServer(s grpc.ServiceRegistrar, srv SearchIndexFileServiceServer) {
	// If the following call pancis, it indicates UnimplementedSearchIndexFileServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SearchIndexFileService_ServiceDesc, srv)
}

func _SearchIndexFileService_BatchCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateSearchIndexFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexFileServiceServer).BatchCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexFileService_BatchCreate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexFileServiceServer).BatchCreate(ctx, req.(*BatchCreateSearchIndexFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchIndexFileService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchIndexFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexFileServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexFileService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexFileServiceServer).Get(ctx, req.(*GetSearchIndexFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchIndexFileService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSearchIndexFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchIndexFileServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SearchIndexFileService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchIndexFileServiceServer).List(ctx, req.(*ListSearchIndexFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SearchIndexFileService_ServiceDesc is the grpc.ServiceDesc for SearchIndexFileService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SearchIndexFileService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.ai.assistants.v1.searchindex.SearchIndexFileService",
	HandlerType: (*SearchIndexFileServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchCreate",
			Handler:    _SearchIndexFileService_BatchCreate_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SearchIndexFileService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SearchIndexFileService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/ai/assistants/v1/searchindex/search_index_file_service.proto",
}
