// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/vpc/v1/gateway_service.proto

package vpc

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetGatewayRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Gateway resource to return.
	//
	// To get Gateway resource ID make a [GatewayService.List] request.
	GatewayId     string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGatewayRequest) Reset() {
	*x = GetGatewayRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGatewayRequest) ProtoMessage() {}

func (x *GetGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGatewayRequest.ProtoReflect.Descriptor instead.
func (*GetGatewayRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetGatewayRequest) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

type ListGatewaysRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list gateways in.
	//
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`, the service returns a [ListGatewaysResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListGatewaysResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters Gateway listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Gateway.name] field.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	// Example of a filter: `name=my-gateway`.
	Filter        string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListGatewaysRequest) Reset() {
	*x = ListGatewaysRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGatewaysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewaysRequest) ProtoMessage() {}

func (x *ListGatewaysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewaysRequest.ProtoReflect.Descriptor instead.
func (*ListGatewaysRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListGatewaysRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListGatewaysRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGatewaysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGatewaysRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListGatewaysResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of gateways.
	Gateways []*Gateway `protobuf:"bytes,1,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListGatewaysRequest.page_size], use `next_page_token` as the value
	// for the [ListGatewaysRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListGatewaysResponse) Reset() {
	*x = ListGatewaysResponse{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGatewaysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewaysResponse) ProtoMessage() {}

func (x *ListGatewaysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewaysResponse.ProtoReflect.Descriptor instead.
func (*ListGatewaysResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListGatewaysResponse) GetGateways() []*Gateway {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *ListGatewaysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type ListGatewayOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the gateway to list operations for.
	//
	// To get a gateway ID make a [GatewayService.List] request.
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListGatewayOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListGatewayOperationsResponse.next_page_token] returned by a previous list request.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListGatewayOperationsRequest) Reset() {
	*x = ListGatewayOperationsRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGatewayOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewayOperationsRequest) ProtoMessage() {}

func (x *ListGatewayOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewayOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListGatewayOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListGatewayOperationsRequest) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *ListGatewayOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGatewayOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListGatewayOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified gateway.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListGatewayOperationsRequest.page_size], use `next_page_token` as the value
	// for the [ListGatewayOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListGatewayOperationsResponse) Reset() {
	*x = ListGatewayOperationsResponse{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGatewayOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGatewayOperationsResponse) ProtoMessage() {}

func (x *ListGatewayOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGatewayOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListGatewayOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListGatewayOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListGatewayOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type SharedEgressGatewaySpec struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SharedEgressGatewaySpec) Reset() {
	*x = SharedEgressGatewaySpec{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SharedEgressGatewaySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharedEgressGatewaySpec) ProtoMessage() {}

func (x *SharedEgressGatewaySpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharedEgressGatewaySpec.ProtoReflect.Descriptor instead.
func (*SharedEgressGatewaySpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{5}
}

type CreateGatewayRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create a gateway in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the gateway.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the gateway.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Gateway labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Gateway configuration specification
	//
	// Types that are valid to be assigned to Gateway:
	//
	//	*CreateGatewayRequest_SharedEgressGatewaySpec
	Gateway       isCreateGatewayRequest_Gateway `protobuf_oneof:"gateway"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateGatewayRequest) Reset() {
	*x = CreateGatewayRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGatewayRequest) ProtoMessage() {}

func (x *CreateGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGatewayRequest.ProtoReflect.Descriptor instead.
func (*CreateGatewayRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateGatewayRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateGatewayRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateGatewayRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateGatewayRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateGatewayRequest) GetGateway() isCreateGatewayRequest_Gateway {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *CreateGatewayRequest) GetSharedEgressGatewaySpec() *SharedEgressGatewaySpec {
	if x != nil {
		if x, ok := x.Gateway.(*CreateGatewayRequest_SharedEgressGatewaySpec); ok {
			return x.SharedEgressGatewaySpec
		}
	}
	return nil
}

type isCreateGatewayRequest_Gateway interface {
	isCreateGatewayRequest_Gateway()
}

type CreateGatewayRequest_SharedEgressGatewaySpec struct {
	SharedEgressGatewaySpec *SharedEgressGatewaySpec `protobuf:"bytes,5,opt,name=shared_egress_gateway_spec,json=sharedEgressGatewaySpec,proto3,oneof"`
}

func (*CreateGatewayRequest_SharedEgressGatewaySpec) isCreateGatewayRequest_Gateway() {}

type CreateGatewayMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the gateway that is being created.
	GatewayId     string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateGatewayMetadata) Reset() {
	*x = CreateGatewayMetadata{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGatewayMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGatewayMetadata) ProtoMessage() {}

func (x *CreateGatewayMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGatewayMetadata.ProtoReflect.Descriptor instead.
func (*CreateGatewayMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateGatewayMetadata) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

type UpdateGatewayRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the gateway to update.
	//
	// To get the gateway ID make a [GatewayService.List] request.
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Field mask that specifies which attributes of the Gateway should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name for the gateway.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New description of the gateway.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Gateway labels as `key:value` pairs.
	//
	// Existing set of labels is completely replaced by the provided set, so if you just want
	// to add or remove a label:
	// 1. Get the current set of labels with a [GatewayService.Get] request.
	// 2. Add or remove a label in this set.
	// 3. Send the new set in this field.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// New Gateway configuration specification
	//
	// Types that are valid to be assigned to Gateway:
	//
	//	*UpdateGatewayRequest_SharedEgressGatewaySpec
	Gateway       isUpdateGatewayRequest_Gateway `protobuf_oneof:"gateway"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateGatewayRequest) Reset() {
	*x = UpdateGatewayRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGatewayRequest) ProtoMessage() {}

func (x *UpdateGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGatewayRequest.ProtoReflect.Descriptor instead.
func (*UpdateGatewayRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateGatewayRequest) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *UpdateGatewayRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateGatewayRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateGatewayRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateGatewayRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateGatewayRequest) GetGateway() isUpdateGatewayRequest_Gateway {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *UpdateGatewayRequest) GetSharedEgressGatewaySpec() *SharedEgressGatewaySpec {
	if x != nil {
		if x, ok := x.Gateway.(*UpdateGatewayRequest_SharedEgressGatewaySpec); ok {
			return x.SharedEgressGatewaySpec
		}
	}
	return nil
}

type isUpdateGatewayRequest_Gateway interface {
	isUpdateGatewayRequest_Gateway()
}

type UpdateGatewayRequest_SharedEgressGatewaySpec struct {
	SharedEgressGatewaySpec *SharedEgressGatewaySpec `protobuf:"bytes,6,opt,name=shared_egress_gateway_spec,json=sharedEgressGatewaySpec,proto3,oneof"`
}

func (*UpdateGatewayRequest_SharedEgressGatewaySpec) isUpdateGatewayRequest_Gateway() {}

type UpdateGatewayMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Gateway that is being updated.
	GatewayId     string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateGatewayMetadata) Reset() {
	*x = UpdateGatewayMetadata{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGatewayMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGatewayMetadata) ProtoMessage() {}

func (x *UpdateGatewayMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGatewayMetadata.ProtoReflect.Descriptor instead.
func (*UpdateGatewayMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateGatewayMetadata) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

type DeleteGatewayRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the gateway to delete.
	//
	// To get a gateway ID make a [GatewayService.List] request.
	GatewayId     string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteGatewayRequest) Reset() {
	*x = DeleteGatewayRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGatewayRequest) ProtoMessage() {}

func (x *DeleteGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGatewayRequest.ProtoReflect.Descriptor instead.
func (*DeleteGatewayRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteGatewayRequest) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

type DeleteGatewayMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the gateway that is being deleted.
	GatewayId     string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteGatewayMetadata) Reset() {
	*x = DeleteGatewayMetadata{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGatewayMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGatewayMetadata) ProtoMessage() {}

func (x *DeleteGatewayMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGatewayMetadata.ProtoReflect.Descriptor instead.
func (*DeleteGatewayMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteGatewayMetadata) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

type MoveGatewayRequest struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	GatewayId           string                 `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	DestinationFolderId string                 `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *MoveGatewayRequest) Reset() {
	*x = MoveGatewayRequest{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveGatewayRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveGatewayRequest) ProtoMessage() {}

func (x *MoveGatewayRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveGatewayRequest.ProtoReflect.Descriptor instead.
func (*MoveGatewayRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{12}
}

func (x *MoveGatewayRequest) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *MoveGatewayRequest) GetDestinationFolderId() string {
	if x != nil {
		return x.DestinationFolderId
	}
	return ""
}

type MoveGatewayMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GatewayId     string                 `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MoveGatewayMetadata) Reset() {
	*x = MoveGatewayMetadata{}
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveGatewayMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveGatewayMetadata) ProtoMessage() {}

func (x *MoveGatewayMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveGatewayMetadata.ProtoReflect.Descriptor instead.
func (*MoveGatewayMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP(), []int{13}
}

func (x *MoveGatewayMetadata) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

var File_yandex_cloud_vpc_v1_gateway_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_vpc_v1_gateway_service_proto_rawDesc = "" +
	"\n" +
	")yandex/cloud/vpc/v1/gateway_service.proto\x12\x13yandex.cloud.vpc.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a yandex/cloud/api/operation.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\x1a!yandex/cloud/vpc/v1/gateway.proto\"@\n" +
	"\x11GetGatewayRequest\x12+\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tgatewayId\"\xb7\x01\n" +
	"\x13ListGatewaysRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\"x\n" +
	"\x14ListGatewaysResponse\x128\n" +
	"\bgateways\x18\x01 \x03(\v2\x1c.yandex.cloud.vpc.v1.GatewayR\bgateways\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x9e\x01\n" +
	"\x1cListGatewayOperationsRequest\x12+\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tgatewayId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x8a\x01\n" +
	"\x1dListGatewayOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x19\n" +
	"\x17SharedEgressGatewaySpec\"\xf0\x03\n" +
	"\x14CreateGatewayRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x128\n" +
	"\x04name\x18\x02 \x01(\tB$\xf2\xc71 |[a-z]([-a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x92\x01\n" +
	"\x06labels\x18\x04 \x03(\v25.yandex.cloud.vpc.v1.CreateGatewayRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12k\n" +
	"\x1ashared_egress_gateway_spec\x18\x05 \x01(\v2,.yandex.cloud.vpc.v1.SharedEgressGatewaySpecH\x00R\x17sharedEgressGatewaySpec\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\t\n" +
	"\agateway\"6\n" +
	"\x15CreateGatewayMetadata\x12\x1d\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tR\tgatewayId\"\xaf\x04\n" +
	"\x14UpdateGatewayRequest\x12+\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tgatewayId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x128\n" +
	"\x04name\x18\x03 \x01(\tB$\xf2\xc71 |[a-z]([-a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x92\x01\n" +
	"\x06labels\x18\x05 \x03(\v25.yandex.cloud.vpc.v1.UpdateGatewayRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12k\n" +
	"\x1ashared_egress_gateway_spec\x18\x06 \x01(\v2,.yandex.cloud.vpc.v1.SharedEgressGatewaySpecH\x00R\x17sharedEgressGatewaySpec\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\t\n" +
	"\agateway\"6\n" +
	"\x15UpdateGatewayMetadata\x12\x1d\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tR\tgatewayId\"C\n" +
	"\x14DeleteGatewayRequest\x12+\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tgatewayId\"6\n" +
	"\x15DeleteGatewayMetadata\x12\x1d\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tR\tgatewayId\"\x83\x01\n" +
	"\x12MoveGatewayRequest\x12+\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tgatewayId\x12@\n" +
	"\x15destination_folder_id\x18\x02 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x13destinationFolderId\"4\n" +
	"\x13MoveGatewayMetadata\x12\x1d\n" +
	"\n" +
	"gateway_id\x18\x01 \x01(\tR\tgatewayId2\xc0\b\n" +
	"\x0eGatewayService\x12r\n" +
	"\x03Get\x12&.yandex.cloud.vpc.v1.GetGatewayRequest\x1a\x1c.yandex.cloud.vpc.v1.Gateway\"%\x82\xd3\xe4\x93\x02\x1f\x12\x1d/vpc/v1/gateways/{gateway_id}\x12u\n" +
	"\x04List\x12(.yandex.cloud.vpc.v1.ListGatewaysRequest\x1a).yandex.cloud.vpc.v1.ListGatewaysResponse\"\x18\x82\xd3\xe4\x93\x02\x12\x12\x10/vpc/v1/gateways\x12\x97\x01\n" +
	"\x06Create\x12).yandex.cloud.vpc.v1.CreateGatewayRequest\x1a!.yandex.cloud.operation.Operation\"?\xb2\xd2* \n" +
	"\x15CreateGatewayMetadata\x12\aGateway\x82\xd3\xe4\x93\x02\x15:\x01*\"\x10/vpc/v1/gateways\x12\xa4\x01\n" +
	"\x06Update\x12).yandex.cloud.vpc.v1.UpdateGatewayRequest\x1a!.yandex.cloud.operation.Operation\"L\xb2\xd2* \n" +
	"\x15UpdateGatewayMetadata\x12\aGateway\x82\xd3\xe4\x93\x02\":\x01*2\x1d/vpc/v1/gateways/{gateway_id}\x12\xaf\x01\n" +
	"\x06Delete\x12).yandex.cloud.vpc.v1.DeleteGatewayRequest\x1a!.yandex.cloud.operation.Operation\"W\xb2\xd2*.\n" +
	"\x15DeleteGatewayMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02\x1f*\x1d/vpc/v1/gateways/{gateway_id}\x12\xa9\x01\n" +
	"\x0eListOperations\x121.yandex.cloud.vpc.v1.ListGatewayOperationsRequest\x1a2.yandex.cloud.vpc.v1.ListGatewayOperationsResponse\"0\x82\xd3\xe4\x93\x02*\x12(/vpc/v1/gateways/{gateway_id}/operations\x12\xa3\x01\n" +
	"\x04Move\x12'.yandex.cloud.vpc.v1.MoveGatewayRequest\x1a!.yandex.cloud.operation.Operation\"O\xb2\xd2*\x1e\n" +
	"\x13MoveGatewayMetadata\x12\aGateway\x82\xd3\xe4\x93\x02':\x01*\"\"/vpc/v1/gateways/{gateway_id}:moveBV\n" +
	"\x17yandex.cloud.api.vpc.v1Z;github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1;vpcb\x06proto3"

var (
	file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescData []byte
)

func file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_vpc_v1_gateway_service_proto_rawDesc), len(file_yandex_cloud_vpc_v1_gateway_service_proto_rawDesc)))
	})
	return file_yandex_cloud_vpc_v1_gateway_service_proto_rawDescData
}

var file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_yandex_cloud_vpc_v1_gateway_service_proto_goTypes = []any{
	(*GetGatewayRequest)(nil),             // 0: yandex.cloud.vpc.v1.GetGatewayRequest
	(*ListGatewaysRequest)(nil),           // 1: yandex.cloud.vpc.v1.ListGatewaysRequest
	(*ListGatewaysResponse)(nil),          // 2: yandex.cloud.vpc.v1.ListGatewaysResponse
	(*ListGatewayOperationsRequest)(nil),  // 3: yandex.cloud.vpc.v1.ListGatewayOperationsRequest
	(*ListGatewayOperationsResponse)(nil), // 4: yandex.cloud.vpc.v1.ListGatewayOperationsResponse
	(*SharedEgressGatewaySpec)(nil),       // 5: yandex.cloud.vpc.v1.SharedEgressGatewaySpec
	(*CreateGatewayRequest)(nil),          // 6: yandex.cloud.vpc.v1.CreateGatewayRequest
	(*CreateGatewayMetadata)(nil),         // 7: yandex.cloud.vpc.v1.CreateGatewayMetadata
	(*UpdateGatewayRequest)(nil),          // 8: yandex.cloud.vpc.v1.UpdateGatewayRequest
	(*UpdateGatewayMetadata)(nil),         // 9: yandex.cloud.vpc.v1.UpdateGatewayMetadata
	(*DeleteGatewayRequest)(nil),          // 10: yandex.cloud.vpc.v1.DeleteGatewayRequest
	(*DeleteGatewayMetadata)(nil),         // 11: yandex.cloud.vpc.v1.DeleteGatewayMetadata
	(*MoveGatewayRequest)(nil),            // 12: yandex.cloud.vpc.v1.MoveGatewayRequest
	(*MoveGatewayMetadata)(nil),           // 13: yandex.cloud.vpc.v1.MoveGatewayMetadata
	nil,                                   // 14: yandex.cloud.vpc.v1.CreateGatewayRequest.LabelsEntry
	nil,                                   // 15: yandex.cloud.vpc.v1.UpdateGatewayRequest.LabelsEntry
	(*Gateway)(nil),                       // 16: yandex.cloud.vpc.v1.Gateway
	(*operation.Operation)(nil),           // 17: yandex.cloud.operation.Operation
	(*fieldmaskpb.FieldMask)(nil),         // 18: google.protobuf.FieldMask
}
var file_yandex_cloud_vpc_v1_gateway_service_proto_depIdxs = []int32{
	16, // 0: yandex.cloud.vpc.v1.ListGatewaysResponse.gateways:type_name -> yandex.cloud.vpc.v1.Gateway
	17, // 1: yandex.cloud.vpc.v1.ListGatewayOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	14, // 2: yandex.cloud.vpc.v1.CreateGatewayRequest.labels:type_name -> yandex.cloud.vpc.v1.CreateGatewayRequest.LabelsEntry
	5,  // 3: yandex.cloud.vpc.v1.CreateGatewayRequest.shared_egress_gateway_spec:type_name -> yandex.cloud.vpc.v1.SharedEgressGatewaySpec
	18, // 4: yandex.cloud.vpc.v1.UpdateGatewayRequest.update_mask:type_name -> google.protobuf.FieldMask
	15, // 5: yandex.cloud.vpc.v1.UpdateGatewayRequest.labels:type_name -> yandex.cloud.vpc.v1.UpdateGatewayRequest.LabelsEntry
	5,  // 6: yandex.cloud.vpc.v1.UpdateGatewayRequest.shared_egress_gateway_spec:type_name -> yandex.cloud.vpc.v1.SharedEgressGatewaySpec
	0,  // 7: yandex.cloud.vpc.v1.GatewayService.Get:input_type -> yandex.cloud.vpc.v1.GetGatewayRequest
	1,  // 8: yandex.cloud.vpc.v1.GatewayService.List:input_type -> yandex.cloud.vpc.v1.ListGatewaysRequest
	6,  // 9: yandex.cloud.vpc.v1.GatewayService.Create:input_type -> yandex.cloud.vpc.v1.CreateGatewayRequest
	8,  // 10: yandex.cloud.vpc.v1.GatewayService.Update:input_type -> yandex.cloud.vpc.v1.UpdateGatewayRequest
	10, // 11: yandex.cloud.vpc.v1.GatewayService.Delete:input_type -> yandex.cloud.vpc.v1.DeleteGatewayRequest
	3,  // 12: yandex.cloud.vpc.v1.GatewayService.ListOperations:input_type -> yandex.cloud.vpc.v1.ListGatewayOperationsRequest
	12, // 13: yandex.cloud.vpc.v1.GatewayService.Move:input_type -> yandex.cloud.vpc.v1.MoveGatewayRequest
	16, // 14: yandex.cloud.vpc.v1.GatewayService.Get:output_type -> yandex.cloud.vpc.v1.Gateway
	2,  // 15: yandex.cloud.vpc.v1.GatewayService.List:output_type -> yandex.cloud.vpc.v1.ListGatewaysResponse
	17, // 16: yandex.cloud.vpc.v1.GatewayService.Create:output_type -> yandex.cloud.operation.Operation
	17, // 17: yandex.cloud.vpc.v1.GatewayService.Update:output_type -> yandex.cloud.operation.Operation
	17, // 18: yandex.cloud.vpc.v1.GatewayService.Delete:output_type -> yandex.cloud.operation.Operation
	4,  // 19: yandex.cloud.vpc.v1.GatewayService.ListOperations:output_type -> yandex.cloud.vpc.v1.ListGatewayOperationsResponse
	17, // 20: yandex.cloud.vpc.v1.GatewayService.Move:output_type -> yandex.cloud.operation.Operation
	14, // [14:21] is the sub-list for method output_type
	7,  // [7:14] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_yandex_cloud_vpc_v1_gateway_service_proto_init() }
func file_yandex_cloud_vpc_v1_gateway_service_proto_init() {
	if File_yandex_cloud_vpc_v1_gateway_service_proto != nil {
		return
	}
	file_yandex_cloud_vpc_v1_gateway_proto_init()
	file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[6].OneofWrappers = []any{
		(*CreateGatewayRequest_SharedEgressGatewaySpec)(nil),
	}
	file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes[8].OneofWrappers = []any{
		(*UpdateGatewayRequest_SharedEgressGatewaySpec)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_vpc_v1_gateway_service_proto_rawDesc), len(file_yandex_cloud_vpc_v1_gateway_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_vpc_v1_gateway_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_vpc_v1_gateway_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_vpc_v1_gateway_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_vpc_v1_gateway_service_proto = out.File
	file_yandex_cloud_vpc_v1_gateway_service_proto_goTypes = nil
	file_yandex_cloud_vpc_v1_gateway_service_proto_depIdxs = nil
}
