// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
)

// AllowListItem is the model entity for the AllowListItem schema.
type AllowListItem struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt time.Time `json:"updated_at,omitempty"`
	// ExpiresAt holds the value of the "expires_at" field.
	ExpiresAt time.Time `json:"expires_at,omitempty"`
	// Comment holds the value of the "comment" field.
	Comment string `json:"comment,omitempty"`
	// Value holds the value of the "value" field.
	Value string `json:"value,omitempty"`
	// StartIP holds the value of the "start_ip" field.
	StartIP int64 `json:"start_ip,omitempty"`
	// EndIP holds the value of the "end_ip" field.
	EndIP int64 `json:"end_ip,omitempty"`
	// StartSuffix holds the value of the "start_suffix" field.
	StartSuffix int64 `json:"start_suffix,omitempty"`
	// EndSuffix holds the value of the "end_suffix" field.
	EndSuffix int64 `json:"end_suffix,omitempty"`
	// IPSize holds the value of the "ip_size" field.
	IPSize int64 `json:"ip_size,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the AllowListItemQuery when eager-loading is set.
	Edges        AllowListItemEdges `json:"edges"`
	selectValues sql.SelectValues
}

// AllowListItemEdges holds the relations/edges for other nodes in the graph.
type AllowListItemEdges struct {
	// Allowlist holds the value of the allowlist edge.
	Allowlist []*AllowList `json:"allowlist,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// AllowlistOrErr returns the Allowlist value or an error if the edge
// was not loaded in eager-loading.
func (e AllowListItemEdges) AllowlistOrErr() ([]*AllowList, error) {
	if e.loadedTypes[0] {
		return e.Allowlist, nil
	}
	return nil, &NotLoadedError{edge: "allowlist"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*AllowListItem) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case allowlistitem.FieldID, allowlistitem.FieldStartIP, allowlistitem.FieldEndIP, allowlistitem.FieldStartSuffix, allowlistitem.FieldEndSuffix, allowlistitem.FieldIPSize:
			values[i] = new(sql.NullInt64)
		case allowlistitem.FieldComment, allowlistitem.FieldValue:
			values[i] = new(sql.NullString)
		case allowlistitem.FieldCreatedAt, allowlistitem.FieldUpdatedAt, allowlistitem.FieldExpiresAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the AllowListItem fields.
func (ali *AllowListItem) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case allowlistitem.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			ali.ID = int(value.Int64)
		case allowlistitem.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				ali.CreatedAt = value.Time
			}
		case allowlistitem.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				ali.UpdatedAt = value.Time
			}
		case allowlistitem.FieldExpiresAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field expires_at", values[i])
			} else if value.Valid {
				ali.ExpiresAt = value.Time
			}
		case allowlistitem.FieldComment:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field comment", values[i])
			} else if value.Valid {
				ali.Comment = value.String
			}
		case allowlistitem.FieldValue:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field value", values[i])
			} else if value.Valid {
				ali.Value = value.String
			}
		case allowlistitem.FieldStartIP:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field start_ip", values[i])
			} else if value.Valid {
				ali.StartIP = value.Int64
			}
		case allowlistitem.FieldEndIP:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field end_ip", values[i])
			} else if value.Valid {
				ali.EndIP = value.Int64
			}
		case allowlistitem.FieldStartSuffix:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field start_suffix", values[i])
			} else if value.Valid {
				ali.StartSuffix = value.Int64
			}
		case allowlistitem.FieldEndSuffix:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field end_suffix", values[i])
			} else if value.Valid {
				ali.EndSuffix = value.Int64
			}
		case allowlistitem.FieldIPSize:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for field ip_size", values[i])
			} else if value.Valid {
				ali.IPSize = value.Int64
			}
		default:
			ali.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// GetValue returns the ent.Value that was dynamically selected and assigned to the AllowListItem.
// This includes values selected through modifiers, order, etc.
func (ali *AllowListItem) GetValue(name string) (ent.Value, error) {
	return ali.selectValues.Get(name)
}

// QueryAllowlist queries the "allowlist" edge of the AllowListItem entity.
func (ali *AllowListItem) QueryAllowlist() *AllowListQuery {
	return NewAllowListItemClient(ali.config).QueryAllowlist(ali)
}

// Update returns a builder for updating this AllowListItem.
// Note that you need to call AllowListItem.Unwrap() before calling this method if this AllowListItem
// was returned from a transaction, and the transaction was committed or rolled back.
func (ali *AllowListItem) Update() *AllowListItemUpdateOne {
	return NewAllowListItemClient(ali.config).UpdateOne(ali)
}

// Unwrap unwraps the AllowListItem entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (ali *AllowListItem) Unwrap() *AllowListItem {
	_tx, ok := ali.config.driver.(*txDriver)
	if !ok {
		panic("ent: AllowListItem is not a transactional entity")
	}
	ali.config.driver = _tx.drv
	return ali
}

// String implements the fmt.Stringer.
func (ali *AllowListItem) String() string {
	var builder strings.Builder
	builder.WriteString("AllowListItem(")
	builder.WriteString(fmt.Sprintf("id=%v, ", ali.ID))
	builder.WriteString("created_at=")
	builder.WriteString(ali.CreatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("updated_at=")
	builder.WriteString(ali.UpdatedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("expires_at=")
	builder.WriteString(ali.ExpiresAt.Format(time.ANSIC))
	builder.WriteString(", ")
	builder.WriteString("comment=")
	builder.WriteString(ali.Comment)
	builder.WriteString(", ")
	builder.WriteString("value=")
	builder.WriteString(ali.Value)
	builder.WriteString(", ")
	builder.WriteString("start_ip=")
	builder.WriteString(fmt.Sprintf("%v", ali.StartIP))
	builder.WriteString(", ")
	builder.WriteString("end_ip=")
	builder.WriteString(fmt.Sprintf("%v", ali.EndIP))
	builder.WriteString(", ")
	builder.WriteString("start_suffix=")
	builder.WriteString(fmt.Sprintf("%v", ali.StartSuffix))
	builder.WriteString(", ")
	builder.WriteString("end_suffix=")
	builder.WriteString(fmt.Sprintf("%v", ali.EndSuffix))
	builder.WriteString(", ")
	builder.WriteString("ip_size=")
	builder.WriteString(fmt.Sprintf("%v", ali.IPSize))
	builder.WriteByte(')')
	return builder.String()
}

// AllowListItems is a parsable slice of AllowListItem.
type AllowListItems []*AllowListItem
