---
title: glab milestone create
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

Create a group or project milestone.

```plaintext
glab milestone create [flags]
```

## Examples

```console
 # Create milestone for the current project
$ glab milestone create --title='Example title' --due-date='2025-12-16'

# Create milestone for the specified project
$ glab milestone create --title='Example group milestone' --due-date='2025-12-16' --project 123

# Create milestone for the specified group
$ glab milestone create --title='Example group milestone' --due-date='2025-12-16' --group 456

```

## Options

```plaintext
      --description string   Description of the milestone.
      --due-date string      Due date for the milestone. Expected in ISO 8601 format (2025-04-15T08:00:00Z).
      --group string         The ID or URL-encoded path of the group.
      --project string       The ID or URL-encoded path of the project.
      --start-date string    Start date for the milestone. Expected in ISO 8601 format (2025-04-15T08:00:00Z).
      --title string         Title of the milestone.
```

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
