
package appcompatcache

// Autogenerated code from profile_vtypes.json. Do not edit.

import (
    "encoding/binary"
    "fmt"
    "bytes"
    "io"
    "unicode/utf16"
    "unicode/utf8"
)

var (
   // Depending on autogenerated code we may use this. Add a reference
   // to shut the compiler up.
   _ = bytes.MinRead
   _ = fmt.Sprintf
   _ = utf16.Decode
   _ = binary.LittleEndian
   _ = utf8.RuneError
)

type AppCompatibilityProfile struct {
    Off_Win10CreatorsEntry_DataSize int64
    Off_Win10CreatorsEntry_PathSize int64
    Off_Win10CreatorsEntry_Path__ int64
    Off_Win10CreatorsEntry_Signature int64
    Off_Win10CreatorsEntry__XXXX int64
    Off_Win10CreatorsHeader_HeaderSize int64
    Off_Win10CreatorsHeader_NumberOfEntries int64
}

func NewAppCompatibilityProfile() *AppCompatibilityProfile {
    // Specific offsets can be tweaked to cater for slight version mismatches.
    self := &AppCompatibilityProfile{8,12,14,0,0,0,40}
    return self
}

func (self *AppCompatibilityProfile) Win10CreatorsEntry(reader io.ReaderAt, offset int64) *Win10CreatorsEntry {
    return &Win10CreatorsEntry{Reader: reader, Offset: offset, Profile: self}
}

func (self *AppCompatibilityProfile) Win10CreatorsHeader(reader io.ReaderAt, offset int64) *Win10CreatorsHeader {
    return &Win10CreatorsHeader{Reader: reader, Offset: offset, Profile: self}
}


type Win10CreatorsEntry struct {
    Reader io.ReaderAt
    Offset int64
    Profile *AppCompatibilityProfile
}

func NewWin10CreatorsEntry(reader io.ReaderAt) *Win10CreatorsEntry {
    self := &Win10CreatorsEntry{Reader: reader}
    return self
}

func (self *Win10CreatorsEntry) Size() int {
    return 0
}

func (self *Win10CreatorsEntry) DataSize() uint32 {
   return ParseUint32(self.Reader, self.Profile.Off_Win10CreatorsEntry_DataSize + self.Offset)
}

func (self *Win10CreatorsEntry) PathSize() uint16 {
   return ParseUint16(self.Reader, self.Profile.Off_Win10CreatorsEntry_PathSize + self.Offset)
}


func (self *Win10CreatorsEntry) Path__() string {
  return ParseTerminatedUTF16String(self.Reader, self.Profile.Off_Win10CreatorsEntry_Path__ + self.Offset)
}

func (self *Win10CreatorsEntry) Signature() uint32 {
   return ParseUint32(self.Reader, self.Profile.Off_Win10CreatorsEntry_Signature + self.Offset)
}

func (self *Win10CreatorsEntry) _XXXX() uint64 {
    return ParseUint64(self.Reader, self.Profile.Off_Win10CreatorsEntry__XXXX + self.Offset)
}
func (self *Win10CreatorsEntry) DebugString() string {
    result := fmt.Sprintf("struct Win10CreatorsEntry @ %#x:\n", self.Offset)
    result += fmt.Sprintf("DataSize: %#0x\n", self.DataSize())
    result += fmt.Sprintf("PathSize: %#0x\n", self.PathSize())
    result += fmt.Sprintf("Path__: %v\n", string(self.Path__()))
    result += fmt.Sprintf("Signature: %#0x\n", self.Signature())
    result += fmt.Sprintf("_XXXX: %#0x\n", self._XXXX())
    return result
}

type Win10CreatorsHeader struct {
    Reader io.ReaderAt
    Offset int64
    Profile *AppCompatibilityProfile
}

func NewWin10CreatorsHeader(reader io.ReaderAt) *Win10CreatorsHeader {
    self := &Win10CreatorsHeader{Reader: reader}
    return self
}

func (self *Win10CreatorsHeader) Size() int {
    return 53
}

func (self *Win10CreatorsHeader) HeaderSize() uint32 {
   return ParseUint32(self.Reader, self.Profile.Off_Win10CreatorsHeader_HeaderSize + self.Offset)
}

func (self *Win10CreatorsHeader) NumberOfEntries() uint32 {
   return ParseUint32(self.Reader, self.Profile.Off_Win10CreatorsHeader_NumberOfEntries + self.Offset)
}
func (self *Win10CreatorsHeader) DebugString() string {
    result := fmt.Sprintf("struct Win10CreatorsHeader @ %#x:\n", self.Offset)
    result += fmt.Sprintf("HeaderSize: %#0x\n", self.HeaderSize())
    result += fmt.Sprintf("NumberOfEntries: %#0x\n", self.NumberOfEntries())
    return result
}

func ParseUint16(reader io.ReaderAt, offset int64) uint16 {
    data := make([]byte, 2)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return binary.LittleEndian.Uint16(data)
}

func ParseUint32(reader io.ReaderAt, offset int64) uint32 {
    data := make([]byte, 4)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return binary.LittleEndian.Uint32(data)
}

func ParseUint64(reader io.ReaderAt, offset int64) uint64 {
    data := make([]byte, 8)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return binary.LittleEndian.Uint64(data)
}

func ParseTerminatedUTF16String(reader io.ReaderAt, offset int64) string {
   data := make([]byte, 1024)
   n, err := reader.ReadAt(data, offset)
   if err != nil && err != io.EOF {
     return ""
   }

   idx := bytes.Index(data[:n], []byte{0, 0})
   if idx < 0 {
      idx = n-1
   }
   return UTF16BytesToUTF8(data[0:idx+1], binary.LittleEndian)
}

func ParseUTF16String(reader io.ReaderAt, offset int64, length int64) string {
   data := make([]byte, length)
   n, err := reader.ReadAt(data, offset)
   if err != nil && err != io.EOF {
     return ""
   }
   return UTF16BytesToUTF8(data[:n], binary.LittleEndian)
}

func UTF16BytesToUTF8(b []byte, o binary.ByteOrder) string {
	if len(b) < 2 {
		return ""
	}

	if b[0] == 0xff && b[1] == 0xfe {
		o = binary.BigEndian
		b = b[2:]
	} else if b[0] == 0xfe && b[1] == 0xff {
		o = binary.LittleEndian
		b = b[2:]
	}

	utf := make([]uint16, (len(b)+(2-1))/2)

	for i := 0; i+(2-1) < len(b); i += 2 {
		utf[i/2] = o.Uint16(b[i:])
	}
	if len(b)/2 < len(utf) {
		utf[len(utf)-1] = utf8.RuneError
	}

	return string(utf16.Decode(utf))
}


