<p align="center">
  <img alt="GoReleaser Logo" src="https://avatars2.githubusercontent.com/u/24697112?v=3&s=200" height="200" />
  <h3 align="center">GoReleaser</h3>
  <p align="center">Release engineering, simplified.</p>
  <p align="center">
    <img alt="Go" src="./www/docs/static/go-light.svg#gh-light-mode-only" height="30" width="30" />
    <img alt="Go" src="./www/docs/static/go-dark.svg#gh-dark-mode-only" height="30" width="30" />
    <img alt="Rust" src="./www/docs/static/rust-light.svg#gh-light-mode-only" height="30" width="30" />
    <img alt="Rust" src="./www/docs/static/rust-dark.svg#gh-dark-mode-only" height="30" width="30" />
    <img alt="Zig" src="./www/docs/static/zig-light.svg#gh-light-mode-only" height="30" width="30" />
    <img alt="Zig" src="./www/docs/static/zig-dark.svg#gh-dark-mode-only" height="30" width="30" />
    <img alt="Bun" src="./www/docs/static/bun-light.svg#gh-light-mode-only" height="30" width="30" />
    <img alt="Bun" src="./www/docs/static/bun-dark.svg#gh-dark-mode-only" height="30" width="30" />
    <img alt="Deno" src="./www/docs/static/deno-light.svg#gh-light-mode-only" height="30" width="30" />
    <img alt="Deno" src="./www/docs/static/deno-dark.svg#gh-dark-mode-only" height="30" width="30" />
    <img alt="Python" src="./www/docs/static/python-light.svg#gh-light-mode-only" height="30" width="30" />
    <img alt="Python" src="./www/docs/static/python-dark.svg#gh-dark-mode-only" height="30" width="30" />
  </p>
</p>

---

We handle the complexities of releasing so you can focus in building what really
matters: **your software**.

![](https://goreleaser.com/static/goreleaser.png)

---

## Get GoReleaser

- [On your machine](https://goreleaser.com/install/);
- [On CI/CD systems](https://goreleaser.com/ci/).

## Documentation

Documentation is hosted live at https://goreleaser.com

## Community

You have questions, need support and or just want to talk about GoReleaser?

Here are ways to get in touch with the GoReleaser community:

[![Join Discord](https://img.shields.io/badge/Join_our_Discord_server-5865F2?style=for-the-badge&logo=discord&logoColor=white)](https://discord.gg/RGEBtg8vQ6)
[![Follow Twitter](https://img.shields.io/badge/follow_on_twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)](https://twitter.com/goreleaser)
[![GitHub Discussions](https://img.shields.io/badge/GITHUB_DISCUSSION-181717?style=for-the-badge&logo=github&logoColor=white)](https://github.com/goreleaser/goreleaser/discussions)

You can find the links above and all others [here](https://goreleaser.com/links/).

### Code of Conduct

This project adheres to the Contributor Covenant [code of conduct](https://github.com/goreleaser/.github/blob/main/CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code.
We appreciate your contribution.
Please refer to our [contributing guidelines](CONTRIBUTING.md) for further information.

## Badges

[![Release](https://img.shields.io/github/release/goreleaser/goreleaser.svg?style=for-the-badge)](https://github.com/goreleaser/goreleaser/releases/latest)
[![Software License](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=for-the-badge)](/LICENSE.md)
[![Build status](https://img.shields.io/github/actions/workflow/status/goreleaser/goreleaser/build.yml?style=for-the-badge&branch=main)](https://github.com/goreleaser/goreleaser/actions?workflow=build)
[![Codecov branch](https://img.shields.io/codecov/c/github/goreleaser/goreleaser/main.svg?style=for-the-badge)](https://codecov.io/gh/goreleaser/goreleaser)
[![Artifact Hub](https://img.shields.io/endpoint?url=https://artifacthub.io/badge/repository/goreleaser&style=for-the-badge)](https://artifacthub.io/packages/search?repo=goreleaser)
[![Go Doc](https://img.shields.io/badge/godoc-reference-blue.svg?style=for-the-badge)](http://godoc.org/github.com/goreleaser/goreleaser)
[![Powered By: GoReleaser](https://img.shields.io/badge/powered%20by-goreleaser-green.svg?style=for-the-badge)](https://github.com/goreleaser)
[![Backers on Open Collective](https://opencollective.com/goreleaser/backers/badge.svg?style=for-the-badge)](https://opencollective.com/goreleaser/backers/)
[![Sponsors on Open Collective](https://opencollective.com/goreleaser/sponsors/badge.svg?style=for-the-badge)](https://opencollective.com/goreleaser/sponsors/)
[![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg?style=for-the-badge)](https://conventionalcommits.org)
[![CII Best Practices](https://img.shields.io/cii/summary/5420?label=openssf%20best%20practices&style=for-the-badge)](https://bestpractices.coreinfrastructure.org/projects/5420)
[![GoReportCard](https://goreportcard.com/badge/github.com/goreleaser/goreleaser?style=for-the-badge)](https://goreportcard.com/report/github.com/goreleaser/goreleaser)

## Sponsors

Does you or your company use GoReleaser?

You can help keep the project bug-free and feature rich by sponsoring the
project and its maintainers.

You can sponsor GoReleaser via:

- **[GitHub Sponsors](https://github.com/sponsors/caarlos0)**
- **[OpenCollective](https://opencollective.com/goreleaser)**

A big **thank you** to all current, past, and future sponsors!

<!-- sponsors:begin -->
<!-- This list is auto-generated by scripts/update-sponsors.py -->

### Gold Sponsors

<div align="center">

  <a href="https://github.com/mercedes-benz" target="_blank" rel="noopener sponsored"><img src="https://avatars.githubusercontent.com/u/34240465?v=4" alt="Mercedes-Benz Group" width="96" height="96" style="border-radius: 8px; margin: 8px;"></a>
  <a href="https://github.com/nitrictech" target="_blank" rel="noopener sponsored"><img src="https://avatars.githubusercontent.com/u/72055470?v=4" alt="nitric" width="96" height="96" style="border-radius: 8px; margin: 8px;"></a>

</div>

### Silver Sponsors

<div align="center">

  <a href="https://github.com/DataDog" target="_blank" rel="noopener sponsored"><img src="https://avatars.githubusercontent.com/u/365230?v=4" alt="Datadog, Inc." width="80" height="80" style="border-radius: 8px; margin: 8px;"></a>

</div>

### Bronze Sponsors

<div align="center">

  <a href="https://github.com/leaanthony" target="_blank" rel="noopener sponsored"><img src="https://avatars.githubusercontent.com/u/1943904?v=4" alt="Lea Anthony" width="64" height="64" style="border-radius: 8px; margin: 8px;"></a>
  <a href="https://github.com/conetcloud" target="_blank" rel="noopener sponsored"><img src="https://avatars.githubusercontent.com/u/35725664?v=4" alt="conet cloud" width="64" height="64" style="border-radius: 8px; margin: 8px;"></a>
  <a href="https://github.com/encoredev" target="_blank" rel="noopener sponsored"><img src="https://avatars.githubusercontent.com/u/50438175?v=4" alt="Encore" width="64" height="64" style="border-radius: 8px; margin: 8px;"></a>
  <a href="https://www.numary.com" target="_blank" rel="noopener sponsored"><img src="https://images.opencollective.com/numary/c4ef831/logo/96.png" alt="Numary" width="64" height="64" style="border-radius: 8px; margin: 8px;"></a>
  <a href="https://about.gitea.com/" target="_blank" rel="noopener sponsored"><img src="https://images.opencollective.com/gitea/bf35c2f/logo/96.png" alt="Gitea" width="64" height="64" style="border-radius: 8px; margin: 8px;"></a>

</div>

### Backers

- [Marcel Eichner](https://github.com/Ephigenia)
- [Chatpong Voranartaksorn](https://github.com/psychvc)
- [Bruno Paz](https://brunopaz.dev/)
- [Guest](https://opencollective.com/guest-341ba997)
- [Automatio AI](https://automatio.ai/)
- [Bileta Avioni](https://biletaavioni.al/)
- [Jared Allard](https://github.com/jaredallard)
- [joe miller](https://github.com/joemiller)
- [Ryan Nixon](https://github.com/taiidani)
- [Lawrence Gripper](https://github.com/lawrencegripper)
- [Francis Lavoie](https://github.com/francislavoie)
- [Nicolas Gotchac](https://github.com/ngotchac)
- [Ben](https://github.com/iwpnd)
- [KEINOS](https://github.com/KEINOS)
- [Eden Zimbelman](https://github.com/zimeg)
- [Ben Lechlitner](https://github.com/asphaltbuffet)
- [Santosh Yadav](https://github.com/santoshyadavdev)
- [Alexey Palazhchenko](https://github.com/AlekSi)
- [David Birks](https://github.com/dbirks)
- [Alex Viscreanu](https://github.com/aexvir)
- [Ethan Li](https://github.com/ethanjli)
- [Benjamin Kane](https://github.com/bbkane)
- [Carl Tsai](https://github.com/moonape1226)
- [David Dymko](https://github.com/ddymko)
- [Jan De Dobbeleer](https://github.com/JanDeDobbeleer)
- [Paul Greenberg](https://github.com/greenpau)
- [Baptiste Canton](https://github.com/batmac)
- [Andrew](https://github.com/wobondar)
- [Sidartha Karna](https://github.com/sidarthakarna)
- [Kazuma Watanabe](https://github.com/wata727)
- [Joseph Sirianni](https://github.com/jsirianni)
- [Oleg Balunenko](https://github.com/obalunenko)
- [^.{5}\s.{2}ram.{3}$](https://github.com/umatare5)
- [Ethan Troy](https://github.com/ethanolivertroy)

<!-- sponsors:end -->

### Contributors

This project exists thanks to all the people who contribute.
[Contribution guide](CONTRIBUTING.md).

## Stars

[![Stargazers over time](https://starchart.cc/goreleaser/goreleaser.svg?variant=adaptive)](https://starchart.cc/goreleaser/goreleaser)
