/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.internal.UserAgentUtils;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.Topic;

public class ListTopicsPublisher
implements SdkPublisher<ListTopicsResponse> {
    private final SnsAsyncClient client;
    private final ListTopicsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTopicsPublisher(SnsAsyncClient client, ListTopicsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTopicsPublisher(SnsAsyncClient client, ListTopicsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTopicsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTopicsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Topic> topics() {
        return this.flatMapIterable(response -> response.topics());
    }

    private class ListTopicsResponseFetcher
    implements AsyncPageFetcher<ListTopicsResponse> {
        private ListTopicsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTopicsResponse> nextPage(ListTopicsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsPublisher.this.client.listTopics(ListTopicsPublisher.this.firstRequest);
            }
            return ListTopicsPublisher.this.client.listTopics((ListTopicsRequest)((Object)ListTopicsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

