/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.id;

import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class Issuer
extends Identifier {
    private static final long serialVersionUID = -8033463330193076151L;

    public static boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            return Issuer.isValid(new URI(value));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValid(Issuer value) {
        if (value == null) {
            return false;
        }
        try {
            return Issuer.isValid(new URI(value.getValue()));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValid(URI value) {
        if (value == null) {
            return false;
        }
        if (value.getScheme() == null || !value.getScheme().equalsIgnoreCase("https")) {
            return false;
        }
        if (value.getRawQuery() != null) {
            return false;
        }
        return value.getRawFragment() == null;
    }

    public Issuer(String value) {
        super(value);
    }

    public Issuer(URI value) {
        super(value.toString());
    }

    public Issuer(Identifier value) {
        super(value.getValue());
    }

    public boolean isValid() {
        return Issuer.isValid(this);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Issuer other = (Issuer)object;
        return Objects.equals(this.getValue(), other.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    static String stripTrailingSlashes(String s) {
        int end;
        for (end = s.length(); end > 0 && s.charAt(end - 1) == '/'; --end) {
        }
        return end == s.length() ? s : s.substring(0, end);
    }

    public boolean equalsIgnoreTrailingSlash(Issuer other) {
        if (other == null) {
            return false;
        }
        if (!this.isValid() || !other.isValid()) {
            return this.equals(other);
        }
        try {
            URI thisURI = URI.create(Issuer.stripTrailingSlashes(this.toString()));
            URI otherURI = URI.create(Issuer.stripTrailingSlashes(other.toString()));
            return thisURI.equals(otherURI);
        }
        catch (IllegalArgumentException e) {
            return this.equals(other);
        }
    }

    public static Issuer parse(String s) {
        if (StringUtils.isBlank(s)) {
            return null;
        }
        return new Issuer(s);
    }
}

