/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.AcknowledgementCommitCallback;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.utils.LogContext;

public class MockShareConsumer<K, V>
implements ShareConsumer<K, V> {
    private final SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
    private final AtomicBoolean wakeup;
    private final Map<TopicPartition, List<ConsumerRecord<K, V>>> records = new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>();
    private boolean closed = false;
    private Uuid clientInstanceId;

    public MockShareConsumer() {
        this.wakeup = new AtomicBoolean(false);
    }

    @Override
    public synchronized Set<String> subscription() {
        this.ensureNotClosed();
        return this.subscriptions.subscription();
    }

    @Override
    public synchronized void subscribe(Collection<String> topics) {
        this.ensureNotClosed();
        this.subscriptions.subscribe(new HashSet<String>(topics), Optional.empty());
    }

    @Override
    public synchronized void unsubscribe() {
        this.ensureNotClosed();
        this.subscriptions.unsubscribe();
    }

    @Override
    public synchronized ConsumerRecords<K, V> poll(Duration timeout) {
        this.ensureNotClosed();
        HashMap<TopicPartition, List<ConsumerRecord<TopicPartition, List>>> results = new HashMap<TopicPartition, List<ConsumerRecord<TopicPartition, List>>>();
        for (Map.Entry<TopicPartition, List<ConsumerRecord<K, V>>> entry : this.records.entrySet()) {
            List<ConsumerRecord<K, V>> recs = entry.getValue();
            for (ConsumerRecord<K, V> rec : recs) {
                results.computeIfAbsent(entry.getKey(), partition -> new ArrayList()).add(rec);
            }
        }
        this.records.clear();
        return new ConsumerRecords(results, Map.of());
    }

    @Override
    public synchronized void acknowledge(ConsumerRecord<K, V> record) {
    }

    @Override
    public synchronized void acknowledge(ConsumerRecord<K, V> record, AcknowledgeType type) {
    }

    @Override
    public synchronized void acknowledge(String topic, int partition, long offset, AcknowledgeType type) {
    }

    @Override
    public synchronized Map<TopicIdPartition, Optional<KafkaException>> commitSync() {
        return new HashMap<TopicIdPartition, Optional<KafkaException>>();
    }

    @Override
    public synchronized Map<TopicIdPartition, Optional<KafkaException>> commitSync(Duration timeout) {
        return new HashMap<TopicIdPartition, Optional<KafkaException>>();
    }

    @Override
    public synchronized void commitAsync() {
    }

    @Override
    public void setAcknowledgementCommitCallback(AcknowledgementCommitCallback callback) {
    }

    public synchronized void setClientInstanceId(Uuid clientInstanceId) {
        this.clientInstanceId = clientInstanceId;
    }

    @Override
    public synchronized Uuid clientInstanceId(Duration timeout) {
        if (this.clientInstanceId == null) {
            throw new UnsupportedOperationException("clientInstanceId not set");
        }
        return this.clientInstanceId;
    }

    @Override
    public synchronized Map<MetricName, ? extends Metric> metrics() {
        this.ensureNotClosed();
        return Collections.emptyMap();
    }

    @Override
    public Optional<Integer> acquisitionLockTimeoutMs() {
        return Optional.empty();
    }

    @Override
    public void registerMetricForSubscription(KafkaMetric metric) {
    }

    @Override
    public void unregisterMetricFromSubscription(KafkaMetric metric) {
    }

    @Override
    public synchronized void close() {
        this.close(Duration.ofMillis(30000L));
    }

    @Override
    public synchronized void close(Duration timeout) {
        this.closed = true;
    }

    @Override
    public synchronized void wakeup() {
        this.wakeup.set(true);
    }

    public synchronized void addRecord(ConsumerRecord<K, V> record) {
        this.ensureNotClosed();
        TopicPartition tp = new TopicPartition(record.topic(), record.partition());
        if (!this.subscriptions.subscription().contains(record.topic())) {
            throw new IllegalStateException("Cannot add records for a topics that is not subscribed by the consumer");
        }
        List recs = this.records.computeIfAbsent(tp, k -> new ArrayList());
        recs.add(record);
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }
}

