/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.firebase.FirebaseApp;
import com.google.firebase.ThreadManager;
import com.google.firebase.internal.FirebaseScheduledExecutor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebaseThreadManagers {
    private static final Logger logger = LoggerFactory.getLogger(FirebaseThreadManagers.class);
    public static final ThreadManager DEFAULT_THREAD_MANAGER = new DefaultThreadManager();

    private static class DefaultThreadManager
    extends GlobalThreadManager {
        private DefaultThreadManager() {
        }

        @Override
        protected ExecutorService doInit() {
            ThreadFactory threadFactory = FirebaseScheduledExecutor.getThreadFactoryWithName(this.getThreadFactory(), "firebase-default-%d");
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(100, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            return threadPoolExecutor;
        }

        @Override
        protected void doCleanup(ExecutorService executorService) {
            logger.debug("Shutting down default executor");
            executorService.shutdownNow();
        }

        @Override
        protected ThreadFactory getThreadFactory() {
            return Executors.defaultThreadFactory();
        }
    }

    static abstract class GlobalThreadManager
    extends ThreadManager {
        private final Object lock = new Object();
        private final Set<String> apps = new HashSet<String>();
        private ExecutorService executorService;

        GlobalThreadManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ExecutorService getExecutor(FirebaseApp app) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = this.doInit();
                }
                this.apps.add(app.getName());
                return this.executorService;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void releaseExecutor(FirebaseApp app, ExecutorService executor) {
            Object object = this.lock;
            synchronized (object) {
                if (this.apps.remove(app.getName()) && this.apps.isEmpty()) {
                    this.doCleanup(this.executorService);
                    this.executorService = null;
                }
            }
        }

        protected abstract ExecutorService doInit();

        protected abstract void doCleanup(ExecutorService var1);
    }
}

