/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.model.mxGraphModel;
import com.mxgraph.view.mxGraph;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;

public class mxGdCodec {
    protected static HashMap<String, Object> cellsMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode(String input, mxGraph graph) {
        BufferedReader br = new BufferedReader(new StringReader(input));
        mxGDParseState state = mxGDParseState.START;
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        try {
            String line = br.readLine().trim();
            while (line != null) {
                switch (state) {
                    case START: {
                        if (line.startsWith("#")) break;
                        state = mxGDParseState.NUM_NODES;
                    }
                    case NUM_NODES: {
                        if (!line.startsWith("#")) {
                            int numVertices = Integer.valueOf(line);
                            for (int i = 0; i < numVertices; ++i) {
                                String label = String.valueOf(i);
                                Object vertex = graph.insertVertex(parent, label, label, 0.0, 0.0, 10.0, 10.0);
                                cellsMap.put(label, vertex);
                            }
                            break;
                        }
                        state = mxGDParseState.PARSING_EDGES;
                        break;
                    }
                    case PARSING_NODES: {
                        if (line.startsWith("# Edges")) {
                            state = mxGDParseState.PARSING_EDGES;
                            break;
                        }
                        if (line.equals("")) break;
                        String[] items = line.split(",");
                        if (items.length != 5) {
                            throw new Exception("Error in parsing");
                        }
                        double x = Double.valueOf(items[1]);
                        double y = Double.valueOf(items[2]);
                        double width = Double.valueOf(items[3]);
                        double height = Double.valueOf(items[4]);
                        String label = items[0];
                        Object vertex = graph.insertVertex(parent, label, label, x - width / 2.0, y - height / 2.0, width, height);
                        cellsMap.put(label, vertex);
                        break;
                    }
                    case PARSING_EDGES: {
                        if (line.equals("")) break;
                        String[] items = line.split(" ");
                        if (items.length != 2) {
                            throw new Exception("Error in parsing");
                        }
                        Object source = cellsMap.get(items[0]);
                        Object target = cellsMap.get(items[1]);
                        graph.insertEdge(parent, null, "", source, target);
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            graph.getModel().endUpdate();
        }
    }

    public static String encode(mxGraph graph) {
        StringBuilder builder = new StringBuilder();
        Object parent = graph.getDefaultParent();
        Object[] vertices = mxGraphModel.getChildCells(graph.getModel(), parent, true, false);
        builder.append("# Number of Nodes (0-" + String.valueOf(vertices.length - 1) + ")");
        builder.append(String.valueOf(vertices.length));
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum mxGDParseState {
        START,
        NUM_NODES,
        PARSING_NODES,
        PARSING_EDGES;

    }
}

