/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.IntrusiveEdge;
import org.jgrapht.graph.specifics.FastLookupDirectedSpecifics;
import org.jgrapht.graph.specifics.FastLookupUndirectedSpecifics;
import org.jgrapht.graph.specifics.Specifics;
import org.jgrapht.util.TypeUtil;

public abstract class AbstractBaseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1263088497616142427L;
    private static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    private static final String GRAPH_SPECIFICS_MUST_NOT_BE_NULL = "Graph specifics must not be null";
    private boolean allowingLoops;
    private EdgeFactory<V, E> edgeFactory;
    private Map<E, IntrusiveEdge> edgeMap;
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private Specifics<V, E> specifics;
    private boolean allowingMultipleEdges;

    protected AbstractBaseGraph(EdgeFactory<V, E> ef, boolean allowMultipleEdges, boolean allowLoops) {
        Objects.requireNonNull(ef);
        this.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
        this.edgeFactory = ef;
        this.allowingLoops = allowLoops;
        this.allowingMultipleEdges = allowMultipleEdges;
        this.specifics = Objects.requireNonNull(this.createSpecifics(), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        return this.specifics.getAllEdges(sourceVertex, targetVertex);
    }

    public boolean isAllowingLoops() {
        return this.allowingLoops;
    }

    public boolean isAllowingMultipleEdges() {
        return this.allowingMultipleEdges;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        return this.specifics.getEdge(sourceVertex, targetVertex);
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.edgeFactory;
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.allowingMultipleEdges && this.containsEdge(sourceVertex, targetVertex)) {
            return null;
        }
        if (!this.allowingLoops && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        E e = this.edgeFactory.createEdge(sourceVertex, targetVertex);
        if (this.containsEdge(e)) {
            return null;
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e, sourceVertex, targetVertex);
        this.edgeMap.put(e, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e);
        return e;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e)) {
            return false;
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.allowingMultipleEdges && this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!this.allowingLoops && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e, sourceVertex, targetVertex);
        this.edgeMap.put(e, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e);
        return true;
    }

    private IntrusiveEdge createIntrusiveEdge(E e, V sourceVertex, V targetVertex) {
        IntrusiveEdge intrusiveEdge = e instanceof IntrusiveEdge ? (IntrusiveEdge)e : new IntrusiveEdge();
        intrusiveEdge.source = sourceVertex;
        intrusiveEdge.target = targetVertex;
        return intrusiveEdge;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.specifics.addVertex(v);
        return true;
    }

    @Override
    public V getEdgeSource(E e) {
        return (V)TypeUtil.uncheckedCast(this.getIntrusiveEdge(e).source, null);
    }

    @Override
    public V getEdgeTarget(E e) {
        return (V)TypeUtil.uncheckedCast(this.getIntrusiveEdge(e).target, null);
    }

    private IntrusiveEdge getIntrusiveEdge(E e) {
        if (e instanceof IntrusiveEdge) {
            return (IntrusiveEdge)e;
        }
        return this.edgeMap.get(e);
    }

    public Object clone() {
        try {
            AbstractBaseGraph newGraph = (AbstractBaseGraph)TypeUtil.uncheckedCast(super.clone(), null);
            newGraph.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
            newGraph.edgeFactory = this.edgeFactory;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.unmodifiableVertexSet = null;
            newGraph.specifics = newGraph.createSpecifics();
            Graphs.addGraph(newGraph, this);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public boolean containsEdge(E e) {
        return this.edgeMap.containsKey(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.specifics.getVertexSet().contains(v);
    }

    public int degreeOf(V vertex) {
        return this.specifics.degreeOf(vertex);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeMap.keySet());
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.edgesOf(vertex);
    }

    public int inDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.inDegreeOf(vertex);
    }

    public Set<E> incomingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.incomingEdgesOf(vertex);
    }

    public int outDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.outDegreeOf(vertex);
    }

    public Set<E> outgoingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.outgoingEdgesOf(vertex);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        E e = this.getEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.edgeMap.remove(e);
        }
        return e;
    }

    @Override
    public boolean removeEdge(E e) {
        if (this.containsEdge(e)) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.edgeMap.remove(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set<E> touchingEdgesList = this.edgesOf(v);
            this.removeAllEdges(new ArrayList<E>(touchingEdgesList));
            this.specifics.getVertexSet().remove(v);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.specifics.getVertexSet());
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public double getEdgeWeight(E e) {
        if (e instanceof DefaultWeightedEdge) {
            return ((DefaultWeightedEdge)e).getWeight();
        }
        if (e == null) {
            throw new NullPointerException();
        }
        return 1.0;
    }

    public void setEdgeWeight(E e, double weight) {
        assert (e instanceof DefaultWeightedEdge) : e.getClass();
        ((DefaultWeightedEdge)e).weight = weight;
    }

    protected Specifics<V, E> createSpecifics() {
        if (this instanceof DirectedGraph) {
            return this.createDirectedSpecifics();
        }
        if (this instanceof UndirectedGraph) {
            return this.createUndirectedSpecifics();
        }
        throw new IllegalArgumentException("must be instance of either DirectedGraph or UndirectedGraph");
    }

    @Deprecated
    protected Specifics<V, E> createUndirectedSpecifics() {
        return new FastLookupUndirectedSpecifics(this);
    }

    @Deprecated
    protected Specifics<V, E> createDirectedSpecifics() {
        return new FastLookupDirectedSpecifics(this);
    }
}

