/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractNumericGene;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.random;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.LongRange;
import io.jenetics.util.MSeq;
import io.jenetics.util.Mean;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.util.Random;

public final class LongGene
extends AbstractNumericGene<Long, LongGene>
implements NumericGene<Long, LongGene>,
Mean<LongGene>,
Comparable<LongGene>,
Serializable {
    private static final long serialVersionUID = 1L;

    LongGene(Long value, Long min, Long max) {
        super(value, min, max);
    }

    @Override
    public int compareTo(LongGene other) {
        return ((Long)this._value).compareTo((Long)other._value);
    }

    public static LongGene of(long value, long min, long max) {
        return new LongGene(value, min, max);
    }

    public static LongGene of(long value, LongRange range) {
        return new LongGene(value, range.getMin(), range.getMax());
    }

    public static LongGene of(long min, long max) {
        return LongGene.of(LongGene.nextLong(RandomRegistry.getRandom(), min, max), min, max);
    }

    public static LongGene of(LongRange range) {
        return LongGene.of(LongGene.nextLong(RandomRegistry.getRandom(), range.getMin(), range.getMax()), range);
    }

    static ISeq<LongGene> seq(Long minimum, Long maximum, IntRange lengthRange) {
        long min = minimum;
        long max = maximum;
        Random r = RandomRegistry.getRandom();
        return MSeq.ofLength(random.nextInt(lengthRange, r)).fill(() -> new LongGene(LongGene.nextLong(r, min, max), minimum, maximum)).toISeq();
    }

    @Override
    public LongGene newInstance(Number number) {
        return new LongGene(number.longValue(), (Long)this._min, (Long)this._max);
    }

    @Override
    public LongGene newInstance() {
        return new LongGene(LongGene.nextLong(RandomRegistry.getRandom(), (Long)this._min, (Long)this._max), (Long)this._min, (Long)this._max);
    }

    @Override
    public LongGene mean(LongGene that) {
        return new LongGene((Long)this._value + ((Long)that._value - (Long)this._value) / 2L, (Long)this._min, (Long)this._max);
    }

    static long nextLong(Random random2, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("min >= max: %d >= %d.", min, max));
        }
        long diff = max - min + 1L;
        long result = 0L;
        if (diff <= 0L) {
            while ((result = random2.nextLong()) < min || result > max) {
            }
        } else {
            result = diff < Integer.MAX_VALUE ? (long)random2.nextInt((int)diff) + min : LongGene.nextLong(random2, diff) + min;
        }
        return result;
    }

    static long nextLong(Random random2, long n) {
        long result;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException(String.format("n is smaller than one: %d", n));
        }
        while ((bits = random2.nextLong() & Long.MAX_VALUE) - (result = bits % n) + (n - 1L) < 0L) {
        }
        return result;
    }
}

