/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractAlterer;
import io.jenetics.AltererResult;
import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.internal.math.comb;
import io.jenetics.internal.math.random;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Random;
import java.util.function.IntFunction;

public abstract class Recombinator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends AbstractAlterer<G, C> {
    private final int _order;

    protected Recombinator(double probability2, int order) {
        super(probability2);
        if (order < 2) {
            throw new IllegalArgumentException(String.format("Order must be greater than one, but was %d.", order));
        }
        this._order = order;
    }

    public int getOrder() {
        return this._order;
    }

    @Override
    public final AltererResult<G, C> alter(Seq<Phenotype<G, C>> population, long generation) {
        AltererResult<G, C> result;
        if (population.size() >= 2) {
            Random random2 = RandomRegistry.getRandom();
            int order = Math.min(this._order, population.size());
            IntFunction<int[]> individuals = i -> {
                int[] ind = comb.subset(population.size(), order, random2);
                ind[0] = i;
                return ind;
            };
            MSeq<Phenotype<G, C>> pop = MSeq.of(population);
            int count = random.indexes(random2, population.size(), this._probability).mapToObj(individuals).mapToInt(i -> this.recombine(pop, (int[])i, generation)).sum();
            result = AltererResult.of(pop.toISeq(), count);
        } else {
            result = AltererResult.of(population.asISeq());
        }
        return result;
    }

    protected abstract int recombine(MSeq<Phenotype<G, C>> var1, int[] var2, long var3);
}

