/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.AnyChromosome;
import io.jenetics.AnyGene;
import io.jenetics.BitChromosome;
import io.jenetics.BitGene;
import io.jenetics.Chromosome;
import io.jenetics.DoubleChromosome;
import io.jenetics.DoubleGene;
import io.jenetics.EnumGene;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.IntegerChromosome;
import io.jenetics.IntegerGene;
import io.jenetics.LongChromosome;
import io.jenetics.LongGene;
import io.jenetics.PermutationChromosome;
import io.jenetics.engine.Codec;
import io.jenetics.internal.math.comb;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.require;
import io.jenetics.util.DoubleRange;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.LongRange;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Codecs {
    private Codecs() {
        require.noInstance();
    }

    public static Codec<Integer, IntegerGene> ofScalar(IntRange domain) {
        Objects.requireNonNull(domain);
        return Codec.of(Genotype.of(IntegerChromosome.of(domain), new Chromosome[0]), gt -> (Integer)((IntegerGene)gt.getChromosome().getGene()).getAllele());
    }

    public static Codec<Long, LongGene> ofScalar(LongRange domain) {
        Objects.requireNonNull(domain);
        return Codec.of(Genotype.of(LongChromosome.of(domain), new Chromosome[0]), gt -> (Long)((LongGene)gt.getGene()).getAllele());
    }

    public static Codec<Double, DoubleGene> ofScalar(DoubleRange domain) {
        Objects.requireNonNull(domain);
        return Codec.of(Genotype.of(DoubleChromosome.of(domain), new Chromosome[0]), gt -> (Double)((DoubleGene)gt.getGene()).getAllele());
    }

    public static <A> Codec<A, AnyGene<A>> ofScalar(Supplier<? extends A> supplier, Predicate<? super A> validator) {
        return Codec.of(Genotype.of(AnyChromosome.of(supplier, validator), new Chromosome[0]), gt -> ((AnyGene)gt.getGene()).getAllele());
    }

    public static <A> Codec<A, AnyGene<A>> ofScalar(Supplier<? extends A> supplier) {
        return Codec.of(Genotype.of(AnyChromosome.of(supplier), new Chromosome[0]), gt -> ((AnyGene)gt.getGene()).getAllele());
    }

    public static Codec<int[], IntegerGene> ofVector(IntRange domain, int length) {
        Objects.requireNonNull(domain);
        require.positive(length);
        return Codec.of(Genotype.of(IntegerChromosome.of(domain, length), new Chromosome[0]), gt -> gt.getChromosome().as(IntegerChromosome.class).toArray());
    }

    public static Codec<long[], LongGene> ofVector(LongRange domain, int length) {
        Objects.requireNonNull(domain);
        require.positive(length);
        return Codec.of(Genotype.of(LongChromosome.of(domain, length), new Chromosome[0]), gt -> gt.getChromosome().as(LongChromosome.class).toArray());
    }

    public static Codec<double[], DoubleGene> ofVector(DoubleRange domain, int length) {
        Objects.requireNonNull(domain);
        require.positive(length);
        return Codec.of(Genotype.of(DoubleChromosome.of(domain, length), new Chromosome[0]), gt -> gt.getChromosome().as(DoubleChromosome.class).toArray());
    }

    public static Codec<int[], IntegerGene> ofVector(IntRange ... domains) {
        if (domains.length == 0) {
            throw new IllegalArgumentException("Domains must not be empty.");
        }
        ISeq chromosomes = Stream.of(domains).peek(Objects::requireNonNull).map(IntegerGene::of).map(xva$0 -> IntegerChromosome.of(xva$0)).collect(ISeq.toISeq());
        return Codec.of(Genotype.of(chromosomes), gt -> {
            int[] args = new int[gt.length()];
            int i = gt.length();
            while (--i >= 0) {
                args[i] = ((IntegerGene)gt.getChromosome(i).getGene()).intValue();
            }
            return args;
        });
    }

    public static Codec<long[], LongGene> ofVector(LongRange ... domains) {
        if (domains.length == 0) {
            throw new IllegalArgumentException("Domains must not be empty.");
        }
        ISeq chromosomes = Stream.of(domains).peek(Objects::requireNonNull).map(LongGene::of).map(xva$0 -> LongChromosome.of(xva$0)).collect(ISeq.toISeq());
        return Codec.of(Genotype.of(chromosomes), gt -> {
            long[] args = new long[gt.length()];
            int i = gt.length();
            while (--i >= 0) {
                args[i] = ((LongGene)gt.getChromosome(i).getGene()).longValue();
            }
            return args;
        });
    }

    public static Codec<double[], DoubleGene> ofVector(DoubleRange ... domains) {
        if (domains.length == 0) {
            throw new IllegalArgumentException("Domains must not be empty.");
        }
        ISeq chromosomes = Stream.of(domains).peek(Objects::requireNonNull).map(DoubleGene::of).map(xva$0 -> DoubleChromosome.of(xva$0)).collect(ISeq.toISeq());
        return Codec.of(Genotype.of(chromosomes), gt -> {
            double[] args = new double[gt.length()];
            int i = gt.length();
            while (--i >= 0) {
                args[i] = ((DoubleGene)gt.getChromosome(i).getGene()).doubleValue();
            }
            return args;
        });
    }

    public static <A> Codec<ISeq<A>, AnyGene<A>> ofVector(Supplier<? extends A> supplier, Predicate<? super A> alleleValidator, Predicate<? super ISeq<A>> alleleSeqValidator, int length) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(alleleSeqValidator);
        Objects.requireNonNull(alleleSeqValidator);
        require.positive(length);
        return Codec.of(Genotype.of(AnyChromosome.of(supplier, alleleValidator, alleleSeqValidator, length), new Chromosome[0]), gt -> gt.getChromosome().toSeq().map(Gene::getAllele));
    }

    public static <A> Codec<ISeq<A>, AnyGene<A>> ofVector(Supplier<? extends A> supplier, Predicate<? super A> validator, int length) {
        return Codecs.ofVector(supplier, validator, Equality.True(), length);
    }

    public static <A> Codec<ISeq<A>, AnyGene<A>> ofVector(Supplier<? extends A> supplier, int length) {
        return Codecs.ofVector(supplier, Equality.TRUE, length);
    }

    public static Codec<int[], EnumGene<Integer>> ofPermutation(int length) {
        require.positive(length);
        return Codec.of(Genotype.of(PermutationChromosome.ofInteger(length), new Chromosome[0]), gt -> gt.getChromosome().toSeq().stream().mapToInt(EnumGene::getAllele).toArray());
    }

    private static <T> T[] newArray(Class<?> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> Codec<ISeq<T>, EnumGene<T>> ofPermutation(ISeq<? extends T> alleles) {
        if (alleles.isEmpty()) {
            throw new IllegalArgumentException("Empty allele array is not allowed.");
        }
        return Codec.of(Genotype.of(PermutationChromosome.of(alleles), new Chromosome[0]), gt -> gt.getChromosome().toSeq().map(EnumGene::getAllele));
    }

    public static <T> Codec<ISeq<T>, BitGene> ofSubSet(ISeq<? extends T> basicSet) {
        Objects.requireNonNull(basicSet);
        require.positive(basicSet.length());
        return Codec.of(Genotype.of(BitChromosome.of(basicSet.length()), new Chromosome[0]), gt -> ((BitChromosome)gt.getChromosome()).ones().mapToObj(basicSet::get).collect(ISeq.toISeq()));
    }

    public static <T> Codec<ISeq<T>, EnumGene<T>> ofSubSet(ISeq<? extends T> basicSet, int size) {
        Objects.requireNonNull(basicSet);
        comb.checkSubSet(basicSet.size(), size);
        return Codec.of(Genotype.of(PermutationChromosome.of(basicSet, size), new Chromosome[0]), gt -> gt.getChromosome().stream().map(EnumGene::getAllele).collect(ISeq.toISeq()));
    }
}

