/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.engine.Codec;
import io.jenetics.util.Factory;
import io.jenetics.util.ISeq;
import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.function.Function;

final class CompositeCodec<T, G extends Gene<?, G>>
implements Codec<T, G> {
    private final ISeq<? extends Codec<?, G>> _codecs;
    private final Function<? super Object[], ? extends T> _decoder;
    private final int[] _lengths;
    private final Genotype<G> _encoding;

    CompositeCodec(ISeq<? extends Codec<?, G>> codecs, Function<? super Object[], ? extends T> decoder) {
        this._codecs = Objects.requireNonNull(codecs);
        this._decoder = Objects.requireNonNull(decoder);
        Seq genotypes = this._codecs.map((T c) -> c.encoding() instanceof Genotype ? (Genotype)c.encoding() : c.encoding().newInstance());
        this._lengths = genotypes.stream().mapToInt(Genotype::length).toArray();
        this._encoding = Genotype.of(genotypes.stream().flatMap(Genotype::stream).collect(ISeq.toISeq()));
    }

    @Override
    public Factory<Genotype<G>> encoding() {
        return this._encoding;
    }

    @Override
    public Function<Genotype<G>, T> decoder() {
        return gt -> this._decoder.apply((Object[])this.groups((Genotype<G>)gt));
    }

    private Object[] groups(Genotype<G> genotype) {
        Object[] groups = new Object[this._codecs.length()];
        ISeq<Chromosome<G>> chromosomes = genotype.toSeq();
        int start = 0;
        for (int i = 0; i < this._codecs.length(); ++i) {
            int end = start + this._lengths[i];
            Genotype gt = Genotype.of(chromosomes.subSeq(start, end));
            groups[i] = ((Codec)this._codecs.get(i)).decoder().apply(gt);
            start = end;
        }
        return groups;
    }
}

