/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.engine.Timer;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class TimedResult<T> {
    final Duration duration;
    final T result;

    TimedResult(Duration duration, T result) {
        this.duration = Objects.requireNonNull(duration);
        this.result = Objects.requireNonNull(result);
    }

    public static <T> Supplier<TimedResult<T>> of(Supplier<? extends T> supplier, Clock clock) {
        return () -> {
            Timer timer = Timer.of(clock).start();
            Object result = supplier.get();
            return new TimedResult(timer.stop().getTime(), result);
        };
    }

    public static <T, R> Function<T, TimedResult<R>> of(Function<? super T, ? extends R> function, Clock clock) {
        return value -> {
            Timer timer = Timer.of(clock).start();
            Object result = function.apply(value);
            return new TimedResult(timer.stop().getTime(), result);
        };
    }
}

