/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import io.jenetics.internal.util.require;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Empty {
    private Empty() {
        require.noInstance();
    }

    public static <T> MSeq<T> mseq() {
        return EmptyMSeq.INSTANCE;
    }

    public static <T> ISeq<T> iseq() {
        return EmptyISeq.INSTANCE;
    }

    public static enum EmptyISeq implements ISeq<Object>
    {
        INSTANCE;


        @Override
        public Iterator<Object> iterator() {
            return this.asList().iterator();
        }

        @Override
        public ISeq<Object> subSeq(int start, int end) {
            Array.checkIndex(start, end, this.length());
            return this;
        }

        @Override
        public ISeq<Object> subSeq(int start) {
            Array.checkIndex(start, 0, this.length());
            return this;
        }

        @Override
        public Object get(int index) {
            throw new ArrayIndexOutOfBoundsException("ISeq is empty.");
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public List<Object> asList() {
            return Collections.emptyList();
        }

        @Override
        public <B> ISeq<B> map(Function<? super Object, ? extends B> mapper) {
            Objects.requireNonNull(mapper);
            return Empty.iseq();
        }

        @Override
        public ISeq<Object> append(Object ... values) {
            return ISeq.of(values);
        }

        @Override
        public ISeq<Object> append(Iterable<?> values) {
            return ISeq.of(values);
        }

        @Override
        public ISeq<Object> prepend(Object ... values) {
            return ISeq.of(values);
        }

        @Override
        public ISeq<Object> prepend(Iterable<?> values) {
            return ISeq.of(values);
        }

        @Override
        public Stream<Object> stream() {
            return Stream.empty();
        }

        @Override
        public Stream<Object> parallelStream() {
            return Stream.empty();
        }

        @Override
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public MSeq<Object> copy() {
            return EmptyMSeq.INSTANCE;
        }
    }

    public static enum EmptyMSeq implements MSeq<Object>
    {
        INSTANCE;


        @Override
        public void set(int index, Object value) {
            throw new ArrayIndexOutOfBoundsException("MSeq is empty.");
        }

        @Override
        public MSeq<Object> sort(int start, int end, Comparator<? super Object> comparator) {
            Array.checkIndex(start, end, this.length());
            return this;
        }

        @Override
        public ListIterator<Object> listIterator() {
            return this.asList().listIterator();
        }

        @Override
        public MSeq<Object> subSeq(int start, int end) {
            Array.checkIndex(start, end, this.length());
            return this;
        }

        @Override
        public MSeq<Object> subSeq(int start) {
            Array.checkIndex(start, 0, this.length());
            return this;
        }

        @Override
        public <B> MSeq<B> map(Function<? super Object, ? extends B> mapper) {
            Objects.requireNonNull(mapper);
            return Empty.mseq();
        }

        @Override
        public MSeq<Object> append(Object ... values) {
            return MSeq.of(values);
        }

        @Override
        public MSeq<Object> append(Iterable<?> values) {
            return MSeq.of(values);
        }

        @Override
        public MSeq<Object> prepend(Object ... values) {
            return MSeq.of(values);
        }

        @Override
        public MSeq<Object> prepend(Iterable<?> values) {
            return MSeq.of(values);
        }

        @Override
        public Stream<Object> stream() {
            return Stream.empty();
        }

        @Override
        public Stream<Object> parallelStream() {
            return Stream.empty();
        }

        @Override
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public ISeq<Object> toISeq() {
            return EmptyISeq.INSTANCE;
        }

        @Override
        public MSeq<Object> copy() {
            return this;
        }

        @Override
        public Object get(int index) {
            throw new ArrayIndexOutOfBoundsException("MSeq is empty.");
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public List<Object> asList() {
            return Collections.emptyList();
        }

        @Override
        public Iterator<Object> iterator() {
            return this.asList().iterator();
        }
    }
}

