/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoClientException;
import com.mongodb.internal.ExpirableValue;
import com.mongodb.internal.Locks;
import com.mongodb.internal.authentication.HttpHelper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonParseException;

public final class AzureCredentialHelper {
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    private static final String EXPIRES_IN_FIELD = "expires_in";
    private static final Lock CACHED_ACCESS_TOKEN_LOCK = new ReentrantLock();
    private static volatile ExpirableValue<String> cachedAccessToken = ExpirableValue.expired();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BsonDocument obtainFromEnvironment() {
        String accessToken;
        block10: {
            Optional<String> cachedValue = cachedAccessToken.getValue();
            if (cachedValue.isPresent()) {
                accessToken = cachedValue.get();
            } else {
                Locks.lockInterruptibly(CACHED_ACCESS_TOKEN_LOCK);
                try {
                    BsonDocument responseDocument;
                    cachedValue = cachedAccessToken.getValue();
                    if (cachedValue.isPresent()) {
                        accessToken = cachedValue.get();
                        break block10;
                    }
                    String endpoint = "http://169.254.169.254:80/metadata/identity/oauth2/token?api-version=2018-02-01&resource=https://vault.azure.net";
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("Metadata", "true");
                    headers.put("Accept", "application/json");
                    long startNanoTime = System.nanoTime();
                    try {
                        responseDocument = BsonDocument.parse((String)HttpHelper.getHttpContents("GET", endpoint, headers));
                    }
                    catch (JsonParseException e) {
                        throw new MongoClientException("Exception parsing JSON from Azure IMDS metadata response.", e);
                    }
                    if (!responseDocument.isString((Object)ACCESS_TOKEN_FIELD)) {
                        throw new MongoClientException(String.format("The %s field from Azure IMDS metadata response is missing or is not a string", ACCESS_TOKEN_FIELD));
                    }
                    if (!responseDocument.isString((Object)EXPIRES_IN_FIELD)) {
                        throw new MongoClientException(String.format("The %s field from Azure IMDS metadata response is missing or is not a string", EXPIRES_IN_FIELD));
                    }
                    accessToken = responseDocument.getString((Object)ACCESS_TOKEN_FIELD).getValue();
                    int expiresInSeconds = Integer.parseInt(responseDocument.getString((Object)EXPIRES_IN_FIELD).getValue());
                    cachedAccessToken = ExpirableValue.expirable(accessToken, Duration.ofSeconds(expiresInSeconds).minus(Duration.ofMinutes(1L)), startNanoTime);
                }
                finally {
                    CACHED_ACCESS_TOKEN_LOCK.unlock();
                }
            }
        }
        return new BsonDocument("accessToken", (BsonValue)new BsonString(accessToken));
    }

    private AzureCredentialHelper() {
    }
}

