/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.BufferProvider;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.SocketStream;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.UnixSocketChannelStream;
import com.mongodb.spi.dns.InetAddressResolver;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class SocketStreamFactory
implements StreamFactory {
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final BufferProvider bufferProvider = PowerOfTwoBufferPool.DEFAULT;

    public SocketStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings) {
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream;
        if (serverAddress instanceof UnixServerAddress) {
            if (this.sslSettings.isEnabled()) {
                throw new MongoClientException("Socket based connections do not support ssl");
            }
            stream = new UnixSocketChannelStream((UnixServerAddress)serverAddress, this.settings, this.sslSettings, this.bufferProvider);
        } else {
            stream = this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider);
        }
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

