/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.OpAnd;
import org.springframework.expression.spel.ast.OpDivide;
import org.springframework.expression.spel.ast.OpEQ;
import org.springframework.expression.spel.ast.OpGE;
import org.springframework.expression.spel.ast.OpGT;
import org.springframework.expression.spel.ast.OpLE;
import org.springframework.expression.spel.ast.OpLT;
import org.springframework.expression.spel.ast.OpMinus;
import org.springframework.expression.spel.ast.OpModulus;
import org.springframework.expression.spel.ast.OpMultiply;
import org.springframework.expression.spel.ast.OpNE;
import org.springframework.expression.spel.ast.OpOr;
import org.springframework.expression.spel.ast.OpPlus;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.OperatorPower;

public class OperatorNode
extends ExpressionNode {
    private static final Map<String, String> OPERATORS = Map.ofEntries(Map.entry("+", "$add"), Map.entry("-", "$subtract"), Map.entry("*", "$multiply"), Map.entry("/", "$divide"), Map.entry("%", "$mod"), Map.entry("^", "$pow"), Map.entry("==", "$eq"), Map.entry("!=", "$ne"), Map.entry(">", "$gt"), Map.entry(">=", "$gte"), Map.entry("<", "$lt"), Map.entry("<=", "$lte"), Map.entry("and", "$and"), Map.entry("or", "$or"));
    private static final Set<Class> SUPPORTED_MATH_OPERATORS = Set.of(OpMinus.class, OpPlus.class, OpMultiply.class, OpDivide.class, OpModulus.class, OperatorPower.class, OpNE.class, OpEQ.class, OpGT.class, OpGE.class, OpLT.class, OpLE.class);
    private final Operator operator;

    OperatorNode(Operator node, ExpressionState state) {
        super((SpelNode)node, state);
        this.operator = node;
    }

    @Override
    public boolean isMathematicalOperation() {
        return SUPPORTED_MATH_OPERATORS.contains(this.operator.getClass());
    }

    @Override
    public boolean isLogicalOperator() {
        return this.operator instanceof OpOr || this.operator instanceof OpAnd;
    }

    public boolean isUnaryOperator() {
        return this.operator.getChildCount() == 1;
    }

    public String getMongoOperator() {
        if (!OPERATORS.containsKey(this.operator.getOperatorName())) {
            throw new IllegalArgumentException(String.format("Unknown operator name; Cannot translate %s into its MongoDB aggregation function representation", this.operator.getOperatorName()));
        }
        return OPERATORS.get(this.operator.getOperatorName());
    }

    public boolean isUnaryMinus() {
        return this.isUnaryOperator() && this.operator instanceof OpMinus;
    }

    public ExpressionNode getLeft() {
        return this.from((SpelNode)this.operator.getLeftOperand());
    }

    public ExpressionNode getRight() {
        return this.from((SpelNode)this.operator.getRightOperand());
    }
}

