/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.ospf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.ospf.ImmutableOspfMd5AuthKeyDto;
import com.ubnt.return.F;
import com.ubnt.service.ospf.OspfMd5AuthKeyDocumentPart;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import org.immutables.value.Value;

@Schema(name="OSPF MD5 Authentication Key")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableOspfMd5AuthKeyDto.class)
@Value.Immutable(builder=false)
@F
public interface OspfMd5AuthKeyDto {
    @JsonProperty(value="id")
    @Min(value=1L)
    @Max(value=255L)
    @Value.Parameter(order=0)
    public @Min(value=1L) @Max(value=255L) int id();

    @JsonProperty(value="key")
    @NotEmpty
    @Max(value=16L)
    @Value.Parameter(order=1)
    public @NotEmpty @Max(value=16L) String key();

    default public OspfMd5AuthKeyDocumentPart toDocument() {
        return OspfMd5AuthKeyDocumentPart.of(this.id(), this.key());
    }

    public static OspfMd5AuthKeyDto of(int n2, String string) {
        return ImmutableOspfMd5AuthKeyDto.of(n2, string);
    }

    public static OspfMd5AuthKeyDto ofDocument(OspfMd5AuthKeyDocumentPart ospfMd5AuthKeyDocumentPart) {
        return OspfMd5AuthKeyDto.of(ospfMd5AuthKeyDocumentPart.getId(), ospfMd5AuthKeyDocumentPart.getKey());
    }
}

