/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.switches;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.X;
import com.ubnt.service.analytics.api.devicereport.switches.PortSettings;
import com.ubnt.service.analytics.api.devicereport.switches.PortStats;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Port {
    private int id;
    private String media;
    private Integer poeCapability;
    private Integer speedCapability;
    private int satisfaction;
    private int satisfactionReason;
    private PortSettings settings;
    private PortStats stats;

    public Port(int n2, String string, X x2) {
        this.id = n2;
        this.media = string;
        this.poeCapability = x2.getInt("poe_caps");
        this.speedCapability = x2.getInt("speed_caps");
        this.satisfaction = x2.getInt("satisfaction", -1);
        this.satisfactionReason = x2.getInt("satisfaction_reason");
    }

    public int getId() {
        return this.id;
    }

    public String getMedia() {
        return this.media;
    }

    public Integer getPoeCapability() {
        return this.poeCapability;
    }

    public Integer getSpeedCapability() {
        return this.speedCapability;
    }

    public PortSettings getSettings() {
        return this.settings;
    }

    public Port setSettings(PortSettings portSettings) {
        this.settings = portSettings;
        return this;
    }

    public PortStats getStats() {
        return this.stats;
    }

    public Port setStats(PortStats portStats) {
        this.stats = portStats;
        return this;
    }
}

