/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.switches;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.X;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PortStats {
    private Long startTime;
    private Long endTime;
    private Double poePower;
    private Double rxPackets;
    private Double rxBytes;
    private Double rxErrors;
    private Double rxDropped;
    private Double rxMulticast;
    private Double rxBroadcast;
    private Double rxFrags;
    private Double txPackets;
    private Double txBytes;
    private Double txErrors;
    private Double txDropped;
    private Double txMulticast;
    private Double txBroadcast;
    private Double txRetries;
    private Integer linkSpeed;

    public PortStats(X x2, long l2) {
        this.startTime = x2.getLong("time");
        this.endTime = l2;
        this.poePower = x2.getDouble("poe_power", 0.0);
        this.rxPackets = x2.getDouble("rx_packets", 0.0);
        this.rxBytes = x2.getDouble("rx_bytes", 0.0);
        this.rxErrors = x2.getDouble("rx_errors", 0.0);
        this.rxDropped = x2.getDouble("rx_dropped", 0.0);
        this.rxMulticast = x2.getDouble("rx_multicast", 0.0);
        this.rxBroadcast = x2.getDouble("rx_broadcast", 0.0);
        this.rxFrags = x2.getDouble("rx_frags", 0.0);
        this.txPackets = x2.getDouble("tx_packets", 0.0);
        this.txBytes = x2.getDouble("tx_bytes", 0.0);
        this.txErrors = x2.getDouble("tx_errors", 0.0);
        this.txDropped = x2.getDouble("tx_dropped", 0.0);
        this.txMulticast = x2.getDouble("tx_multicast", 0.0);
        this.txBroadcast = x2.getDouble("tx_broadcast", 0.0);
        this.txRetries = x2.getDouble("tx_retries", 0.0);
    }

    public PortStats setLinkSpeed(int n2) {
        this.linkSpeed = n2;
        return this;
    }

    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Double getPoePower() {
        return this.poePower;
    }

    public Double getRxPackets() {
        return this.rxPackets;
    }

    public Double getRxBytes() {
        return this.rxBytes;
    }

    public Double getRxErrors() {
        return this.rxErrors;
    }

    public Double getRxDropped() {
        return this.rxDropped;
    }

    public Double getRxMulticast() {
        return this.rxMulticast;
    }

    public Double getRxBroadcast() {
        return this.rxBroadcast;
    }

    public Double getRxFrags() {
        return this.rxFrags;
    }

    public Double getTxPackets() {
        return this.txPackets;
    }

    public Double getTxBytes() {
        return this.txBytes;
    }

    public Double getTxErrors() {
        return this.txErrors;
    }

    public Double getTxDropped() {
        return this.txDropped;
    }

    public Double getTxMulticast() {
        return this.txMulticast;
    }

    public Double getTxBroadcast() {
        return this.txBroadcast;
    }

    public Double getTxRetries() {
        return this.txRetries;
    }
}

