/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.mqtt;

import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import com.amazonaws.services.iot.client.core.AwsIotMessageCallback;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;

public class AwsIotMqttConnectionListener
implements IMqttActionListener {
    private static final Logger LOGGER = Logger.getLogger(AwsIotMqttConnectionListener.class.getName());
    private final AbstractAwsIotClient client;
    private final boolean isConnect;
    private final AwsIotMessageCallback userCallback;

    public AwsIotMqttConnectionListener(AbstractAwsIotClient client, boolean isConnect, AwsIotMessageCallback userCallback) {
        this.client = client;
        this.isConnect = isConnect;
        this.userCallback = userCallback;
    }

    public void onSuccess(IMqttToken arg0) {
        this.client.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (AwsIotMqttConnectionListener.this.isConnect) {
                    AwsIotMqttConnectionListener.this.client.getConnection().onConnectionSuccess();
                } else {
                    AwsIotMqttConnectionListener.this.client.getConnection().onConnectionClosed();
                }
                if (AwsIotMqttConnectionListener.this.userCallback != null) {
                    AwsIotMqttConnectionListener.this.userCallback.onSuccess();
                }
            }
        });
    }

    public void onFailure(IMqttToken arg0, Throwable arg1) {
        LOGGER.log(Level.WARNING, (this.isConnect ? "Connect" : "Disconnect") + " request failure", arg1);
        this.client.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (AwsIotMqttConnectionListener.this.isConnect) {
                    AwsIotMqttConnectionListener.this.client.getConnection().onConnectionFailure();
                } else {
                    AwsIotMqttConnectionListener.this.client.getConnection().onConnectionClosed();
                }
                if (AwsIotMqttConnectionListener.this.userCallback != null) {
                    AwsIotMqttConnectionListener.this.userCallback.onFailure();
                }
            }
        });
    }
}

