/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.dmcoa.client;

import com.axlradius.misc.b;
import com.axlradius.radclient4.PacketType;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.attributes.Cisco;
import com.axlradius.radclient4.attributes.Microsoft;
import com.axlradius.radclient4.auth.eap.tls.c;
import com.axlradius.radclient4.dictionary.BD;
import com.axlradius.radclient4.dictionary.RADIUSDictionary;
import com.axlradius.radclient4.dmcoa.client.DMCOACallback;
import com.axlradius.radclient4.dmcoa.client.DMCOAResponse;
import com.axlradius.radclient4.radutil.Util;
import com.axlradius.radclient4.radutil.f;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class DMCOAReceiver
implements Runnable {
    public static final int Disconnect_Request = 40;
    public static final int Disconnect_ACK = 41;
    public static final int Disconnect_NAK = 42;
    public static final int CoA_Request = 43;
    public static final int CoA_ACK = 44;
    public static final int CoA_NAK = 45;
    public static final int DEFAULT_WINDOW = 300;
    private boolean y = false;
    private MessageDigest e = c.d();
    private int port = 3799;
    private a a;
    private int ao;
    private int ag;
    private byte[] i;
    private AttributeList f;
    private DatagramSocket b;
    private DMCOACallback a;
    private Thread a;
    private boolean z;
    private int ap;

    public DMCOAReceiver(InetAddress inetAddress, byte[] byArray, boolean bl, int n2, DMCOACallback dMCOACallback) {
        HashMap<InetAddress, byte[]> hashMap = new HashMap<InetAddress, byte[]>();
        hashMap.put(inetAddress, byArray);
        this.a(hashMap, bl, n2, dMCOACallback);
    }

    public DMCOAReceiver(Map<InetAddress, byte[]> map, boolean bl, int n2, DMCOACallback dMCOACallback) {
        this.a(map, bl, n2, dMCOACallback);
    }

    private void a(Map<InetAddress, byte[]> map, boolean bl, int n2, DMCOACallback dMCOACallback) {
        this.a = new a(this, map);
        this.a.setDebug(bl);
        this.port = n2;
        if (this.port == 0) {
            this.port = 3799;
        }
        this.a = dMCOACallback;
    }

    public final void start() throws RADIUSException {
        if (this.a.getDebugIndicator()) {
            this.a.logToDebug("Receiver thread - starting.");
        }
        this.a = new Thread((Runnable)this, "DM/COA RADIUS Packet Receiver");
        this.a.setDaemon(false);
        this.a.start();
        int n2 = 10;
        while (n2-- > 0 && !Util.sleep(100L)) {
            if (!this.y) continue;
            if (this.a.getDebugIndicator()) {
                this.a.logToDebug("Receiver thread has started.");
            }
            return;
        }
        this.clean();
        throw new RADIUSException("Server failed to start in " + (10 - n2) * 100 + " milliseconds.");
    }

    public final void stop() {
        this.a.interrupt();
        this.clean();
    }

    public final boolean useEventTimestamp(boolean bl, int n2) {
        boolean bl2 = this.z;
        this.z = bl;
        this.ap = n2;
        return bl2;
    }

    public final void addDictionary(RADIUSDictionary rADIUSDictionary) {
        BD.addDictionary(rADIUSDictionary);
    }

    @Override
    public final void run() {
        try {
            DMCOAReceiver dMCOAReceiver = this;
            if (dMCOAReceiver.a.getDebugIndicator()) {
                dMCOAReceiver.a.logToDebug("DM / COA Receiver starting on port " + dMCOAReceiver.port + "\n");
            }
            Object object = new byte[4097];
            DatagramPacket datagramPacket = new DatagramPacket((byte[])object, 4097);
            dMCOAReceiver.b = new DatagramSocket(dMCOAReceiver.port);
            dMCOAReceiver.b.setSoTimeout(0);
            block8: while (true) {
                dMCOAReceiver.y = true;
                dMCOAReceiver.b.receive(datagramPacket);
                String string = datagramPacket.getAddress().getHostAddress();
                if (dMCOAReceiver.a.getDebugIndicator()) {
                    dMCOAReceiver.a.logToDebug(string + "COA/DM Packet received from port " + datagramPacket.getPort() + "\n");
                }
                if (!dMCOAReceiver.a.a(datagramPacket.getAddress())) {
                    object = string + " Error: Packet arrived from unknown server:\n";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                byte[] byArray = datagramPacket.getData();
                int n2 = datagramPacket.getLength();
                if (n2 < 20) {
                    object = string + " Error: Packet is too small: " + n2 + "\n";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                dMCOAReceiver.ao = byArray[1] & 0xFF;
                dMCOAReceiver.ag = byArray[0] & 0xFF;
                if (dMCOAReceiver.ag != 40 && dMCOAReceiver.ag != 43) {
                    new PacketType();
                    object = string + " Error: Unexpected packet type of " + PacketType.getName(dMCOAReceiver.ag);
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                if (n2 > 4096) {
                    object = string + " Error: Packet length exceed maximum allowable length";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                int n3 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                if (n3 > n2) {
                    object = string + " Error: Stated packet length exceed physical packet length";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                dMCOAReceiver.i = new byte[16];
                System.arraycopy(byArray, 4, dMCOAReceiver.i, 0, 16);
                int n4 = n2 - 20;
                if (n4 < 0) {
                    object = string + " Error: Attribute size is negative.";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                try {
                    dMCOAReceiver.f = new AttributeList();
                    dMCOAReceiver.f.loadRadiusAttributes(byArray, 20, n4);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object = string + " Error: Attributes are corrupt.";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                if (dMCOAReceiver.a.getDebugIndicator()) {
                    dMCOAReceiver.a("DMCOA Request Packet", dMCOAReceiver.ao, dMCOAReceiver.ag, byArray, n2, dMCOAReceiver.f, datagramPacket.getAddress(), datagramPacket.getPort());
                }
                byte[] byArray2 = dMCOAReceiver.a.getSecret();
                DMCOAReceiver dMCOAReceiver2 = dMCOAReceiver;
                byte[] byArray3 = byArray2;
                byte[] byArray4 = dMCOAReceiver.i;
                int n5 = n3;
                byte[] byArray5 = byArray;
                object = dMCOAReceiver2;
                dMCOAReceiver2.e.reset();
                byte[] byArray6 = new byte[n5];
                System.arraycopy(byArray5, 0, byArray6, 0, n5);
                System.arraycopy(new byte[16], 0, byArray6, 4, 16);
                ((DMCOAReceiver)object).e.update(byArray6);
                ((DMCOAReceiver)object).e.update(byArray3);
                object = ((DMCOAReceiver)object).e.digest();
                boolean bl = Util.cmp((byte[])object, byArray4);
                Util.clean((byte[])object);
                if (!bl) {
                    object = string + " Error: Authenticator field is incorrect - probably secret mismatch";
                    dMCOAReceiver.a.logToDebug((String)object);
                    Util.clean(byArray2);
                    continue;
                }
                if (dMCOAReceiver.z) {
                    if (dMCOAReceiver.f.toArray(55).length == 0) {
                        object = string + " Error: Missing Event-Timestamp attribute.";
                        dMCOAReceiver.a.logToDebug((String)object);
                        Util.clean(byArray2);
                        dMCOAReceiver.f.clean();
                        continue;
                    }
                    long l2 = (long)dMCOAReceiver.f.getAttribute(55).getInt() * 1000L;
                    long l3 = dMCOAReceiver.ap / 2;
                    long l4 = System.currentTimeMillis();
                    long l5 = l4 - l3;
                    long l6 = l4 + l3;
                    bl = l2 < l5;
                    n5 = l2 > l6 ? 1 : 0;
                    long l7 = Math.abs(l4 - l2);
                    if (bl) {
                        object = "Event-Timestamp value is invalid - too far in the past by " + Util.getTimeString(l7) + " allowed Event Timestamp Window is " + Util.getTimeString(dMCOAReceiver.ap);
                        dMCOAReceiver.a.logToDebug((String)object);
                    }
                    if (n5 != 0) {
                        object = "Event-Timestamp value is invalid - too far in the future by " + Util.getTimeString(l7) + " allowed Event Timestamp Window is " + Util.getTimeString(dMCOAReceiver.ap);
                        dMCOAReceiver.a.logToDebug((String)object);
                    }
                    if (bl || n5 != 0) {
                        dMCOAReceiver.f.clean();
                        Util.clean(byArray2);
                        continue;
                    }
                }
                if (dMCOAReceiver.a.getDebugIndicator()) {
                    dMCOAReceiver.a("DMCOA Request Packet", dMCOAReceiver.ao, dMCOAReceiver.ag, byArray, n2, dMCOAReceiver.f, datagramPacket.getAddress(), datagramPacket.getPort());
                }
                DMCOAResponse dMCOAResponse = dMCOAReceiver.a.dmcoaCallback(dMCOAReceiver.ag, dMCOAReceiver.f);
                object = dMCOAResponse;
                if (dMCOAResponse == null) {
                    if (dMCOAReceiver.a.getDebugIndicator()) {
                        object = string + " Error: Callback returned a null DMCOAResponse.";
                        dMCOAReceiver.a.logToDebug((String)object);
                    }
                    dMCOAReceiver.f.clean();
                    Util.clean(byArray2);
                    continue;
                }
                Object object2 = ((DMCOAResponse)object).getResponseAttributes();
                if (object2 == null) {
                    if (!dMCOAReceiver.a.getDebugIndicator()) continue;
                    object = string + " Error: DMCOAResponse is missing response attributes.";
                    dMCOAReceiver.a.logToDebug((String)object);
                    continue;
                }
                int n6 = ((DMCOAResponse)object).getPacketType();
                switch (n6) {
                    case 41: 
                    case 42: 
                    case 44: 
                    case 45: {
                        break;
                    }
                    default: {
                        if (!dMCOAReceiver.a.getDebugIndicator()) continue block8;
                        new PacketType();
                        object = string + " Error: DMCOAResponse has an unexpected packet type ." + PacketType.getName(n6);
                        dMCOAReceiver.a.logToDebug((String)object);
                        continue block8;
                    }
                }
                ((AttributeList)object2).deleteAll(24);
                Attribute[] attributeArray = dMCOAReceiver.f.toArray(24);
                ((AttributeList)object2).add(attributeArray);
                byte[] byArray7 = ((AttributeList)object2).createRadiusAttributeBlock();
                int n7 = 20 + byArray7.length;
                byte[] byArray8 = new byte[n7];
                byte[] byArray9 = new byte[n7];
                byArray8[0] = (byte)n6;
                byArray8[1] = (byte)dMCOAReceiver.ao;
                byArray8[2] = (byte)(n7 >> 8);
                byArray8[3] = (byte)n7;
                System.arraycopy(dMCOAReceiver.i, 0, byArray8, 4, 16);
                System.arraycopy(byArray7, 0, byArray8, 20, byArray7.length);
                MessageDigest messageDigest = c.d();
                messageDigest.update(byArray8);
                messageDigest.update(dMCOAReceiver.a.getSecret());
                dMCOAReceiver.i = messageDigest.digest();
                System.arraycopy(dMCOAReceiver.i, 0, byArray8, 4, 16);
                InetAddress inetAddress = datagramPacket.getAddress();
                int n8 = datagramPacket.getPort();
                if (dMCOAReceiver.a.getDebugIndicator()) {
                    dMCOAReceiver.a("DMCOA Response Packet", dMCOAReceiver.ao, ((DMCOAResponse)object).getPacketType(), byArray8, n7, (AttributeList)object2, inetAddress, n8);
                }
                object2 = new DatagramPacket(byArray9, n7);
                ((DatagramPacket)object2).setData(byArray8);
                ((DatagramPacket)object2).setLength(n7);
                ((DatagramPacket)object2).setPort(n8);
                ((DatagramPacket)object2).setAddress(inetAddress);
                dMCOAReceiver.b.send((DatagramPacket)object2);
                datagramPacket.setLength(4097);
            }
        }
        catch (InterruptedException interruptedException) {
            if (this.a.getDebugIndicator()) {
                this.a.logToDebug("Receiver thread has terminated.");
            }
            this.clean();
            return;
        }
        catch (Exception exception) {
            if (!this.a.getDebugIndicator()) {
                return;
            }
            f f2 = new f();
            PrintWriter printWriter = new PrintWriter(f2);
            exception.printStackTrace(printWriter);
            String string = f2.toString();
            this.a.logToDebug(string);
            printWriter.close();
            f2.close();
            return;
        }
    }

    private void clean() {
        this.a.clean();
        if (this.f != null) {
            this.f.clean();
        }
        Util.clean(this.i);
        this.ag = 0;
        this.ao = 0;
        this.port = 0;
        this.z = false;
    }

    private void a(String string, int n2, int n3, byte[] byArray, int n4, AttributeList attributeList, InetAddress inetAddress, int n5) {
        String string2 = "<" + n2 + "> ";
        b b2 = new b(byArray);
        new PacketType();
        new PacketType();
        string = "\n" + string2 + "------------------- " + string + " -----------------\n" + string2 + "Address: " + inetAddress.getHostAddress() + ":" + n5 + "  Packet Length: " + n4 + " Type: " + PacketType.getName(n3) + "  Packet Length: " + n4 + " Type: " + PacketType.getName(n3) + "\n" + b2.a(0, n4) + "\nAttributes:\n" + attributeList + "\n" + string2 + "---------------------------------------------------";
        this.a.logToDebug(string);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    final class a {
        private Map<InetAddress, byte[]> h;
        private boolean debug = false;
        private BufferedWriter a;
        private InetAddress c;
        private /* synthetic */ DMCOAReceiver a;

        a(DMCOAReceiver dMCOAReceiver, Map<InetAddress, byte[]> map) {
            this.a = dMCOAReceiver;
            this.h = map;
        }

        public final boolean getDebugIndicator() {
            return this.debug;
        }

        final byte[] getSecret() {
            if (this.c == null) {
                return new byte[0];
            }
            byte[] byArray = this.h.get(this.c);
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }

        final boolean a(InetAddress inetAddress) {
            boolean bl = this.h.containsKey(inetAddress);
            if (bl) {
                this.c = inetAddress;
            }
            return bl;
        }

        final boolean setDebug(boolean bl) {
            try {
                boolean bl2 = bl;
                a a2 = this;
                this.debug = bl2;
                a2.a = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
                new Microsoft();
                new Cisco();
            }
            catch (IOException iOException) {
                System.err.println("Can't write to stdout");
                return false;
            }
            return true;
        }

        final void logToDebug(String string) {
            if (this.a != null) {
                try {
                    this.a.write(string, 0, string.length());
                    this.a.flush();
                    return;
                }
                catch (IOException iOException) {}
            }
            System.out.println(string);
        }

        final void clean() {
            if (this.h != null) {
                Iterator<byte[]> iterator = this.h.values().iterator();
                while (iterator.hasNext()) {
                    Util.clean(iterator.next());
                }
            }
            this.debug = false;
            this.a.b.close();
        }
    }
}

