/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.openide.explorer.propertysheet.AutoGridLayout;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.WeakSet;

class RadioInplaceEditor
extends JPanel
implements InplaceEditor,
ActionListener {
    private transient List<ActionListener> actionListenerList;
    protected transient PropertyEditor editor = null;
    protected transient PropertyEnv env = null;
    protected transient PropertyModel mdl = null;
    protected transient ButtonGroup group = null;
    private boolean tableUI = false;
    boolean isFirstEvent = false;
    private WeakSet<InvRadioButton> buttonCache = new WeakSet();
    private boolean useTitle = false;

    public RadioInplaceEditor(boolean bl) {
        this.setLayout(new AutoGridLayout(false));
        this.tableUI = bl;
        this.setOpaque(true);
    }

    @Override
    public void clear() {
        this.editor = null;
        this.env = null;
        this.mdl = null;
        this.group = null;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JRadioButton)) continue;
            ((JRadioButton)componentArray[i]).removeActionListener(this);
        }
        this.removeAll();
        this.setEnabled(true);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getLayout() != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.isFirstEvent = true;
    }

    private InvRadioButton[] getButtons(int n) {
        InvRadioButton[] invRadioButtonArray = new InvRadioButton[n];
        Iterator iterator = this.buttonCache.iterator();
        int n2 = 0;
        while (iterator.hasNext() && n2 < n) {
            invRadioButtonArray[n2] = (InvRadioButton)iterator.next();
            if (invRadioButtonArray[n2] == null) continue;
            invRadioButtonArray[n2].setEnabled(true);
            invRadioButtonArray[n2].setSelected(false);
            ++n2;
        }
        while (n2 < n) {
            invRadioButtonArray[n2] = this.createButton();
            this.buttonCache.add((Object)invRadioButtonArray[n2]);
            ++n2;
        }
        return invRadioButtonArray;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setForeground(color);
        }
    }

    @Override
    public void requestFocus() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length > 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof InvRadioButton) || !((InvRadioButton)componentArray[i]).isSelected()) continue;
                componentArray[i].requestFocus();
                return;
            }
            componentArray[0].requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof InvRadioButton) || !((InvRadioButton)componentArray[i]).isSelected()) continue;
            return componentArray[i].requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void setUseTitle(boolean bl) {
        if (this.useTitle != bl) {
            this.useTitle = bl;
            if (this.env != null) {
                this.setBorder(new TitledBorder(this.env.getFeatureDescriptor().getDisplayName()));
            }
        }
    }

    @Override
    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        if (!this.tableUI && propertyEnv != null && this.useTitle) {
            this.setBorder(new TitledBorder(propertyEnv.getFeatureDescriptor().getDisplayName()));
        } else {
            this.setBorder(null);
        }
        this.editor = propertyEditor;
        String[] stringArray = this.editor.getTags();
        this.group = new ButtonGroup();
        InvRadioButton[] invRadioButtonArray = this.getButtons(stringArray.length);
        if (propertyEnv != null) {
            this.setEnabled(propertyEnv.isEditable());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            InvRadioButton invRadioButton = invRadioButtonArray[i];
            this.configureButton(invRadioButton, stringArray[i]);
            this.add(invRadioButton);
        }
    }

    protected InvRadioButton createButton() {
        return new InvRadioButton();
    }

    protected void configureButton(InvRadioButton invRadioButton, String string) {
        invRadioButton.addActionListener(this);
        if (this.editor.getTags().length == 1) {
            invRadioButton.setEnabled(false);
        } else {
            invRadioButton.setEnabled(this.isEnabled());
        }
        if (this.tableUI) {
            invRadioButton.setFocusable(false);
        } else {
            invRadioButton.setFocusable(true);
        }
        invRadioButton.setText(string);
        if (string.equals(this.editor.getAsText())) {
            invRadioButton.setSelected(true);
        } else {
            invRadioButton.setSelected(false);
        }
        invRadioButton.setFont(this.getFont());
        invRadioButton.setBackground(this.getBackground());
        invRadioButton.setForeground(this.getForeground());
        this.group.add(invRadioButton);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public KeyStroke[] getKeyStrokes() {
        return null;
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    @Override
    public PropertyModel getPropertyModel() {
        return this.mdl;
    }

    @Override
    public Object getValue() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JRadioButton) || this.group.getSelection() != ((JRadioButton)componentArray[i]).getModel()) continue;
            String string = ((JRadioButton)componentArray[i]).getText();
            return string;
        }
        return null;
    }

    public void handleInitialInputEvent(InputEvent inputEvent) {
        System.err.println("HandleInitialInputEvent");
        this.getLayout().layoutContainer(this);
        if (inputEvent instanceof MouseEvent) {
            Point point = SwingUtilities.convertPoint((JComponent)inputEvent.getSource(), ((MouseEvent)inputEvent).getPoint(), this);
            Component component = this.getComponentAt(point);
            if (component instanceof JRadioButton) {
                ((JRadioButton)component).setSelected(true);
                component.requestFocus();
                this.fireActionPerformed(new ActionEvent(this, 1001, "success"));
            }
        } else {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JRadioButton) || !((JRadioButton)componentArray[i]).isSelected()) continue;
                componentArray[i].requestFocusInWindow();
            }
        }
    }

    @Override
    public boolean isKnownComponent(Component component) {
        return component != null && (component == this || component instanceof InvRadioButton);
    }

    @Override
    public void reset() {
        this.setValue(this.editor.getAsText());
    }

    @Override
    public void setPropertyModel(PropertyModel propertyModel) {
        this.mdl = propertyModel;
    }

    @Override
    public void setValue(Object object) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JRadioButton)) continue;
            if (((JRadioButton)componentArray[i]).getText().equals(object)) {
                ((JRadioButton)componentArray[i]).setSelected(true);
                continue;
            }
            ((JRadioButton)componentArray[i]).setSelected(false);
        }
    }

    @Override
    public boolean supportsTextEntry() {
        return false;
    }

    @Override
    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList<ActionListener>();
        }
        this.actionListenerList.add(actionListener);
    }

    @Override
    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed(ActionEvent actionEvent) {
        ArrayList<ActionListener> arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.actionListenerList == null) {
                return;
            }
            arrayList = new ArrayList<ActionListener>(this.actionListenerList);
        }
        serializable = arrayList;
        if (this.tableUI) {
            SwingUtilities.invokeLater(new Runnable((List)((Object)serializable), actionEvent){
                final /* synthetic */ List val$theList;
                final /* synthetic */ ActionEvent val$event;
                {
                    this.val$theList = list;
                    this.val$event = actionEvent;
                }

                @Override
                public void run() {
                    for (int i = 0; i < this.val$theList.size(); ++i) {
                        ((ActionListener)this.val$theList.get(i)).actionPerformed(this.val$event);
                    }
                }
            });
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((ActionListener)serializable.get(i)).actionPerformed(actionEvent);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = new ActionEvent(this, 1001, "success");
        this.fireActionPerformed(actionEvent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            super.paint(graphics);
        } else {
            this.getLayout().layoutContainer(this);
            Component[] componentArray = this.getComponents();
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (int i = 0; i < componentArray.length; ++i) {
                    Rectangle rectangle = componentArray[i].getBounds();
                    if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) continue;
                    Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    try {
                        componentArray[i].paint(graphics2);
                        continue;
                    }
                    finally {
                        graphics2.dispose();
                    }
                }
                if (this.getBorder() != null) {
                    super.paintBorder(graphics);
                }
            }
            finally {
                graphics.setColor(color);
            }
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isFirstEvent) {
            this.handleInitialInputEvent(mouseEvent);
            this.isFirstEvent = false;
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    @Override
    public Component getComponentAt(int n, int n2) {
        this.getLayout().layoutContainer(this);
        Component component = super.getComponentAt(n, n2);
        System.err.println("getComponentAt " + n + "," + n2 + " returning " + component.getName());
        return component;
    }

    class InvRadioButton
    extends JRadioButton {
        @Override
        public String getName() {
            return "InvRadioButton - " + this.getText();
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
            if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) && keyEvent.getID() == 401) {
                RadioInplaceEditor.this.fireActionPerformed(new ActionEvent(this, 1001, keyEvent.getKeyCode() == 10 ? "success" : "failure"));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int n = 0;
            int n2 = 0;
            Graphics graphics = PropUtils.getScratchGraphics(this);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            if (this.getIcon() != null) {
                n = this.getIcon().getIconWidth();
                n2 = this.getIcon().getIconHeight();
            }
            if (this.getBorder() != null) {
                Insets insets = this.getBorder().getBorderInsets(this);
                n += insets.left + insets.right;
                n2 += insets.bottom + insets.top;
            }
            n2 = Math.max(fontMetrics.getHeight(), n2) + 2;
            return new Dimension(n += fontMetrics.stringWidth(this.getText()) + 22, n2);
        }
    }
}

