/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.sasl.SaslException;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.jmx.CredentialsProvider;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.jmx.impl.CredentialsConfigurator;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxModelImpl;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ProxyClient
implements NotificationListener {
    private static final Logger LOGGER = Logger.getLogger(ProxyClient.class.getName());
    private static final int MODE_SELF = 0;
    private static final int MODE_LOCAL = 1;
    private static final int MODE_GENERIC = 2;
    private final int mode;
    private JmxModel.ConnectionState connectionState = JmxModel.ConnectionState.DISCONNECTED;
    private volatile boolean isDead = true;
    private String user = null;
    private char[] pword = null;
    private JmxModelImpl.LocalVirtualMachine lvm;
    private JMXServiceURL jmxUrl = null;
    private Application app;
    private EnvironmentProvider envProvider = null;
    private MBeanServerConnection conn = null;
    private JMXConnector jmxc = null;
    private static final SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
    private boolean insecure;
    private boolean checkSSLStub;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    ProxyClient(Application app) throws IOException {
        this.app = app;
        this.mode = 0;
    }

    ProxyClient(Application app, JmxModelImpl.LocalVirtualMachine lvm) throws IOException {
        this.app = app;
        this.mode = 1;
        this.lvm = lvm;
    }

    ProxyClient(Application app, int port) throws IOException {
        this(app, new JMXServiceURL("rmi", "", 0, ProxyClient.createUrl(app.getHost().getHostName(), port)), null);
    }

    ProxyClient(Application app, String url) throws IOException {
        this(app, new JMXServiceURL(url), null);
    }

    ProxyClient(JmxApplication jmxApp) throws IOException {
        this(jmxApp, jmxApp.getJMXServiceURL(), jmxApp.getEnvironmentProvider());
    }

    private ProxyClient(Application app, JMXServiceURL url, EnvironmentProvider envProvider) throws IOException {
        this.mode = 2;
        this.jmxUrl = url;
        this.app = app;
        this.envProvider = envProvider;
    }

    void setCredentials(String user, char[] pword) {
        if (this.envProvider instanceof CredentialsProvider && ((CredentialsProvider)this.envProvider).isPersistent(this.app.getStorage())) {
            CredentialsProvider.Custom epr = new CredentialsProvider.Custom(user, pword, true);
            ((EnvironmentProvider)epr).saveEnvironment(this.app.getStorage());
        } else {
            this.user = user;
            this.pword = pword;
        }
    }

    boolean hasSSLStubCheck() {
        return this.checkSSLStub;
    }

    void setInsecure() {
        this.insecure = true;
    }

    boolean isInsecure() {
        return this.insecure;
    }

    void addConnectionStateListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    void removeConnectionStateListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private static String createUrl(String hostName, int port) {
        return "/jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
    }

    private void setConnectionState(JmxModel.ConnectionState state) {
        JmxModel.ConnectionState oldState = this.connectionState;
        this.connectionState = state;
        this.propertyChangeSupport.firePropertyChange("connectionState", oldState, state);
    }

    JmxModel.ConnectionState getConnectionState() {
        return this.connectionState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void connect() {
        while (true) {
            try {
                this.connectImpl();
                return;
            }
            catch (SecurityException e) {
                LOGGER.log(Level.INFO, "connect", e);
                if (this.hasSSLStubCheck()) {
                    String noSSLProp;
                    Storage storage = this.app.getStorage();
                    String noSSL = storage.getCustomProperty(noSSLProp = "prop_retry_without_ssl");
                    if (noSSL != null && Boolean.parseBoolean(noSSL)) {
                        this.setInsecure();
                        continue;
                    }
                    String conn = storage.getCustomProperty("prop_name");
                    if (conn == null) {
                        conn = storage.getCustomProperty("prop_suggested_name");
                    }
                    if (conn == null) {
                        conn = this.getUrl().toString();
                    }
                    String msg = NbBundle.getMessage(ProxyClient.class, (String)"MSG_Insecure_SSL", (Object)conn);
                    String title = NbBundle.getMessage(ProxyClient.class, (String)"Title_Insecure_SSL");
                    String retry = NbBundle.getMessage(ProxyClient.class, (String)"Retry_Insecure_SSL");
                    JLabel l = new JLabel(msg);
                    JCheckBox c = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)c, (String)retry);
                    c.setSelected(noSSL == null);
                    JPanel p = new JPanel(new BorderLayout(0, 20));
                    p.add((Component)l, "Center");
                    p.add((Component)c, "South");
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)p, title, 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != NotifyDescriptor.YES_OPTION) return;
                    storage.setCustomProperty(noSSLProp, Boolean.toString(c.isSelected()));
                    this.setInsecure();
                    continue;
                }
                if (this.supplyCredentials() == null) return;
                continue;
            }
            break;
        }
    }

    CredentialsConfigurator supplyCredentials() {
        CredentialsConfigurator jsc;
        String displayName = this.app.getStorage().getCustomProperty("prop_name");
        if (displayName == null) {
            displayName = this.getUrl().toString();
        }
        if ((jsc = CredentialsConfigurator.supplyCredentials(displayName)) != null) {
            this.setCredentials(jsc.getUsername(), jsc.getPassword());
        } else if (this.app instanceof JmxApplication) {
            ((JmxApplication)this.app).disableHeartbeat();
        }
        return jsc;
    }

    private void connectImpl() {
        block5: {
            this.setConnectionState(JmxModel.ConnectionState.CONNECTING);
            try {
                this.tryConnect();
                this.setConnectionState(JmxModel.ConnectionState.CONNECTED);
            }
            catch (SecurityException e) {
                this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
                throw e;
            }
            catch (SaslException e) {
                throw new SecurityException(e);
            }
            catch (Exception e) {
                this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
                if (e.toString().contains("com.sun.enterprise.security.LoginException")) {
                    throw new SecurityException("Authentication failed! Invalid username or password");
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block5;
                String param = this.lvm != null ? String.valueOf(this.lvm.vmid()) : (this.jmxUrl != null ? this.jmxUrl.toString() : "");
                LOGGER.log(Level.FINE, "connect(" + param + ")", e);
            }
        }
    }

    private void tryConnect() throws IOException {
        if (this.mode == 0) {
            this.jmxc = null;
            this.conn = ManagementFactory.getPlatformMBeanServer();
        } else {
            if (this.mode == 1) {
                if (!this.lvm.isManageable()) {
                    this.lvm.startManagementAgent();
                    if (!this.lvm.isManageable()) {
                        throw new IOException(this.lvm + " not manageable");
                    }
                }
                if (this.jmxUrl == null) {
                    this.jmxUrl = new JMXServiceURL(this.lvm.connectorAddress());
                }
            }
            HashMap<String, Object> env = new HashMap<String, Object>();
            if (this.envProvider != null) {
                env.putAll(this.envProvider.getEnvironment(this.app, this.app.getStorage()));
            }
            if (this.user != null || this.pword != null) {
                env.put("jmx.remote.credentials", new String[]{this.user, new String(this.pword)});
            }
            if (!this.insecure && this.mode != 1 && env.get("jmx.remote.credentials") != null) {
                env.put("jmx.remote.x.check.stub", "true");
                this.checkSSLStub = true;
            } else {
                this.checkSSLStub = false;
            }
            this.jmxc = JMXConnectorFactory.newJMXConnector(this.jmxUrl, env);
            this.jmxc.addConnectionNotificationListener(this, null, null);
            try {
                this.jmxc.connect(env);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "tryConnect", e);
                if ("rmi".equals(this.jmxUrl.getProtocol())) {
                    env.put("com.sun.jndi.rmi.factory.socket", sslRMIClientSocketFactory);
                    this.jmxc.connect(env);
                }
                throw e;
            }
            MBeanServerConnection mbsc = this.jmxc.getMBeanServerConnection();
            this.conn = JmxModelImpl.Checker.newChecker(this, mbsc);
        }
        this.isDead = false;
    }

    MBeanServerConnection getMBeanServerConnection() {
        return this.conn;
    }

    JMXServiceURL getUrl() {
        return this.jmxUrl;
    }

    void disconnect() {
        this.disconnectImpl(true);
    }

    synchronized void disconnectImpl(boolean sendClose) {
        if (this.jmxc != null) {
            try {
                this.jmxc.removeConnectionNotificationListener(this);
                if (sendClose) {
                    this.jmxc.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (ListenerNotFoundException e) {
                LOGGER.log(Level.INFO, "disconnectImpl", e);
            }
            this.jmxc = null;
        }
        if (!this.isDead) {
            this.isDead = true;
            this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
        }
    }

    synchronized void markAsDead() {
        this.disconnect();
    }

    boolean isDead() {
        return this.isDead;
    }

    boolean isConnected() {
        return !this.isDead();
    }

    @Override
    public void handleNotification(Notification n, Object hb) {
        if (n instanceof JMXConnectionNotification && ("jmx.remote.connection.failed".equals(n.getType()) || "jmx.remote.connection.closed".equals(n.getType()))) {
            this.markAsDead();
        }
    }
}

