/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ConstantPoolExtension;
import org.graalvm.visualvm.lib.jfluid.instrumentation.JavaClassConstants;

public class CPExtensionsRepository
implements JavaClassConstants,
CommonConstants {
    public static int normalContents_MethodEntryMethodIdx;
    public static int normalContents_MethodExitMethodIdx;
    public static int normalContents_ProfilePointHitMethodIdx;
    public static int rootContents_RootEntryMethodIdx;
    public static int rootContents_MarkerEntryMethodIdx;
    public static int miContents_AddParCharMethodIdx;
    public static int miContents_AddParByteMethodIdx;
    public static int miContents_AddParIntMethodIdx;
    public static int miContents_AddParBooleanMethodIdx;
    public static int miContents_AddParFloatMethodIdx;
    public static int miContents_AddParDoubleMethodIdx;
    public static int miContents_AddParShortMethodIdx;
    public static int miContents_AddParLongMethodIdx;
    public static int miContents_AddParObjectMethodIdx;
    public static int rootContents_MarkerExitMethodIdx;
    public static int rootContents_MarkerExitParMethodIdx;
    public static int miContents_HandleReflectInvokeMethodIdx;
    public static int miContents_HandleServletDoMethodIdx;
    public static int codeRegionContents_CodeRegionEntryMethodIdx;
    public static int codeRegionContents_CodeRegionExitMethodIdx;
    public static int memoryProfContents_ProfilePointHitMethodIdx;
    public static int memoryProfContents_TraceObjAllocMethodIdx;
    private static final String PROFRUNTIME_CPU_CLASS_NAME = "org/graalvm/visualvm/lib/jfluid/server/ProfilerRuntimeCPU";
    private static final String PROFRUNTIME_CPUFULL_CLASS_NAME = "org/graalvm/visualvm/lib/jfluid/server/ProfilerRuntimeCPUFullInstr";
    private static final String PROFRUNTIME_CPUSAMPLED_CLASS_NAME = "org/graalvm/visualvm/lib/jfluid/server/ProfilerRuntimeCPUSampledInstr";
    private static final String PROFRUNTIME_CPUCODEREGION_CLASS_NAME = "org/graalvm/visualvm/lib/jfluid/server/ProfilerRuntimeCPUCodeRegion";
    private static final String PROFRUNTIME_OBJALLOC_CLASS_NAME = "org/graalvm/visualvm/lib/jfluid/server/ProfilerRuntimeObjAlloc";
    private static final String PROFRUNTIME_OBJLIVENESS_CLASS_NAME = "org/graalvm/visualvm/lib/jfluid/server/ProfilerRuntimeObjLiveness";
    private static final String ROOT_ENTRY_METHOD_NAME = "rootMethodEntry";
    private static final String MARKER_ENTRY_METHOD_NAME = "markerMethodEntry";
    private static final String MARKER_EXIT_METHOD_NAME = "markerMethodExit";
    private static final String METHOD_ENTRY_METHOD_NAME = "methodEntry";
    private static final String METHOD_EXIT_METHOD_NAME = "methodExit";
    private static final String HANDLE_REFLECT_INVOKE_METHOD_NAME = "handleJavaLangReflectMethodInvoke";
    private static final String CODE_REGION_ENTRY_METHOD_NAME = "codeRegionEntry";
    private static final String CODE_REGION_EXIT_METHOD_NAME = "codeRegionExit";
    private static final String TRACE_OBJ_ALLOC_METHOD_NAME = "traceObjAlloc";
    private static final String PROFILE_POINT_HIT = "profilePointHit";
    private static final String HANDLE_SERVLET_DO_METHOD_NAME = "handleServletDoMethod";
    private static final String ADD_PARAMETER = "addParameter";
    private static final String VOID_VOID_SIGNATURE = "()V";
    private static final String CHAR_VOID_SIGNATURE = "(C)V";
    private static final String BYTE_VOID_SIGNATURE = "(B)V";
    private static final String INT_VOID_SIGNATURE = "(I)V";
    private static final String BOOLEAN_VOID_SIGNATURE = "(Z)V";
    private static final String FLOAT_VOID_SIGNATURE = "(F)V";
    private static final String DOUBLE_VOID_SIGNATURE = "(D)V";
    private static final String SHORT_VOID_SIGNATURE = "(S)V";
    private static final String LONG_VOID_SIGNATURE = "(J)V";
    private static final String OBJECT_VOID_SIGNATURE = "(Ljava/lang/Object;)V";
    private static final String OBJECT_CHAR_VOID_SIGNATURE = "(Ljava/lang/Object;C)V";
    private static final String REFLECT_METHOD_VOID_SIGNATURE = "(Ljava/lang/reflect/Method;)V";
    private static final String JAVA_LANG_THROWABLE_NAME = "java/lang/Throwable";
    private static final String STACK_MAP_TABLE_ATTRIBUTE = "StackMapTable";
    private static ConstantPoolExtension.PackedCPFragment[] standardCPFragments;

    public static ConstantPoolExtension.PackedCPFragment getStandardCPFragment(int injectionType) {
        return standardCPFragments[injectionType];
    }

    private static void initCommonAddedContents() {
        int i;
        standardCPFragments = new ConstantPoolExtension.PackedCPFragment[13];
        ConstantPoolExtension.CPEntry[] entries = new ConstantPoolExtension.CPEntry[12];
        int methodEntryMethodRefIdx = i = 0;
        int methodExitMethodRefIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPUFULL_CLASS_NAME, METHOD_ENTRY_METHOD_NAME, CHAR_VOID_SIGNATURE, entries, i);
        int profilePointHitMethodRefIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPUFULL_CLASS_NAME, METHOD_EXIT_METHOD_NAME, CHAR_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.addMethod(PROFRUNTIME_CPUFULL_CLASS_NAME, PROFILE_POINT_HIT, CHAR_VOID_SIGNATURE, entries, i);
        int profilerRuntimeClassRefIdx = CPExtensionsRepository.getClassCPEntryIndex(PROFRUNTIME_CPUFULL_CLASS_NAME, entries);
        int charVoidSignatureIdx = CPExtensionsRepository.getUtf8CPEntryIndex(CHAR_VOID_SIGNATURE, entries);
        CPExtensionsRepository.standardCPFragments[0] = new ConstantPoolExtension.PackedCPFragment(entries);
        normalContents_ProfilePointHitMethodIdx = profilePointHitMethodRefIdx;
        normalContents_MethodEntryMethodIdx = methodEntryMethodRefIdx;
        normalContents_MethodExitMethodIdx = methodExitMethodRefIdx;
        entries[CPExtensionsRepository.getUtf8CPEntryIndex((String)PROFRUNTIME_CPUFULL_CLASS_NAME, (ConstantPoolExtension.CPEntry[])entries)] = new ConstantPoolExtension.CPEntry(PROFRUNTIME_CPUSAMPLED_CLASS_NAME);
        CPExtensionsRepository.standardCPFragments[3] = new ConstantPoolExtension.PackedCPFragment(entries);
        entries = new ConstantPoolExtension.CPEntry[3];
        CPExtensionsRepository.addMethod(profilerRuntimeClassRefIdx + 65536, ROOT_ENTRY_METHOD_NAME, charVoidSignatureIdx + 65536, entries, 0);
        CPExtensionsRepository.standardCPFragments[1] = new ConstantPoolExtension.PackedCPFragment(entries);
        rootContents_RootEntryMethodIdx = 0;
        CPExtensionsRepository.standardCPFragments[4] = new ConstantPoolExtension.PackedCPFragment(entries);
        entries = new ConstantPoolExtension.CPEntry[39];
        int markerEntryMethodRefIdx = i = 0;
        int markerExitMethodRefIdx = i = CPExtensionsRepository.addMethod(profilerRuntimeClassRefIdx + 65536, MARKER_ENTRY_METHOD_NAME, charVoidSignatureIdx + 65536, entries, i);
        rootContents_MarkerExitParMethodIdx = i = CPExtensionsRepository.addMethod(profilerRuntimeClassRefIdx + 65536, MARKER_EXIT_METHOD_NAME, charVoidSignatureIdx + 65536, entries, i);
        miContents_AddParCharMethodIdx = i = CPExtensionsRepository.addMethod(profilerRuntimeClassRefIdx + 65536, MARKER_EXIT_METHOD_NAME, OBJECT_CHAR_VOID_SIGNATURE, entries, i);
        miContents_AddParByteMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, CHAR_VOID_SIGNATURE, entries, i);
        miContents_AddParIntMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, BYTE_VOID_SIGNATURE, entries, i);
        miContents_AddParBooleanMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, INT_VOID_SIGNATURE, entries, i);
        miContents_AddParFloatMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, BOOLEAN_VOID_SIGNATURE, entries, i);
        miContents_AddParDoubleMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, FLOAT_VOID_SIGNATURE, entries, i);
        miContents_AddParShortMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, DOUBLE_VOID_SIGNATURE, entries, i);
        miContents_AddParLongMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, SHORT_VOID_SIGNATURE, entries, i);
        miContents_AddParObjectMethodIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, LONG_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, ADD_PARAMETER, OBJECT_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.standardCPFragments[2] = new ConstantPoolExtension.PackedCPFragment(entries);
        rootContents_MarkerEntryMethodIdx = markerEntryMethodRefIdx;
        rootContents_MarkerExitMethodIdx = markerExitMethodRefIdx;
        CPExtensionsRepository.standardCPFragments[5] = new ConstantPoolExtension.PackedCPFragment(entries);
        entries = new ConstantPoolExtension.CPEntry[6];
        CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, HANDLE_REFLECT_INVOKE_METHOD_NAME, REFLECT_METHOD_VOID_SIGNATURE, entries, 0);
        CPExtensionsRepository.standardCPFragments[6] = new ConstantPoolExtension.PackedCPFragment(entries);
        miContents_HandleReflectInvokeMethodIdx = 0;
        entries = new ConstantPoolExtension.CPEntry[6];
        CPExtensionsRepository.addMethod(PROFRUNTIME_CPU_CLASS_NAME, HANDLE_SERVLET_DO_METHOD_NAME, OBJECT_VOID_SIGNATURE, entries, 0);
        CPExtensionsRepository.standardCPFragments[7] = new ConstantPoolExtension.PackedCPFragment(entries);
        miContents_HandleServletDoMethodIdx = 0;
        entries = new ConstantPoolExtension.CPEntry[9];
        int codeRegionEntryMethodRefIdx = i = 0;
        int codeRegionExitMethodRefIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_CPUCODEREGION_CLASS_NAME, CODE_REGION_ENTRY_METHOD_NAME, VOID_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.addMethod(PROFRUNTIME_CPUCODEREGION_CLASS_NAME, CODE_REGION_EXIT_METHOD_NAME, VOID_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.standardCPFragments[8] = new ConstantPoolExtension.PackedCPFragment(entries);
        codeRegionContents_CodeRegionEntryMethodIdx = codeRegionEntryMethodRefIdx;
        codeRegionContents_CodeRegionExitMethodIdx = codeRegionExitMethodRefIdx;
        entries = new ConstantPoolExtension.CPEntry[10];
        int objAllocTraceMethodRefIdx = i = 0;
        int memPprofilePointHitMethodRefIdx = i = CPExtensionsRepository.addMethod(PROFRUNTIME_OBJALLOC_CLASS_NAME, TRACE_OBJ_ALLOC_METHOD_NAME, OBJECT_CHAR_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.addMethod(PROFRUNTIME_OBJALLOC_CLASS_NAME, PROFILE_POINT_HIT, CHAR_VOID_SIGNATURE, entries, i);
        CPExtensionsRepository.standardCPFragments[9] = new ConstantPoolExtension.PackedCPFragment(entries);
        memoryProfContents_TraceObjAllocMethodIdx = objAllocTraceMethodRefIdx;
        memoryProfContents_ProfilePointHitMethodIdx = memPprofilePointHitMethodRefIdx;
        entries[CPExtensionsRepository.getUtf8CPEntryIndex((String)PROFRUNTIME_OBJALLOC_CLASS_NAME, (ConstantPoolExtension.CPEntry[])entries)] = new ConstantPoolExtension.CPEntry(PROFRUNTIME_OBJLIVENESS_CLASS_NAME);
        CPExtensionsRepository.standardCPFragments[10] = new ConstantPoolExtension.PackedCPFragment(entries);
        entries = new ConstantPoolExtension.CPEntry[]{new ConstantPoolExtension.CPEntry(STACK_MAP_TABLE_ATTRIBUTE)};
        CPExtensionsRepository.standardCPFragments[11] = new ConstantPoolExtension.PackedCPFragment(entries);
        entries = new ConstantPoolExtension.CPEntry[2];
        CPExtensionsRepository.addClass(JAVA_LANG_THROWABLE_NAME, entries, 0);
        CPExtensionsRepository.standardCPFragments[12] = new ConstantPoolExtension.PackedCPFragment(entries);
    }

    static int addMethod(int classRefIdx, String methodName, int signatureIdx, ConstantPoolExtension.CPEntry[] entries, int index) {
        int methodRef = index;
        entries[index++] = new ConstantPoolExtension.CPEntry(10);
        int nameAndTypeIdx = index;
        index = CPExtensionsRepository.addNameAndType(methodName, signatureIdx, entries, index);
        entries[methodRef].setIndex1(classRefIdx);
        entries[methodRef].setIndex2(nameAndTypeIdx);
        return index;
    }

    static int addMethod(int classRefIdx, String methodName, String signature, ConstantPoolExtension.CPEntry[] entries, int index) {
        int methodRef = index;
        entries[index++] = new ConstantPoolExtension.CPEntry(10);
        int nameAndTypeIdx = index;
        index = CPExtensionsRepository.addNameAndType(methodName, signature, entries, index);
        entries[methodRef].setIndex1(classRefIdx);
        entries[methodRef].setIndex2(nameAndTypeIdx);
        return index;
    }

    static int addMethod(String className, String methodName, String signature, ConstantPoolExtension.CPEntry[] entries, int index) {
        int methodRef = index;
        entries[index++] = new ConstantPoolExtension.CPEntry(10);
        int classIndex = CPExtensionsRepository.getClassCPEntryIndex(className, entries);
        if (classIndex == -1) {
            classIndex = index;
            index = CPExtensionsRepository.addClass(className, entries, index);
        }
        int nameAndTypeIdx = index;
        index = CPExtensionsRepository.addNameAndType(methodName, signature, entries, index);
        entries[methodRef].setIndex1(classIndex);
        entries[methodRef].setIndex2(nameAndTypeIdx);
        return index;
    }

    static int addClass(String className, ConstantPoolExtension.CPEntry[] entries, int index) {
        entries[index] = new ConstantPoolExtension.CPEntry(7);
        entries[index].setIndex1(index + 1);
        entries[index + 1] = new ConstantPoolExtension.CPEntry(className);
        return index + 2;
    }

    static int addNameAndType(String methodName, String signature, ConstantPoolExtension.CPEntry[] entries, int index) {
        int sigIdx;
        int nameAndTypeIdx = index;
        entries[index++] = new ConstantPoolExtension.CPEntry(12);
        int nameIdx = CPExtensionsRepository.getUtf8CPEntryIndex(methodName, entries);
        if (nameIdx == -1) {
            nameIdx = index;
            entries[index++] = new ConstantPoolExtension.CPEntry(methodName);
        }
        if ((sigIdx = CPExtensionsRepository.getUtf8CPEntryIndex(signature, entries)) == -1) {
            sigIdx = index;
            entries[index++] = new ConstantPoolExtension.CPEntry(signature);
        }
        entries[nameAndTypeIdx].setIndex1(nameIdx);
        entries[nameAndTypeIdx].setIndex2(sigIdx);
        return index;
    }

    static int addNameAndType(String methodName, int signatureIdx, ConstantPoolExtension.CPEntry[] entries, int index) {
        entries[index] = new ConstantPoolExtension.CPEntry(12);
        entries[index].setIndex1(index + 1);
        entries[index].setIndex2(signatureIdx);
        entries[index + 1] = new ConstantPoolExtension.CPEntry(methodName);
        return index + 2;
    }

    static boolean isUtf8CPEntry(ConstantPoolExtension.CPEntry entry, String string) {
        return entry != null && entry.tag == 1 && entry.utf8.equals(string);
    }

    static int getUtf8CPEntryIndex(String string, ConstantPoolExtension.CPEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            if (!CPExtensionsRepository.isUtf8CPEntry(entries[i], string)) continue;
            return i;
        }
        return -1;
    }

    static int getClassCPEntryIndex(String string, ConstantPoolExtension.CPEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            ConstantPoolExtension.CPEntry e = entries[i];
            if (e == null || e.tag != 7 || !CPExtensionsRepository.isUtf8CPEntry(entries[e.index1], string)) continue;
            return i;
        }
        return -1;
    }

    static {
        CPExtensionsRepository.initCommonAddedContents();
    }
}

