/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.util.HashMap;
import java.util.Map;
import org.owasp.encoder.CDATAEncoder;
import org.owasp.encoder.CSSEncoder;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.HTMLEncoder;
import org.owasp.encoder.JavaEncoder;
import org.owasp.encoder.JavaScriptEncoder;
import org.owasp.encoder.URIEncoder;
import org.owasp.encoder.UnsupportedContextException;
import org.owasp.encoder.XMLCommentEncoder;
import org.owasp.encoder.XMLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Encoders {
    public static final String HTML = "html";
    public static final String HTML_CONTENT = "html-content";
    public static final String HTML_ATTRIBUTE = "html-attribute";
    public static final String HTML_UNQUOTED_ATTRIBUTE = "html-attribute-unquoted";
    public static final String XML = "xml";
    public static final String XML_CONTENT = "xml-content";
    public static final String XML_ATTRIBUTE = "xml-attribute";
    public static final String XML_COMMENT = "xml-comment";
    public static final String CDATA = "cdata";
    public static final String CSS_STRING = "css-string";
    public static final String CSS_URL = "css-url";
    public static final String JAVA = "java";
    public static final String JAVASCRIPT = "javascript";
    public static final String JAVASCRIPT_ATTRIBUTE = "javascript-attribute";
    public static final String JAVASCRIPT_BLOCK = "javascript-block";
    public static final String JAVASCRIPT_SOURCE = "javascript-source";
    public static final String URI = "uri";
    public static final String URI_COMPONENT = "uri-component";
    private static final Map<String, Encoder> ENCODERS_MAP = new HashMap<String, Encoder>(32);
    static final XMLEncoder XML_ENCODER = Encoders.map("html", Encoders.map("xml", new XMLEncoder(XMLEncoder.Mode.ALL)));
    static final XMLEncoder XML_CONTENT_ENCODER = Encoders.map("html-content", Encoders.map("xml-content", new XMLEncoder(XMLEncoder.Mode.CONTENT)));
    static final XMLEncoder XML_ATTRIBUTE_ENCODER = Encoders.map("html-attribute", Encoders.map("xml-attribute", new XMLEncoder(XMLEncoder.Mode.ATTRIBUTE)));
    static final XMLCommentEncoder XML_COMMENT_ENCODER = Encoders.map("xml-comment", new XMLCommentEncoder());
    static final CDATAEncoder CDATA_ENCODER = Encoders.map("cdata", new CDATAEncoder());
    static final HTMLEncoder HTML_UNQUOTED_ATTRIBUTE_ENCODER = Encoders.map("html-attribute-unquoted", new HTMLEncoder());
    static final JavaScriptEncoder JAVASCRIPT_ENCODER = Encoders.map("javascript", new JavaScriptEncoder(JavaScriptEncoder.Mode.HTML, false));
    static final JavaScriptEncoder JAVASCRIPT_ATTRIBUTE_ENCODER = Encoders.map("javascript-attribute", new JavaScriptEncoder(JavaScriptEncoder.Mode.ATTRIBUTE, false));
    static final JavaScriptEncoder JAVASCRIPT_BLOCK_ENCODER = Encoders.map("javascript-block", new JavaScriptEncoder(JavaScriptEncoder.Mode.BLOCK, false));
    static final JavaScriptEncoder JAVASCRIPT_SOURCE_ENCODER = Encoders.map("javascript-source", new JavaScriptEncoder(JavaScriptEncoder.Mode.SOURCE, false));
    static final URIEncoder URI_ENCODER = Encoders.map("uri", new URIEncoder(URIEncoder.Mode.FULL_URI));
    static final URIEncoder URI_COMPONENT_ENCODER = Encoders.map("uri-component", new URIEncoder(URIEncoder.Mode.COMPONENT));
    static final JavaEncoder JAVA_ENCODER = Encoders.map("java", new JavaEncoder());
    static final CSSEncoder CSS_STRING_ENCODER = Encoders.map("css-string", new CSSEncoder(CSSEncoder.Mode.STRING));
    static final CSSEncoder CSS_URL_ENCODER = Encoders.map("css-url", new CSSEncoder(CSSEncoder.Mode.URL));

    private static <T extends Encoder> T map(String name, T encoder) {
        Encoder old = ENCODERS_MAP.put(name, encoder);
        assert (old == null);
        return encoder;
    }

    public static Encoder forName(String contextName) throws NullPointerException, UnsupportedContextException {
        if (contextName == null) {
            throw new NullPointerException();
        }
        Encoder encoder = ENCODERS_MAP.get(contextName);
        if (encoder == null) {
            throw new UnsupportedContextException(contextName);
        }
        return encoder;
    }

    private Encoders() {
    }
}

