/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options.extra;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.options.extra.RepositoryOption;

public class RepositoryOptionImpl
implements RepositoryOption {
    private final String repositoryUrl;
    private boolean allowSnapshots;
    private boolean allowReleases;
    private String id;

    public RepositoryOptionImpl(String repositoryUrl) {
        NullArgumentException.validateNotEmpty((String)repositoryUrl, (String)"Repository URL");
        this.repositoryUrl = repositoryUrl;
        this.allowSnapshots = false;
        this.allowReleases = true;
    }

    @Override
    public RepositoryOptionImpl allowSnapshots() {
        this.allowSnapshots = true;
        return this;
    }

    @Override
    public RepositoryOptionImpl disableReleases() {
        this.allowReleases = false;
        return this;
    }

    @Override
    public RepositoryOption id(String _id) {
        this.id = _id;
        return this;
    }

    public String getRepository() {
        if (!this.allowReleases && !this.allowSnapshots) {
            throw new IllegalStateException("Does not make sense to disallow both releases and snapshots.");
        }
        StringBuilder url = new StringBuilder("+");
        url.append(this.repositoryUrl);
        if (this.allowSnapshots) {
            url.append("@snapshots");
        }
        if (!this.allowReleases) {
            url.append("@noreleases");
        }
        if (this.id != null) {
            url.append("@id=");
            url.append(this.id);
        }
        return url.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryOptionImpl");
        sb.append("{url=").append(this.getRepository());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getValue() {
        return this.getRepository();
    }
}

