/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Authentication;
import org.jetbrains.kotlin.org.eclipse.aether.repository.AuthenticationContext;
import org.jetbrains.kotlin.org.eclipse.aether.repository.AuthenticationDigest;

final class ChainedAuthentication
implements Authentication {
    private final Authentication[] authentications;

    ChainedAuthentication(Collection<? extends Authentication> authentications) {
        this.authentications = authentications != null && !authentications.isEmpty() ? authentications.toArray(new Authentication[0]) : new Authentication[0];
    }

    @Override
    public void fill(AuthenticationContext context, String key, Map<String, String> data) {
        Objects.requireNonNull(context, "context cannot be null");
        for (Authentication authentication : this.authentications) {
            authentication.fill(context, key, data);
        }
    }

    @Override
    public void digest(AuthenticationDigest digest) {
        Objects.requireNonNull(digest, "digest cannot be null");
        for (Authentication authentication : this.authentications) {
            authentication.digest(digest);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ChainedAuthentication that = (ChainedAuthentication)obj;
        return Arrays.equals(this.authentications, that.authentications);
    }

    public int hashCode() {
        return Arrays.hashCode(this.authentications);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        for (Authentication authentication : this.authentications) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(authentication);
        }
        return buffer.toString();
    }
}

