/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.NotifyProjectsEvaluatedBuildOperationType;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ProjectsEvaluatedNotifier {
    private static final NotifyProjectsEvaluatedBuildOperationType.Result PROJECTS_EVALUATED_RESULT = new NotifyProjectsEvaluatedBuildOperationType.Result(){};
    private final BuildOperationRunner buildOperationRunner;

    public ProjectsEvaluatedNotifier(BuildOperationRunner buildOperationRunner) {
        this.buildOperationRunner = buildOperationRunner;
    }

    public void notify(GradleInternal gradle) {
        this.buildOperationRunner.run((RunnableBuildOperation)new NotifyProjectsEvaluatedListeners(gradle));
    }

    private static class NotifyProjectsEvaluatedListeners
    implements RunnableBuildOperation {
        private final GradleInternal gradle;

        public NotifyProjectsEvaluatedListeners(GradleInternal gradle) {
            this.gradle = gradle;
        }

        public void run(BuildOperationContext context) {
            this.gradle.getBuildListenerBroadcaster().projectsEvaluated((Gradle)this.gradle);
            context.setResult((Object)PROJECTS_EVALUATED_RESULT);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Notify projectsEvaluated listeners")).details((Object)new NotifyProjectsEvaluatedBuildOperationType.Details(){

                public String getBuildPath() {
                    return gradle.getIdentityPath().toString();
                }
            });
        }
    }
}

