/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.EnumSet;
import org.gradle.internal.buildoption.FeatureFlag;
import org.jspecify.annotations.Nullable;

public class FeaturePreviews {

    public static enum Feature implements FeatureFlag
    {
        GROOVY_COMPILATION_AVOIDANCE(true, null),
        TYPESAFE_PROJECT_ACCESSORS(true, null),
        STABLE_CONFIGURATION_CACHE(true, "org.gradle.configuration-cache.stable"),
        INTERNAL_BUILD_SERVICE_USAGE(true, null),
        ALWAYS_INACTIVE(false, null);

        private final boolean active;
        private final String systemPropertyName;

        public static Feature withName(String name) {
            try {
                return Feature.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("There is no feature named " + name);
            }
        }

        private static EnumSet<Feature> activeFeatures() {
            EnumSet<Feature> activeFeatures = EnumSet.noneOf(Feature.class);
            for (Feature feature : Feature.values()) {
                if (!feature.isActive()) continue;
                activeFeatures.add(feature);
            }
            return activeFeatures;
        }

        private Feature(boolean active, String systemPropertyName) {
            this.active = active;
            this.systemPropertyName = systemPropertyName;
        }

        public boolean isActive() {
            return this.active;
        }

        public @Nullable String getSystemPropertyName() {
            return this.systemPropertyName;
        }
    }
}

