/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.EmptyClassVisitor;
import com.eed3si9n.jarjar.Keep;
import com.eed3si9n.jarjar.PackageRemapper;
import com.eed3si9n.jarjar.PatternElement;
import com.eed3si9n.jarjar.Wildcard;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.JarProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

class KeepProcessor
extends Remapper
implements JarProcessor {
    private final ClassVisitor cv = new ClassRemapper(new EmptyClassVisitor(), this);
    private final List<Wildcard> wildcards;
    private final List<String> roots = new ArrayList<String>();
    private final Map<String, Set<String>> depend = new HashMap<String, Set<String>>();
    private Set<String> currentDependenciesSet;

    public KeepProcessor(List<Keep> list2) {
        this.wildcards = PatternElement.createWildcards(list2);
    }

    public boolean isEnabled() {
        return !this.wildcards.isEmpty();
    }

    public Set<String> getExcludes() {
        HashSet<String> hashSet = new HashSet<String>();
        this.recursiveProcessDependencies(hashSet, this.roots);
        HashSet<String> hashSet2 = new HashSet<String>(this.depend.keySet());
        hashSet2.removeAll(hashSet);
        return hashSet2;
    }

    private void recursiveProcessDependencies(Set<String> set, Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            if (!set.add(string)) continue;
            this.recursiveProcessDependencies(set, (Collection<String>)this.depend.get(string));
        }
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        if (entryStruct.name.endsWith(".class")) {
            String string = entryStruct.name.substring(0, entryStruct.name.length() - 6);
            this.currentDependenciesSet = new HashSet<String>();
            this.depend.put(string, this.currentDependenciesSet);
            try {
                new ClassReader(new ByteArrayInputStream(entryStruct.data)).accept(this.cv, 8);
                this.currentDependenciesSet.remove(string);
            }
            catch (Exception exception) {
                System.err.println("Error reading " + entryStruct.name + ": " + exception.getMessage());
            }
            for (Wildcard wildcard : this.wildcards) {
                if (!wildcard.matches(string)) continue;
                this.roots.add(string);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public String map(String string) {
        if (string.startsWith("java/") || string.startsWith("javax/")) {
            return null;
        }
        this.currentDependenciesSet.add(string);
        return null;
    }

    @Override
    public Object mapValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (PackageRemapper.isArrayForName(string)) {
                this.mapDesc(string.replace('.', '/'));
            } else if (KeepProcessor.isForName(string)) {
                this.map(string.replace('.', '/'));
            }
            return object;
        }
        return super.mapValue(object);
    }

    private static boolean isForName(String string) {
        if (string.equals("")) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

