/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Arrow;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.For;
import guru.nidi.graphviz.attribute.ForAll;
import guru.nidi.graphviz.attribute.ForGraphNode;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.ForNodeLink;
import guru.nidi.graphviz.attribute.MapAttributes;
import java.util.Locale;
import javax.annotation.Nullable;

public final class Style<T extends For>
implements Attributes<T> {
    @Nullable
    private final String value;
    @Nullable
    private final Color color;
    @Nullable
    private final Double width;
    @Nullable
    private final Arrow.DirType dirType;
    public static final Style<ForNodeLink> DASHED = new Style("dashed");
    public static final Style<ForNodeLink> DOTTED = new Style("dotted");
    public static final Style<ForNodeLink> SOLID = new Style("solid");
    public static final Style<ForNodeLink> INVIS = new Style("invis");
    public static final Style<ForNodeLink> BOLD = new Style("bold");
    public static final Style<ForGraphNode> FILLED = new Style("filled");
    public static final Style<ForGraphNode> STRIPED = new Style("striped");
    public static final Style<ForGraphNode> ROUNDED = new Style("rounded");
    public static final Style<ForGraphNode> RADIAL = new Style("radial");
    public static final Style<ForNode> WEDGED = new Style("wedged");
    public static final Style<ForNode> DIAGONALS = new Style("diagonals");

    private Style(@Nullable String value, @Nullable Color color, @Nullable Double width, @Nullable Arrow.DirType dirType) {
        this.value = value;
        this.color = color;
        this.width = width;
        this.dirType = dirType;
    }

    private Style(String value) {
        this(value, null, null, null);
    }

    public static Style<ForLink> tapered(double width) {
        return new Style<ForLink>("tapered", null, width, null);
    }

    public static Style<ForLink> tapered(double width, Arrow.DirType dir) {
        return new Style<ForLink>("tapered", null, width, dir);
    }

    public static Style<ForGraphNode> striped(Color color, Color ... colors) {
        return new Style<ForGraphNode>("striped", color.and(colors), null, null);
    }

    public static Style<ForGraphNode> wedged(Color color, Color ... colors) {
        return new Style<ForGraphNode>("wedged", color.and(colors), null, null);
    }

    public static Style<ForAll> lineWidth(double width) {
        return new Style<ForAll>(null, null, width, null);
    }

    @SafeVarargs
    public static <S extends For> Style<S> combine(Style<? extends S> style, Style<? extends S> ... styles) {
        Style<? extends S> res = Style.and(style, null);
        for (Style<? extends S> s : styles) {
            res = Style.and(res, s);
        }
        return res;
    }

    private static <S extends For> Style<S> and(Style<? extends S> a, @Nullable Style<? extends S> b) {
        return b == null ? new Style(a.value, a.color, a.width, a.dirType) : new Style(b.value == null ? a.value : (a.value == null ? b.value : a.value + "," + b.value), b.color == null ? a.color : b.color, b.width == null ? a.width : b.width, b.dirType == null ? a.dirType : b.dirType);
    }

    @Override
    public Attributes<? super T> applyTo(MapAttributes<? super T> attrs) {
        if (this.value != null) {
            attrs.add("style", this.value);
        }
        if (this.color != null) {
            this.color.applyTo(attrs);
        }
        if (this.width != null) {
            attrs.add("penwidth", this.width);
        }
        if (this.dirType != null) {
            attrs.add("dir", this.dirType.name().toLowerCase(Locale.ENGLISH));
        }
        return attrs;
    }
}

